/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.alert.notification;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.configuration.Configuration;

@DiscriminatorColumn(name="NOTIFICATION_TYPE", discriminatorType=DiscriminatorType.STRING)
@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@NamedQueries(value={@NamedQuery(name="AlertNotification.deleteById", query="DELETE FROM AlertNotification an WHERE an.id IN ( :ids )"), @NamedQuery(name="AlertNotification.deleteByResources", query="DELETE FROM AlertNotification an WHERE an.alertDefinition IN ( SELECT ad FROM AlertDefinition ad WHERE ad.resource.id IN ( :resourceIds ) )"), @NamedQuery(name="AlertNotification.deleteOrphaned", query="DELETE FROM AlertNotification an WHERE an.alertDefinition IS NULL")})
@SequenceGenerator(name="RHQ_ALERT_NOTIFICATION_ID_SEQ", sequenceName="RHQ_ALERT_NOTIFICATION_ID_SEQ")
@Table(name="RHQ_ALERT_NOTIFICATION")
public class AlertNotification
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DELETE_BY_ID = "AlertNotification.deleteById";
    public static final String QUERY_DELETE_BY_RESOURCES = "AlertNotification.deleteByResources";
    public static final String QUERY_DELETE_ORPHANED = "AlertNotification.deleteOrphaned";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="RHQ_ALERT_NOTIFICATION_ID_SEQ")
    @Id
    private int id;
    @JoinColumn(name="ALERT_DEFINITION_ID")
    @ManyToOne
    private AlertDefinition alertDefinition;
    @JoinColumn(name="ALERT_CONFIG_ID", referencedColumnName="ID")
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private Configuration configuration;
    @Column(name="ALERT_SENDER_NAME")
    private String senderName;

    protected AlertNotification() {
    }

    public AlertNotification(AlertDefinition alertDefinition) {
        if (alertDefinition == null) {
            throw new IllegalArgumentException("alertDefinition must be non-null.");
        }
        this.alertDefinition = alertDefinition;
    }

    public AlertNotification(AlertDefinition alertDefinition, Configuration config) {
        if (alertDefinition == null) {
            throw new IllegalArgumentException("alertDefinition must be non-null.");
        }
        this.alertDefinition = alertDefinition;
        this.configuration = config.deepCopy();
    }

    public int getId() {
        return this.id;
    }

    @NotNull
    public AlertDefinition getAlertDefinition() {
        return this.alertDefinition;
    }

    public void setAlertDefinition(AlertDefinition alertDefinition) {
        this.alertDefinition = alertDefinition;
    }

    public AlertNotification copy(boolean copyIds) {
        AlertNotification results = this.copy();
        if (copyIds) {
            results.id = this.id;
        }
        return results;
    }

    protected AlertNotification copy() {
        return new AlertNotification(this.alertDefinition, this.configuration);
    }

    public void prepareForOrphanDelete() {
        this.alertDefinition = null;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

