/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.alert.notification;

import java.io.Serializable;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import org.rhq.core.domain.alert.Alert;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.notification.AlertNotification;
import org.rhq.core.domain.alert.notification.EmailNotification;
import org.rhq.core.domain.alert.notification.RoleNotification;
import org.rhq.core.domain.alert.notification.SubjectNotification;

@Entity
@NamedQueries(value={@NamedQuery(name="AlertNotificationLog.deleteByAlertCtime", query="DELETE AlertNotificationLog anl      WHERE anl.id IN ( SELECT a.alertNotificationLog.id                          FROM Alert a                         WHERE a.ctime BETWEEN :begin AND :end )"), @NamedQuery(name="AlertNotificationLog.deleteByResource", query="DELETE AlertNotificationLog anl      WHERE anl.id IN ( SELECT a.alertNotificationLog.id                          FROM Alert a                         WHERE a.alertDefinition.resource.id = :resourceId )"), @NamedQuery(name="AlertNotificationLog.deleteByResources", query="DELETE AlertNotificationLog anl      WHERE anl.id IN ( SELECT a.alertNotificationLog.id                          FROM Alert a                         WHERE a.alertDefinition.resource.id IN ( :resourceIds ) )")})
@SequenceGenerator(name="RHQ_ALERT_NOTIF_LOG_ID_SEQ", sequenceName="RHQ_ALERT_NOTIF_LOG_ID_SEQ")
@Table(name="RHQ_ALERT_NOTIF_LOG")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AlertNotificationLog
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_DELETE_BY_RESOURCE = "AlertNotificationLog.deleteByResource";
    public static final String QUERY_DELETE_BY_ALERT_CTIME = "AlertNotificationLog.deleteByAlertCtime";
    public static final String QUERY_DELETE_BY_RESOURCES = "AlertNotificationLog.deleteByResources";
    public static final String QUERY_NATIVE_TRUNCATE_SQL = "TRUNCATE TABLE RHQ_ALERT_NOTIF_LOG";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="RHQ_ALERT_NOTIF_LOG_ID_SEQ")
    @Id
    private int id;
    @Column(name="ROLES", nullable=false)
    private String roles;
    @Column(name="SUBJECTS", nullable=false)
    private String subjects;
    @Column(name="EMAILS", nullable=false)
    private String emails;
    @JoinColumn(name="ALERT_ID", referencedColumnName="ID")
    @OneToOne
    @XmlTransient
    private Alert alert;

    protected AlertNotificationLog() {
    }

    public AlertNotificationLog(Alert alert) {
        AlertDefinition alertDefinition = alert.getAlertDefinition();
        StringBuilder rolesBuilder = new StringBuilder();
        StringBuilder subjectsBuilder = new StringBuilder();
        StringBuilder emailsBuilder = new StringBuilder();
        Set<AlertNotification> currentNotifications = alertDefinition.getAlertNotifications();
        for (AlertNotification notification : currentNotifications) {
            if (notification instanceof RoleNotification) {
                if (rolesBuilder.length() != 0) {
                    rolesBuilder.append(", ");
                }
                rolesBuilder.append(((RoleNotification)notification).getRole().getName());
                continue;
            }
            if (notification instanceof SubjectNotification) {
                if (subjectsBuilder.length() != 0) {
                    subjectsBuilder.append(", ");
                }
                subjectsBuilder.append(((SubjectNotification)notification).getSubject().getName());
                continue;
            }
            if (!(notification instanceof EmailNotification)) continue;
            if (emailsBuilder.length() != 0) {
                emailsBuilder.append(", ");
            }
            emailsBuilder.append(((EmailNotification)notification).getEmailAddress());
        }
        this.roles = this.fixup(rolesBuilder);
        this.subjects = this.fixup(subjectsBuilder);
        this.emails = this.fixup(emailsBuilder);
        this.alert = alert;
    }

    private String fixup(StringBuilder builder) {
        if (builder.length() == 0) {
            return "(none)";
        }
        return builder.toString();
    }

    public int getId() {
        return this.id;
    }

    public String getRoles() {
        return this.roles;
    }

    public String getSubjects() {
        return this.subjects;
    }

    public String getEmails() {
        return this.emails;
    }

    public Alert getAlert() {
        return this.alert;
    }

    public void setAlert(Alert alert) {
        this.alert = alert;
    }
}

