/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.alert.notification;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.notification.AlertNotification;
import org.rhq.core.domain.authz.Role;

@DiscriminatorValue(value="ROLE")
@Entity
@NamedQueries(value={@NamedQuery(name="RoleNotification.findAllByAlertDefinitionId", query="SELECT rn   FROM RoleNotification rn  WHERE rn.alertDefinition.id = :alertDefinitionId "), @NamedQuery(name="RoleNotification.findByIds", query="SELECT rn   FROM RoleNotification rn  WHERE rn.id IN ( :ids )"), @NamedQuery(name="SubjectNotification.findByRoleIds", query="SELECT rn   FROM RoleNotification rn  WHERE rn.role.id IN ( :ids )")})
@Deprecated
public class RoleNotification
extends AlertNotification {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_ALL_BY_ALERT_DEFINITION_ID = "RoleNotification.findAllByAlertDefinitionId";
    public static final String QUERY_FIND_BY_IDS = "RoleNotification.findByIds";
    public static final String QUERY_FIND_BY_ROLE_IDS = "SubjectNotification.findByRoleIds";
    @JoinColumn(name="ROLE_ID", referencedColumnName="ID", nullable=true)
    @ManyToOne
    private Role role;

    protected RoleNotification() {
    }

    public RoleNotification(RoleNotification roleNotification) {
        this(roleNotification.getAlertDefinition(), roleNotification.role);
    }

    public RoleNotification(@NotNull AlertDefinition alertDefinition, @NotNull Role role) {
        super(alertDefinition);
        if (role == null) {
            throw new IllegalArgumentException("role must be non-null.");
        }
        this.role = role;
    }

    @NotNull
    public Role getRole() {
        return this.role;
    }

    protected AlertNotification copy() {
        return new RoleNotification(this);
    }

    public void prepareForOrphanDelete() {
        super.prepareForOrphanDelete();
        this.role = null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoleNotification)) {
            return false;
        }
        RoleNotification other = (RoleNotification)obj;
        return !(this.role == null ? other.role != null : !this.role.equals(other.role));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "id=" + this.getId() + ", " + "role=" + this.role + ", " + "]";
    }
}

