/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.alert.notification;

import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.alert.AlertDefinition;
import org.rhq.core.domain.alert.notification.AlertNotification;

@DiscriminatorValue(value="SNMP")
@Entity
@NamedQueries(value={@NamedQuery(name="SnmpNotification.findAllByAlertDefinitionId", query="SELECT sn   FROM SnmpNotification sn  WHERE sn.alertDefinition.id = :alertDefinitionId ")})
@Deprecated
public class SnmpNotification
extends AlertNotification {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_ALL_BY_ALERT_DEFINITION_ID = "SnmpNotification.findAllByAlertDefinitionId";
    private static final int DEFAULT_PORT = 161;
    @Column(name="SNMP_HOST", nullable=false)
    private String host;
    @Column(name="SNMP_PORT", nullable=false)
    private int port;
    @Column(name="SNMP_OID", nullable=false)
    private String oid;

    protected SnmpNotification() {
    }

    public SnmpNotification(SnmpNotification snmpNotification) {
        this(snmpNotification.getAlertDefinition(), snmpNotification.host, snmpNotification.port, snmpNotification.oid);
    }

    public SnmpNotification(AlertDefinition alertDefinition, @NotNull String host, @Nullable Integer port, @NotNull String oid) {
        super(alertDefinition);
        if (host == null) {
            throw new IllegalArgumentException("host must be non-null.");
        }
        this.host = host;
        int n = this.port = port != null ? port : 161;
        if (oid == null) {
            throw new IllegalArgumentException("oid must be non-null.");
        }
        this.oid = oid;
    }

    @NotNull
    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @NotNull
    public String getOid() {
        return this.oid;
    }

    protected AlertNotification copy() {
        return new SnmpNotification(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof SnmpNotification)) {
            return false;
        }
        SnmpNotification that = (SnmpNotification)obj;
        if (this.port != that.port) {
            return false;
        }
        if (!this.host.equalsIgnoreCase(that.host)) {
            return false;
        }
        return this.oid.equals(that.oid);
    }

    public int hashCode() {
        int result = this.host.toLowerCase().hashCode();
        result = 31 * result + this.port;
        result = 31 * result + this.oid.hashCode();
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "id=" + this.getId() + ", " + "host=" + this.host + ", " + "port=" + this.port + ", " + "oid=" + this.oid + ", " + "]";
    }
}

