/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.configuration;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.util.serial.HibernateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DiscriminatorValue(value="list")
@Entity
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class PropertyList
extends Property {
    private static final long serialVersionUID = 1L;
    @Cascade(value={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.DELETE_ORPHAN})
    @OneToMany(mappedBy="parentList", targetEntity=Property.class, fetch=FetchType.EAGER)
    private List<Property> list = new ArrayList<Property>();
    @Transient
    String memberPropertyName;

    public PropertyList() {
    }

    public PropertyList(@NotNull String name) {
        this.setName(name);
    }

    protected PropertyList(PropertyList original, boolean keepId) {
        super(original, keepId);
    }

    public PropertyList(@NotNull String name, Property ... startingList) {
        this(name);
        for (Property property : startingList) {
            this.add(property);
        }
    }

    @NotNull
    public List<Property> getList() {
        if (this.list == null) {
            this.list = new ArrayList<Property>();
        }
        return this.list;
    }

    public void setList(List<Property> list) {
        if (list != null) {
            for (Property property : list) {
                this.add(property);
            }
        }
    }

    public void add(@NotNull Property property) {
        if (this.memberPropertyName == null) {
            this.memberPropertyName = property.getName();
        }
        if (!property.getName().equals(this.memberPropertyName)) {
            throw new IllegalStateException("All properties in a PropertyList must have the same name.");
        }
        this.getList().add(property);
        property.setParentList(this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(HibernateUtil.safeList(this.list));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.list = (List)in.readObject();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof PropertyList)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        PropertyList that = (PropertyList)obj;
        if (this.list == null || this.list.isEmpty()) {
            return that.getList() == null || that.getList().isEmpty();
        }
        return this.list.containsAll(that.getList()) && that.getList().containsAll(this.list);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.list != null && !this.list.isEmpty() ? ((Object)this.list).hashCode() : 0);
        return result;
    }

    @Override
    public PropertyList deepCopy(boolean keepId) {
        PropertyList copy = new PropertyList(this, keepId);
        for (Property property : this.list) {
            copy.add(property.deepCopy(false));
        }
        return copy;
    }

    @Override
    protected void appendToStringInternals(StringBuilder str) {
        super.appendToStringInternals(str);
        str.append(", list=").append(this.getList());
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        for (Property p : this.list) {
            p.setParentList(this);
        }
    }
}

