/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.configuration;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.configuration.AbstractPropertyMap;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.util.serial.HibernateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DiscriminatorValue(value="map")
@Entity
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class PropertyMap
extends Property
implements AbstractPropertyMap {
    private static final long serialVersionUID = 1L;
    @Cascade(value={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.DELETE_ORPHAN})
    @MapKey(name="name")
    @OneToMany(mappedBy="parentMap", fetch=FetchType.EAGER)
    private Map<String, Property> map = new LinkedHashMap<String, Property>();

    public PropertyMap() {
    }

    protected PropertyMap(PropertyMap original, boolean keepId) {
        super(original, keepId);
    }

    public PropertyMap(@NotNull String name) {
        this.setName(name);
    }

    public PropertyMap(@NotNull String name, Property ... startingProperties) {
        this(name);
        for (Property property : startingProperties) {
            this.put(property);
        }
    }

    @Override
    @NotNull
    public Map<String, Property> getMap() {
        if (this.map == null) {
            this.map = new LinkedHashMap<String, Property>();
        }
        return this.map;
    }

    public void setMap(Map<String, Property> map) {
        this.map = map;
    }

    @Override
    public void put(@NotNull Property property) {
        this.getMap().put(property.getName(), property);
        property.setParentMap(this);
    }

    @Override
    public Property get(String name) {
        return this.getMap().get(name);
    }

    @Override
    public PropertySimple getSimple(String name) {
        return (PropertySimple)this.get(name);
    }

    public String getSimpleValue(String name, String defaultValue) {
        PropertySimple property = (PropertySimple)this.getMap().get(name);
        if (property != null && property.getStringValue() != null) {
            return property.getStringValue();
        }
        return defaultValue;
    }

    @Override
    public PropertyList getList(String name) {
        return (PropertyList)this.get(name);
    }

    @Override
    public PropertyMap getMap(String name) {
        return (PropertyMap)this.get(name);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.map = (Map)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(HibernateUtil.safeMap(this.map));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof PropertyMap)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        PropertyMap that = (PropertyMap)obj;
        if (this.map == null || this.map.isEmpty()) {
            return that.getMap() == null || that.getMap().isEmpty();
        }
        return ((Object)this.map).equals(that.getMap());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.map != null && !this.map.isEmpty() ? ((Object)this.map).hashCode() : 0);
        return result;
    }

    @Override
    public PropertyMap deepCopy(boolean keepId) {
        PropertyMap copy = new PropertyMap(this, keepId);
        for (Property property : this.map.values()) {
            copy.put(property.deepCopy(keepId));
        }
        return copy;
    }

    @Override
    protected void appendToStringInternals(StringBuilder str) {
        super.appendToStringInternals(str);
        str.append(", map=").append(this.getMap());
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        for (Property p : this.map.values()) {
            p.setParentMap(this);
        }
    }
}

