/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.configuration;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.DeepCopyable;
import org.rhq.core.util.MessageDigestGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@SequenceGenerator(name="SEQ", sequenceName="RHQ_RAW_CONFIG_ID_SEQ")
@Table(name="RHQ_RAW_CONFIG")
public class RawConfiguration
implements Serializable,
DeepCopyable<RawConfiguration> {
    private static final long serialVersionUID = 1L;
    @GeneratedValue(generator="SEQ", strategy=GenerationType.AUTO)
    @Id
    @Column(name="ID")
    private int id;
    @Column(name="PATH", nullable=true)
    private String path;
    @Column(name="CONTENTS", nullable=false)
    private byte[] contents;
    @Column(name="SHA256", nullable=false)
    private String sha256;
    @Column(name="CTIME", nullable=false)
    private long ctime = System.currentTimeMillis();
    @Column(name="MTIME", nullable=false)
    private long mtime = System.currentTimeMillis();
    @ManyToOne(optional=false)
    @JoinColumn(name="CONFIG_ID", nullable=false)
    private Configuration configuration;
    @Transient
    private MessageDigestGenerator sha256Generator = new MessageDigestGenerator("SHA-256");

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public byte[] getContents() {
        return this.copy(this.contents);
    }

    public void setContents(byte[] newContents) {
        this.contents = this.copy(newContents);
        this.updateSha256();
    }

    private byte[] copy(byte[] original) {
        byte[] copy = new byte[original.length];
        for (int i = 0; i < original.length; ++i) {
            copy[i] = original[i];
        }
        return copy;
    }

    private void updateSha256() {
        this.sha256Generator.add(this.contents);
        this.sha256 = this.sha256Generator.getDigestString();
    }

    public String getSha256() {
        return this.sha256;
    }

    public long getCtime() {
        return this.ctime;
    }

    public void setCtime(long ctime) {
        this.ctime = ctime;
    }

    public long getMtime() {
        return this.mtime;
    }

    public void setMtime(long mtime) {
        this.mtime = mtime;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @PrePersist
    void onPersist() {
        this.mtime = System.currentTimeMillis();
        this.ctime = System.currentTimeMillis();
    }

    @PreUpdate
    void onUpdate() {
        this.mtime = System.currentTimeMillis();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof RawConfiguration) {
            RawConfiguration that = (RawConfiguration)obj;
            if (this.sha256 != null && this.sha256.equals(that.sha256)) {
                if (this.path == null && that.path == null) {
                    return true;
                }
                if (this.path != null && that.path != null && this.path.equals(that.path)) {
                    return true;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.sha256 == null) {
            return 0;
        }
        if (this.path == null) {
            return this.sha256.hashCode() * 37;
        }
        return this.sha256.hashCode() * this.path.hashCode() * 37;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", path=" + this.path + ", sha256=" + this.sha256 + ", configuration=" + this.configuration + "]";
    }

    @Override
    public RawConfiguration deepCopy(boolean keepId) {
        RawConfiguration copy = new RawConfiguration();
        if (keepId) {
            copy.id = this.id;
        }
        copy.path = this.path;
        if (this.contents != null) {
            copy.setContents(this.getContents());
        }
        return copy;
    }
}

