/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.configuration;

import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import org.rhq.core.domain.configuration.AbstractResourceConfigurationUpdate;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.group.GroupResourceConfigurationUpdate;
import org.rhq.core.domain.resource.Resource;

@DiscriminatorValue(value="resource")
@Entity
@NamedQueries(value={@NamedQuery(name="ResourceConfigurationUpdate.findAllInStatus", query="SELECT cu   FROM ResourceConfigurationUpdate cu  WHERE cu.status = :status"), @NamedQuery(name="ResourceConfigurationUpdate.findAllByResourceId", query="SELECT cu   FROM ResourceConfigurationUpdate cu   JOIN cu.resource res  WHERE ( res.id = :resourceId OR :resourceId IS NULL )    AND ( cu.createdTime > :startTime OR :startTime IS NULL )    AND ( cu.modifiedTime < :endTime OR :endTime IS NULL )    AND ( :includeAll = 1          OR ( :includeAll <> 1               AND               cu.modifiedTime <> (SELECT MIN(icu.modifiedTime)                                     FROM ResourceConfigurationUpdate icu                                    WHERE icu.resource.id = res.id)             )        )"), @NamedQuery(name="ResourceConfigurationUpdate.findCurrentlyActiveConfig", query="SELECT cu   FROM ResourceConfigurationUpdate cu  WHERE cu.resource.id = :resourceId    AND cu.status = 'SUCCESS'    AND cu.modifiedTime = ( SELECT MAX(cu2.modifiedTime)                              FROM ResourceConfigurationUpdate cu2                             WHERE cu2.resource.id = :resourceId                               AND cu2.status = 'SUCCESS' ) "), @NamedQuery(name="ResourceConfigurationUpdate.findByLatestByResourceId", query="SELECT cu   FROM ResourceConfigurationUpdate cu  WHERE cu.resource.id = :resourceId    AND cu.modifiedTime = ( SELECT MAX(cu2.modifiedTime)                              FROM ResourceConfigurationUpdate cu2                             WHERE cu2.resource.id = :resourceId ) "), @NamedQuery(name="ResourceConfigurationUpdate.findByGroupIdAndStatus", query="SELECT cu.resource   FROM ResourceConfigurationUpdate cu JOIN cu.resource.explicitGroups rg  WHERE rg.id = :groupId    AND cu.status = :status"), @NamedQuery(name="ResourceConfigurationUpdate.findByParentUpdateIdAndStatus", query="SELECT cu.resource   FROM ResourceConfigurationUpdate cu  WHERE cu.groupConfigurationUpdate.id = :parentUpdateId    AND cu.status = :status"), @NamedQuery(name="ResourceConfigurationUpdate.findCompositeByParentUpdateId", query="SELECT new org.rhq.core.domain.configuration.composite.ConfigurationUpdateComposite       ( cu.id, cu.status, cu.errorMessage, cu.subjectName, cu.createdTime, cu.modifiedTime,          res.id, res.name )   FROM ResourceConfigurationUpdate cu   JOIN cu.resource res  WHERE cu.groupConfigurationUpdate.id = :groupConfigurationUpdateId"), @NamedQuery(name="ResourceConfigurationUpdate.findByParentUpdateId", query="SELECT cu.id   FROM ResourceConfigurationUpdate cu  WHERE cu.groupConfigurationUpdate.id = :groupConfigurationUpdateId"), @NamedQuery(name="ResourceConfigurationUpdate.findAllComposites_admin", query="   SELECT new org.rhq.core.domain.configuration.composite.ConfigurationUpdateComposite        ( cu.id, cu.status, cu.errorMessage, cu.subjectName, cu.createdTime, cu.modifiedTime,           res.id, res.name, parent.id, parent.name )      FROM ResourceConfigurationUpdate cu      JOIN cu.resource res LEFT JOIN res.parentResource parent     WHERE (cu.modifiedTime <> (SELECT MIN(icu.modifiedTime)                                  FROM ResourceConfigurationUpdate icu                                 WHERE icu.resource.id = res.id))      AND (UPPER(res.name) LIKE :resourceFilter OR :resourceFilter IS NULL)       AND (UPPER(parent.name) LIKE :parentFilter OR :parentFilter IS NULL)       AND (cu.createdTime > :startTime OR :startTime IS NULL)       AND (cu.modifiedTime < :endTime OR :endTime IS NULL)       AND (cu.status LIKE :status OR :status IS NULL) "), @NamedQuery(name="ResourceConfigurationUpdate.findAllComposites", query="   SELECT new org.rhq.core.domain.configuration.composite.ConfigurationUpdateComposite        ( cu.id, cu.status, cu.errorMessage, cu.subjectName, cu.createdTime, cu.modifiedTime,           res.id, res.name, parent.id, parent.name )      FROM ResourceConfigurationUpdate cu      JOIN cu.resource res LEFT JOIN res.parentResource parent     WHERE res.id IN ( SELECT rr.id FROM Resource rr                         JOIN rr.implicitGroups g JOIN g.roles r JOIN r.subjects s                        WHERE s.id = :subjectId )       AND (cu.modifiedTime <> (SELECT MIN(icu.modifiedTime)                                  FROM ResourceConfigurationUpdate icu                                 WHERE icu.resource.id = res.id))      AND (UPPER(res.name) LIKE :resourceFilter OR :resourceFilter IS NULL)       AND (UPPER(parent.name) LIKE :parentFilter OR :parentFilter IS NULL)       AND (cu.createdTime > :startTime OR :startTime IS NULL)       AND (cu.modifiedTime < :endTime OR :endTime IS NULL)       AND (cu.status LIKE :status OR :status IS NULL) "), @NamedQuery(name="ResourceConfigurationUpdate.deleteByResources0", query="UPDATE Property p    SET p.parentMap = NULL,        p.parentList = NULL  WHERE p.configuration IN ( SELECT rcu.configuration                               FROM ResourceConfigurationUpdate rcu                              WHERE rcu.resource.id IN ( :resourceIds )                            AND NOT rcu.configuration = rcu.resource.resourceConfiguration )"), @NamedQuery(name="ResourceConfigurationUpdate.deleteByResources1", query="DELETE FROM Configuration c  WHERE c IN ( SELECT rcu.configuration                 FROM ResourceConfigurationUpdate rcu                WHERE rcu.resource.id IN ( :resourceIds )                 AND NOT rcu.configuration = rcu.resource.resourceConfiguration )"), @NamedQuery(name="ResourceConfigurationUpdate.deleteByResources2", query="DELETE FROM ResourceConfigurationUpdate rcu  WHERE rcu.resource.id IN ( :resourceIds )"), @NamedQuery(name="ResourceConfigurationUpdate.deleteGroupUpdate", query="UPDATE ResourceConfigurationUpdate rcu    SET rcu.groupConfigurationUpdate = NULL  WHERE rcu.groupConfigurationUpdate IN ( SELECT arcu                                            FROM GroupResourceConfigurationUpdate arcu                                           WHERE arcu.id = :arcuId )"), @NamedQuery(name="ResourceConfigurationUpdate.deleteGroupUpdatesForGroup", query="UPDATE ResourceConfigurationUpdate rcu    SET rcu.groupConfigurationUpdate = NULL  WHERE rcu.groupConfigurationUpdate IN ( SELECT arcu                                            FROM GroupResourceConfigurationUpdate arcu                                           WHERE arcu.group.id = :groupId )")})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ResourceConfigurationUpdate
extends AbstractResourceConfigurationUpdate {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_ALL_IN_STATUS = "ResourceConfigurationUpdate.findAllInStatus";
    public static final String QUERY_FIND_ALL_BY_RESOURCE_ID = "ResourceConfigurationUpdate.findAllByResourceId";
    public static final String QUERY_FIND_CURRENTLY_ACTIVE_CONFIG = "ResourceConfigurationUpdate.findCurrentlyActiveConfig";
    public static final String QUERY_FIND_LATEST_BY_RESOURCE_ID = "ResourceConfigurationUpdate.findByLatestByResourceId";
    public static final String QUERY_FIND_BY_GROUP_ID_AND_STATUS = "ResourceConfigurationUpdate.findByGroupIdAndStatus";
    public static final String QUERY_FIND_BY_PARENT_UPDATE_ID_AND_STATUS = "ResourceConfigurationUpdate.findByParentUpdateIdAndStatus";
    public static final String QUERY_FIND_COMPOSITE_BY_PARENT_UPDATE_ID = "ResourceConfigurationUpdate.findCompositeByParentUpdateId";
    public static final String QUERY_FIND_BY_PARENT_UPDATE_ID = "ResourceConfigurationUpdate.findByParentUpdateId";
    public static final String QUERY_FIND_ALL_COMPOSITES = "ResourceConfigurationUpdate.findAllComposites";
    public static final String QUERY_FIND_ALL_COMPOSITES_ADMIN = "ResourceConfigurationUpdate.findAllComposites_admin";
    public static final String QUERY_DELETE_BY_RESOURCES_0 = "ResourceConfigurationUpdate.deleteByResources0";
    public static final String QUERY_DELETE_BY_RESOURCES_1 = "ResourceConfigurationUpdate.deleteByResources1";
    public static final String QUERY_DELETE_BY_RESOURCES_2 = "ResourceConfigurationUpdate.deleteByResources2";
    public static final String QUERY_DELETE_GROUP_UPDATE = "ResourceConfigurationUpdate.deleteGroupUpdate";
    public static final String QUERY_DELETE_GROUP_UPDATES_FOR_GROUP = "ResourceConfigurationUpdate.deleteGroupUpdatesForGroup";
    @JoinColumn(name="CONFIG_RES_ID", referencedColumnName="ID", nullable=true)
    @ManyToOne
    @XmlTransient
    private Resource resource;
    @JoinColumn(name="AGG_RES_UPDATE_ID", referencedColumnName="ID", nullable=true)
    @ManyToOne
    private GroupResourceConfigurationUpdate groupConfigurationUpdate;

    protected ResourceConfigurationUpdate() {
    }

    public ResourceConfigurationUpdate(Resource resource, Configuration config, String subjectName) {
        super(config, subjectName);
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public GroupResourceConfigurationUpdate getGroupConfigurationUpdate() {
        return this.groupConfigurationUpdate;
    }

    public void setGroupConfigurationUpdate(GroupResourceConfigurationUpdate groupConfigurationUpdate) {
        this.groupConfigurationUpdate = groupConfigurationUpdate;
    }

    protected void appendToStringInternals(StringBuilder str) {
        super.appendToStringInternals(str);
        str.append(", resource=").append(this.resource);
        if (this.groupConfigurationUpdate != null) {
            str.append(", groupResourceConfigurationUpdate=").append(this.groupConfigurationUpdate.getId());
        }
    }
}

