/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.ContentSourceSyncStatus;

@Entity
@NamedQueries(value={@NamedQuery(name="ContentSourceSyncResults.getInProgressByCSId", query="SELECT cssr   FROM ContentSourceSyncResults cssr  WHERE cssr.contentSource.id = :contentSourceId    AND status = 'INPROGRESS'  ORDER BY cssr.startTime DESC "), @NamedQuery(name="ContentSourceSyncResults.getAllByCSId", query="SELECT cssr   FROM ContentSourceSyncResults cssr  WHERE cssr.contentSource.id = :contentSourceId ")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_CONTENT_SRC_SYNC_ID_SEQ")
@Table(name="RHQ_CONTENT_SRC_SYNC")
public class ContentSourceSyncResults
implements Serializable {
    public static final String QUERY_GET_INPROGRESS_BY_CONTENT_SOURCE_ID = "ContentSourceSyncResults.getInProgressByCSId";
    public static final String QUERY_GET_ALL_BY_CONTENT_SOURCE_ID = "ContentSourceSyncResults.getAllByCSId";
    private static final long serialVersionUID = 1L;
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ")
    @Id
    private int id;
    @JoinColumn(name="CONTENT_SRC_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private ContentSource contentSource;
    @Column(name="STATUS", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private ContentSourceSyncStatus status;
    @Column(name="START_TIME", nullable=false)
    private long startTime = System.currentTimeMillis();
    @Column(name="END_TIME", nullable=true)
    private Long endTime;
    @Column(name="RESULTS", nullable=true)
    private String results;

    protected ContentSourceSyncResults() {
        this.status = ContentSourceSyncStatus.INPROGRESS;
    }

    public ContentSourceSyncResults(ContentSource contentSource) {
        this();
        this.contentSource = contentSource;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public ContentSource getContentSource() {
        return this.contentSource;
    }

    public void setContentSource(ContentSource contentSource) {
        this.contentSource = contentSource;
    }

    public ContentSourceSyncStatus getStatus() {
        return this.status;
    }

    public void setStatus(ContentSourceSyncStatus status) {
        this.status = status;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public String getResults() {
        return this.results;
    }

    public void setResults(String results) {
        this.results = results;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("ContentSourceSyncResults: ");
        str.append("start-time=[" + new Date(this.startTime));
        str.append("], end-time=[" + (this.endTime != null ? new Date(this.endTime) : "---"));
        str.append("], status=[" + (Object)((Object)this.status));
        str.append("], content-source=[" + this.contentSource);
        str.append("]");
        return str.toString();
    }
}

