/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.content.Distribution;
import org.rhq.core.domain.content.DistributionFilePK;

@Entity
@NamedQueries(value={@NamedQuery(name="DistributionFile.selectByDistId", query="SELECT df from DistributionFile df WHERE df.distribution.id = :distId"), @NamedQuery(name="DistributionFile.deleteByDistId", query="DELETE DistributionFile df WHERE df.distribution.id = :distId")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_DISTRIBUTION_FILE_ID_SEQ")
@Table(name="RHQ_DISTRIBUTION_FILE")
public class DistributionFile {
    public static final String SELECT_BY_DIST_ID = "DistributionFile.selectByDistId";
    public static final String DELETE_BY_DIST_ID = "DistributionFile.deleteByDistId";
    private static final long serialVersionUID = 1L;
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ")
    @Id
    private int id;
    @JoinColumn(name="DISTRIBUTION_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST})
    private Distribution distribution;
    @Column(name="RELATIVE_FILENAME", nullable=false)
    private String relative_filename;
    @Column(name="LAST_MODIFIED", nullable=false)
    private long last_modified;
    @Column(name="MD5SUM", nullable=false)
    private String md5sum;

    protected DistributionFile() {
    }

    public DistributionFile(Distribution dist, String filenameIn, String md5sum) {
        this.distribution = dist;
        this.relative_filename = filenameIn;
        this.md5sum = md5sum;
    }

    public DistributionFilePK getDistributionFilePK() {
        return new DistributionFilePK(this.distribution);
    }

    public void setDistributionFilePK(DistributionFilePK pk) {
        this.distribution = pk.getDistribution();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public long getLastModified() {
        return this.last_modified;
    }

    public void setLastModified(long lastModifiedIn) {
        this.last_modified = lastModifiedIn;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public void setDistribution(Distribution dist) {
        this.distribution = dist;
    }

    public String getRelativeFilename() {
        return this.relative_filename;
    }

    public void setRelativeFilename(String relative_filename) {
        this.relative_filename = relative_filename;
    }

    public String getMd5sum() {
        return this.md5sum;
    }

    public void setMd5sum(String md5sum) {
        this.md5sum = md5sum;
    }

    @PrePersist
    void onPersist() {
        this.last_modified = System.currentTimeMillis();
    }

    public String toString() {
        StringBuilder str = new StringBuilder("DistributionFile: ");
        str.append("ctime=[").append(new Date(this.last_modified)).append("]");
        str.append(", ch=[").append(this.relative_filename).append("]");
        str.append(", ch=[").append(this.md5sum).append("]");
        str.append(", cs=[").append(this.distribution).append("]");
        return str.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getDistribution() == null ? 0 : this.getDistribution().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DistributionFile)) {
            return false;
        }
        DistributionFile other = (DistributionFile)obj;
        return !(this.getDistribution() == null ? this.getDistribution() != null : !this.getDistribution().equals(other.getDistribution()));
    }
}

