/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.PackageVersionContentSourcePK;

@Entity
@IdClass(value=PackageVersionContentSourcePK.class)
@NamedQueries(value={@NamedQuery(name="PackageVersionContentSource.findByContentSourceIdNoFetch", query="SELECT pvcs   FROM PackageVersionContentSource pvcs  WHERE pvcs.contentSource.id = :id "), @NamedQuery(name="PackageVersionContentSource.findByContentSourceId", query="SELECT pvcs   FROM PackageVersionContentSource pvcs        LEFT JOIN FETCH pvcs.packageVersion pv        LEFT JOIN FETCH pv.generalPackage gp        LEFT JOIN FETCH gp.packageType pt        LEFT JOIN FETCH pv.architecture arch        LEFT JOIN FETCH pv.extraProperties extra  WHERE pvcs.contentSource.id = :id "), @NamedQuery(name="PackageVersionContentSource.findByContentSourceIdAndRepoId", query="SELECT pvcs   FROM PackageVersionContentSource pvcs        LEFT JOIN FETCH pvcs.packageVersion pv        LEFT JOIN FETCH pv.generalPackage gp        LEFT JOIN FETCH gp.packageType pt        LEFT JOIN FETCH pv.architecture arch        LEFT JOIN FETCH pv.extraProperties extra  WHERE pvcs.contentSource.id = :content_source_id    AND pvcs.packageVersion.id IN        ( SELECT rpv.packageVersion.id FROM RepoPackageVersion rpv          WHERE rpv.repo.id = :repo_id )"), @NamedQuery(name="PackageVersionContentSource.findByContentSourceIdCount", query="SELECT COUNT(pvcs.contentSource.id)   FROM PackageVersionContentSource pvcs  WHERE pvcs.contentSource.id = :id "), @NamedQuery(name="PackageVersionContentSource.findByAllContentSourceIds", query="SELECT pvcs   FROM PackageVersionContentSource pvcs        LEFT JOIN FETCH pvcs.packageVersion pv        LEFT JOIN FETCH pv.generalPackage gp        LEFT JOIN FETCH gp.packageType pt        LEFT JOIN FETCH pt.resourceType rt        LEFT JOIN FETCH pv.architecture arch        LEFT JOIN FETCH pv.extraProperties extra  WHERE pvcs.contentSource.id IN ( :ids ) "), @NamedQuery(name="PackageVersionContentSource.findByAllContentSourceIdsCount", query="SELECT COUNT(pvcs.contentSource.id)   FROM PackageVersionContentSource pvcs  WHERE pvcs.contentSource.id IN ( :ids ) "), @NamedQuery(name="PackageVersionContentSource.findByCSIdAndNotLoaded", query="SELECT pvcs   FROM PackageVersionContentSource pvcs        LEFT JOIN FETCH pvcs.packageVersion pv        LEFT JOIN FETCH pv.generalPackage gp        LEFT JOIN FETCH gp.packageType pt        LEFT JOIN FETCH pv.architecture arch        LEFT JOIN FETCH pv.extraProperties extra  WHERE pvcs.contentSource.id = :id    AND pv.packageBits IS NULL "), @NamedQuery(name="PackageVersionContentSource.findByCSIdAndNotLoadedCount", query="SELECT COUNT(pvcs.contentSource.id)   FROM PackageVersionContentSource pvcs  WHERE pvcs.contentSource.id = :id    AND pvcs.packageVersion.packageBits IS NULL "), @NamedQuery(name="PackageVersionContentSource.findByPkgVerIdAndResId", query="SELECT pvcs   FROM PackageVersionContentSource pvcs        LEFT JOIN pvcs.packageVersion pv        LEFT JOIN pv.repoPackageVersions cpv        LEFT JOIN cpv.repo.resourceRepos rc  WHERE rc.resource.id = :resourceId    AND pv.id = :packageVersionId"), @NamedQuery(name="PackageVersionContentSource.deleteByContentSourceId", query="DELETE PackageVersionContentSource pvcs WHERE pvcs.contentSource.id = :contentSourceId")})
@Table(name="RHQ_PKG_VER_CONTENT_SRC_MAP")
public class PackageVersionContentSource
implements Serializable {
    public static final String QUERY_FIND_BY_CONTENT_SOURCE_ID_NO_FETCH = "PackageVersionContentSource.findByContentSourceIdNoFetch";
    public static final String QUERY_FIND_BY_CONTENT_SOURCE_ID = "PackageVersionContentSource.findByContentSourceId";
    public static final String QUERY_FIND_BY_CONTENT_SOURCE_ID_AND_REPO_ID = "PackageVersionContentSource.findByContentSourceIdAndRepoId";
    public static final String QUERY_FIND_BY_CONTENT_SOURCE_ID_COUNT = "PackageVersionContentSource.findByContentSourceIdCount";
    public static final String QUERY_FIND_BY_ALL_CONTENT_SOURCE_IDS = "PackageVersionContentSource.findByAllContentSourceIds";
    public static final String QUERY_FIND_BY_ALL_CONTENT_SOURCE_IDS_COUNT = "PackageVersionContentSource.findByAllContentSourceIdsCount";
    public static final String QUERY_FIND_BY_CONTENT_SOURCE_ID_AND_NOT_LOADED = "PackageVersionContentSource.findByCSIdAndNotLoaded";
    public static final String QUERY_FIND_BY_CONTENT_SOURCE_ID_AND_NOT_LOADED_COUNT = "PackageVersionContentSource.findByCSIdAndNotLoadedCount";
    public static final String QUERY_FIND_BY_PKG_VER_ID_AND_RES_ID = "PackageVersionContentSource.findByPkgVerIdAndResId";
    public static final String DELETE_BY_CONTENT_SOURCE_ID = "PackageVersionContentSource.deleteByContentSourceId";
    private static final long serialVersionUID = 1L;
    @Id
    private PackageVersion packageVersion;
    @Id
    private ContentSource contentSource;
    @Column(name="LOCATION", nullable=false)
    private String location;

    protected PackageVersionContentSource() {
    }

    public PackageVersionContentSource(PackageVersion packageVersion, ContentSource contentSource, String location) {
        this.packageVersion = packageVersion;
        this.contentSource = contentSource;
        this.location = location;
    }

    public PackageVersionContentSourcePK getPackageVersionContentSourcePK() {
        return new PackageVersionContentSourcePK(this.packageVersion, this.contentSource);
    }

    public void setPackageVersionContentSourcePK(PackageVersionContentSourcePK pk) {
        this.packageVersion = pk.getPackageVersion();
        this.contentSource = pk.getContentSource();
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("PVCS: ");
        str.append("location=[").append(this.location).append("]");
        str.append(", pv=[").append(this.packageVersion).append("]");
        str.append(", cs=[").append(this.contentSource).append("]");
        return str.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.packageVersion == null ? 0 : this.packageVersion.hashCode());
        result = 31 * result + (this.contentSource == null ? 0 : this.contentSource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof PackageVersionContentSource)) {
            return false;
        }
        PackageVersionContentSource other = (PackageVersionContentSource)obj;
        if (this.packageVersion == null ? this.packageVersion != null : !this.packageVersion.equals(other.packageVersion)) {
            return false;
        }
        return !(this.contentSource == null ? this.contentSource != null : !this.contentSource.equals(other.contentSource));
    }
}

