/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.rhq.core.domain.common.Tag;
import org.rhq.core.domain.common.Taggable;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.RepoContentSource;
import org.rhq.core.domain.content.RepoGroup;
import org.rhq.core.domain.content.RepoPackageVersion;
import org.rhq.core.domain.content.RepoRelationship;
import org.rhq.core.domain.content.RepoRepoGroup;
import org.rhq.core.domain.content.RepoRepoRelationship;
import org.rhq.core.domain.content.RepoTag;
import org.rhq.core.domain.content.ResourceRepo;
import org.rhq.core.domain.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="Repo.findAll", query="SELECT c FROM Repo c WHERE c.candidate = false"), @NamedQuery(name="Repo.findByIds", query="SELECT c FROM Repo c WHERE c.id IN ( :ids )"), @NamedQuery(name="Repo.findByName", query="SELECT c FROM Repo c WHERE c.name = :name"), @NamedQuery(name="Repo.findByContentSourceIdFetchCCS", query="SELECT c FROM Repo c LEFT JOIN FETCH c.repoContentSources ccs WHERE ccs.contentSource.id = :id AND c.candidate = false"), @NamedQuery(name="Repo.findByContentSourceId", query="SELECT c FROM Repo c LEFT JOIN c.repoContentSources ccs WHERE ccs.contentSource.id = :id AND c.candidate = false"), @NamedQuery(name="Repo.findCandidateByContentSourceId", query="SELECT c FROM Repo c LEFT JOIN c.repoContentSources ccs WHERE ccs.contentSource.id = :id AND c.candidate = true"), @NamedQuery(name="Repo.findSubscriberResources", query="SELECT rc.resource FROM ResourceRepo rc WHERE rc.repo.id = :id"), @NamedQuery(name="Repo.findReposByResourceId", query="SELECT c FROM ResourceRepo rc JOIN rc.repo c WHERE rc.resource.id = :resourceId "), @NamedQuery(name="Repo.findRepoCompositesByResourceId", query="SELECT new org.rhq.core.domain.content.composite.RepoComposite( c, (SELECT COUNT(cpv.packageVersion) FROM RepoPackageVersion cpv WHERE cpv.repo.id = c.id) ) FROM ResourceRepo rc JOIN rc.repo c LEFT JOIN c.repoPackageVersions pv WHERE rc.resource.id = :resourceId GROUP BY c, c.name, c.description, c.creationDate, c.lastModifiedDate"), @NamedQuery(name="Repo.findRepoCompositesByResourceId_count", query="SELECT COUNT( rc.repo ) FROM ResourceRepo rc WHERE rc.resource.id = :resourceId "), @NamedQuery(name="Repo.findAvailableRepoCompositesByResourceId", query="SELECT new org.rhq.core.domain.content.composite.RepoComposite( c, (SELECT COUNT(cpv.packageVersion) FROM RepoPackageVersion cpv WHERE cpv.repo.id = c.id) ) FROM Repo AS c WHERE c.id NOT IN ( SELECT rc.repo.id FROM ResourceRepo rc WHERE rc.resource.id = :resourceId ) AND c.candidate is false GROUP BY c, c.name, c.description, c.creationDate, c.lastModifiedDate"), @NamedQuery(name="Repo.findAvailableRepoCompositesByResourceId_count", query="SELECT COUNT( c ) FROM Repo AS c WHERE c.id NOT IN ( SELECT rc.repo.id FROM ResourceRepo rc WHERE rc.resource.id = :resourceId ) AND c.candidate = false "), @NamedQuery(name="Repo.findCandidatesWithOnlyContentSource", query="SELECT r FROM Repo r WHERE r.candidate = true AND (SELECT COUNT(rcs.repo) FROM RepoContentSource rcs      WHERE rcs.repo.id = r.id      AND rcs.contentSource.id = :contentSourceId) = 1 AND (SELECT COUNT(rcs) FROM RepoContentSource rcs     WHERE rcs.repo.id = r.id) = 1 ")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_REPO_ID_SEQ")
@Table(name="RHQ_REPO")
public class Repo
implements Serializable,
Taggable {
    public static final String QUERY_FIND_ALL_IMPORTED_REPOS = "Repo.findAll";
    public static final String QUERY_FIND_BY_IDS = "Repo.findByIds";
    public static final String QUERY_FIND_BY_NAME = "Repo.findByName";
    public static final String QUERY_FIND_IMPORTED_BY_CONTENT_SOURCE_ID_FETCH_CCS = "Repo.findByContentSourceIdFetchCCS";
    public static final String QUERY_FIND_IMPORTED_BY_CONTENT_SOURCE_ID = "Repo.findByContentSourceId";
    public static final String QUERY_FIND_CANDIDATE_BY_CONTENT_SOURCE_ID = "Repo.findCandidateByContentSourceId";
    public static final String QUERY_FIND_SUBSCRIBER_RESOURCES = "Repo.findSubscriberResources";
    public static final String QUERY_FIND_REPOS_BY_RESOURCE_ID = "Repo.findReposByResourceId";
    public static final String QUERY_FIND_REPO_COMPOSITES_BY_RESOURCE_ID = "Repo.findRepoCompositesByResourceId";
    public static final String QUERY_FIND_REPO_COMPOSITES_BY_RESOURCE_ID_COUNT = "Repo.findRepoCompositesByResourceId_count";
    public static final String QUERY_FIND_AVAILABLE_REPO_COMPOSITES_BY_RESOURCE_ID = "Repo.findAvailableRepoCompositesByResourceId";
    public static final String QUERY_FIND_AVAILABLE_REPO_COMPOSITES_BY_RESOURCE_ID_COUNT = "Repo.findAvailableRepoCompositesByResourceId_count";
    public static final String QUERY_FIND_CANDIDATES_WITH_ONLY_CONTENT_SOURCE = "Repo.findCandidatesWithOnlyContentSource";
    private static final long serialVersionUID = 1L;
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ")
    @Id
    private int id;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="DESCRIPTION", nullable=true)
    private String description;
    @Column(name="CREATION_TIME", nullable=false)
    private long creationDate;
    @Column(name="LAST_MODIFIED_TIME", nullable=false)
    private long lastModifiedDate;
    @Column(name="IS_CANDIDATE", nullable=false)
    private boolean candidate;
    @OneToMany(mappedBy="repo", fetch=FetchType.LAZY)
    private Set<ResourceRepo> resourceRepos;
    @OneToMany(mappedBy="repo", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Set<RepoContentSource> repoContentSources;
    @OneToMany(mappedBy="repo", fetch=FetchType.LAZY)
    private Set<RepoPackageVersion> repoPackageVersions;
    @OneToMany(mappedBy="repo", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Set<RepoRepoGroup> repoRepoGroups;
    @OneToMany(mappedBy="repo", fetch=FetchType.LAZY)
    private Set<RepoRepoRelationship> repoRepoRelationships;
    @OneToMany(mappedBy="repo", fetch=FetchType.LAZY)
    private Set<RepoTag> repoTags;
    @Transient
    private String syncStatus;

    public Repo() {
    }

    public Repo(String name) {
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public boolean isCandidate() {
        return this.candidate;
    }

    public void setCandidate(boolean candidate) {
        this.candidate = candidate;
    }

    public Set<ResourceRepo> getResourceRepos() {
        return this.resourceRepos;
    }

    public Set<Resource> getResources() {
        HashSet<Resource> resources = new HashSet<Resource>();
        if (this.resourceRepos != null) {
            for (ResourceRepo rc : this.resourceRepos) {
                resources.add(rc.getResourceRepoPK().getResource());
            }
        }
        return resources;
    }

    public ResourceRepo addResource(Resource resource) {
        if (this.resourceRepos == null) {
            this.resourceRepos = new HashSet<ResourceRepo>();
        }
        ResourceRepo mapping = new ResourceRepo(resource, this);
        this.resourceRepos.add(mapping);
        return mapping;
    }

    public ResourceRepo removeResource(Resource resource) {
        if (this.resourceRepos == null || resource == null) {
            return null;
        }
        ResourceRepo doomed = null;
        for (ResourceRepo rc : this.resourceRepos) {
            if (!resource.equals(rc.getResourceRepoPK().getResource())) continue;
            doomed = rc;
            break;
        }
        if (doomed != null) {
            this.resourceRepos.remove(doomed);
        }
        return doomed;
    }

    public Set<RepoContentSource> getRepoContentSources() {
        return this.repoContentSources;
    }

    @Transient
    public String getSyncStatus() {
        return this.syncStatus;
    }

    public Set<ContentSource> getContentSources() {
        HashSet<ContentSource> contentSources = new HashSet<ContentSource>();
        if (this.repoContentSources != null) {
            for (RepoContentSource ccs : this.repoContentSources) {
                contentSources.add(ccs.getRepoContentSourcePK().getContentSource());
            }
        }
        return contentSources;
    }

    public RepoContentSource addContentSource(ContentSource contentSource) {
        if (this.repoContentSources == null) {
            this.repoContentSources = new HashSet<RepoContentSource>();
        }
        RepoContentSource mapping = new RepoContentSource(this, contentSource);
        this.repoContentSources.add(mapping);
        return mapping;
    }

    public RepoContentSource removeContentSource(ContentSource contentSource) {
        if (this.repoContentSources == null || contentSource == null) {
            return null;
        }
        RepoContentSource doomed = null;
        for (RepoContentSource ccs : this.repoContentSources) {
            if (!contentSource.equals(ccs.getRepoContentSourcePK().getContentSource())) continue;
            doomed = ccs;
            break;
        }
        if (doomed != null) {
            this.repoContentSources.remove(doomed);
        }
        return doomed;
    }

    public Set<RepoPackageVersion> getRepoPackageVersions() {
        return this.repoPackageVersions;
    }

    public Set<PackageVersion> getPackageVersions() {
        HashSet<PackageVersion> packageVersions = new HashSet<PackageVersion>();
        if (this.repoPackageVersions != null) {
            for (RepoPackageVersion cpv : this.repoPackageVersions) {
                packageVersions.add(cpv.getRepoPackageVersionPK().getPackageVersion());
            }
        }
        return packageVersions;
    }

    public RepoPackageVersion addPackageVersion(PackageVersion packageVersion) {
        if (this.repoPackageVersions == null) {
            this.repoPackageVersions = new HashSet<RepoPackageVersion>();
        }
        RepoPackageVersion mapping = new RepoPackageVersion(this, packageVersion);
        this.repoPackageVersions.add(mapping);
        return mapping;
    }

    public RepoPackageVersion removePackageVersion(PackageVersion packageVersion) {
        if (this.repoPackageVersions == null || packageVersion == null) {
            return null;
        }
        RepoPackageVersion doomed = null;
        for (RepoPackageVersion cpv : this.repoPackageVersions) {
            if (!packageVersion.equals(cpv.getRepoPackageVersionPK().getPackageVersion())) continue;
            doomed = cpv;
            break;
        }
        if (doomed != null) {
            this.repoPackageVersions.remove(doomed);
        }
        return doomed;
    }

    public Set<RepoRepoGroup> getRepoRepoGroups() {
        return this.repoRepoGroups;
    }

    public Set<RepoGroup> getRepoGroups() {
        HashSet<RepoGroup> repoGroups = new HashSet<RepoGroup>();
        if (this.repoRepoGroups != null) {
            for (RepoRepoGroup rrg : this.repoRepoGroups) {
                repoGroups.add(rrg.getRepoRepoGroupPK().getRepoGroup());
            }
        }
        return repoGroups;
    }

    public RepoRepoGroup addRepoGroup(RepoGroup repoGroup) {
        if (this.repoRepoGroups == null) {
            this.repoRepoGroups = new HashSet<RepoRepoGroup>();
        }
        RepoRepoGroup mapping = new RepoRepoGroup(this, repoGroup);
        this.repoRepoGroups.add(mapping);
        return mapping;
    }

    public RepoRepoGroup removeRepoGroup(RepoGroup repoGroup) {
        if (this.repoRepoGroups == null || repoGroup == null) {
            return null;
        }
        RepoRepoGroup doomed = null;
        for (RepoRepoGroup rrg : this.repoRepoGroups) {
            if (!repoGroup.equals(rrg.getRepoRepoGroupPK().getRepoGroup())) continue;
            doomed = rrg;
            break;
        }
        if (doomed != null) {
            this.repoRepoGroups.remove(doomed);
        }
        return doomed;
    }

    public Set<RepoRepoRelationship> getRepoRepoRelationships() {
        return this.repoRepoRelationships;
    }

    public Set<RepoRelationship> getRepoRelationships() {
        HashSet<RepoRelationship> repoRelationships = new HashSet<RepoRelationship>();
        if (this.repoRepoRelationships != null) {
            for (RepoRepoRelationship rrr : this.repoRepoRelationships) {
                repoRelationships.add(rrr.getRepoRepoRelationshipPK().getRepoRelationship());
            }
        }
        return repoRelationships;
    }

    public RepoRepoRelationship addRepoRelationship(RepoRelationship repoRelationship) {
        if (this.repoRepoRelationships == null) {
            this.repoRepoRelationships = new HashSet<RepoRepoRelationship>();
        }
        RepoRepoRelationship mapping = new RepoRepoRelationship(this, repoRelationship);
        this.repoRepoRelationships.add(mapping);
        return mapping;
    }

    public RepoRepoRelationship removeRepoRelationship(RepoRelationship repoRelationship) {
        if (this.repoRepoRelationships == null || repoRelationship == null) {
            return null;
        }
        RepoRepoRelationship doomed = null;
        for (RepoRepoRelationship rrr : this.repoRepoRelationships) {
            if (!repoRelationship.equals(rrr.getRepoRepoRelationshipPK().getRepoRelationship())) continue;
            doomed = rrr;
            break;
        }
        if (doomed != null) {
            this.repoRepoRelationships.remove(doomed);
        }
        return doomed;
    }

    public String toString() {
        return "Repo: id=[" + this.id + "], name=[" + this.name + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Repo)) {
            return false;
        }
        Repo other = (Repo)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @PrePersist
    void onPersist() {
        this.lastModifiedDate = this.creationDate = System.currentTimeMillis();
    }

    @PreUpdate
    void onUpdate() {
        this.lastModifiedDate = System.currentTimeMillis();
    }

    public Set<RepoTag> getRepoTags() {
        return this.repoTags;
    }

    public void setRepoTags(Set<RepoTag> tags) {
        this.repoTags = this.repoTags;
    }

    @Override
    public boolean hasTag(Tag tag) {
        if (this.repoTags == null || tag == null) {
            return false;
        }
        for (RepoTag rt : this.repoTags) {
            if (!tag.equals(rt.getRepoTagPK().getTag())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Tag> getTags() {
        HashSet<Tag> tags = new HashSet<Tag>();
        if (this.repoTags != null) {
            for (RepoTag rt : this.repoTags) {
                tags.add(rt.getRepoTagPK().getTag());
            }
        }
        return tags;
    }

    @Override
    public void addTag(Tag tag) {
        if (this.repoTags == null) {
            this.repoTags = new HashSet<RepoTag>();
        }
        RepoTag mapping = new RepoTag(this, tag);
        this.repoTags.add(mapping);
    }

    @Override
    public void setTags(Set<Tag> tags) {
        if (this.repoTags == null) {
            this.repoTags = new HashSet<RepoTag>();
        } else {
            this.repoTags.clear();
        }
        for (Tag t : tags) {
            RepoTag mapping = new RepoTag(this, t);
            this.repoTags.add(mapping);
        }
    }

    @Override
    public void removeTag(Tag tag) {
        if (this.repoTags == null || tag == null) {
            return;
        }
        RepoTag doomed = null;
        for (RepoTag rt : this.repoTags) {
            if (!tag.equals(rt.getRepoTagPK().getTag())) continue;
            doomed = rt;
            break;
        }
        if (doomed != null) {
            this.repoTags.remove(doomed);
        }
    }

    @Transient
    public void setSyncStatus(String syncStatusIn) {
        this.syncStatus = syncStatusIn;
    }
}

