/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import org.rhq.core.domain.content.Distribution;
import org.rhq.core.domain.content.Repo;
import org.rhq.core.domain.content.RepoDistributionPK;

@Entity
@IdClass(value=RepoDistributionPK.class)
@NamedQueries(value={@NamedQuery(name="RepoDistribution.deleteByKickstartTreeId", query="DELETE RepoDistribution rkt WHERE rkt.dist.id = :distId"), @NamedQuery(name="RepoDistribution.deleteByRepoId", query="DELETE RepoDistribution rkt WHERE rkt.repo.id = :repoId"), @NamedQuery(name="RepoDistribution.queryFindByRepoId", query="SELECT rkt FROM RepoDistribution rkt where rkt.repo.id = :repoId ")})
@Table(name="RHQ_REPO_DISTRIBUTION")
public class RepoDistribution
implements Serializable {
    public static final String DELETE_BY_KICKSTART_TREE_ID = "RepoDistribution.deleteByKickstartTreeId";
    public static final String DELETE_BY_REPO_ID = "RepoDistribution.deleteByRepoId";
    public static final String QUERY_FIND_BY_REPO_ID = "RepoDistribution.queryFindByRepoId";
    private static final long serialVersionUID = 1L;
    @Id
    @ManyToOne
    @JoinColumn(name="REPO_ID", referencedColumnName="ID", nullable=false, insertable=false, updatable=false)
    private Repo repo;
    @Id
    @ManyToOne
    @JoinColumn(name="DISTRIBUTION_ID", referencedColumnName="ID", nullable=false, insertable=false, updatable=false)
    private Distribution dist;
    @Column(name="LAST_MODIFIED", nullable=false)
    private long last_modified;

    protected RepoDistribution() {
    }

    public RepoDistribution(Repo repo, Distribution dist) {
        this.repo = repo;
        this.dist = dist;
    }

    public RepoDistributionPK getRepoDistributionPK() {
        return new RepoDistributionPK(this.repo, this.dist);
    }

    public void setRepoDistributionPK(RepoDistributionPK pk) {
        this.repo = pk.getRepo();
        this.dist = pk.getDistribution();
    }

    public long getLastModified() {
        return this.last_modified;
    }

    @PrePersist
    void onPersist() {
        this.last_modified = System.currentTimeMillis();
    }

    public String toString() {
        StringBuilder str = new StringBuilder("RepoDistribution: ");
        str.append("ctime=[").append(new Date(this.last_modified)).append("]");
        str.append(", ch=[").append(this.repo).append("]");
        str.append(", cs=[").append(this.dist).append("]");
        return str.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.repo == null ? 0 : this.repo.hashCode());
        result = 31 * result + (this.dist == null ? 0 : this.dist.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RepoDistribution)) {
            return false;
        }
        RepoDistribution other = (RepoDistribution)obj;
        if (this.repo == null ? this.repo != null : !this.repo.equals(other.repo)) {
            return false;
        }
        return !(this.dist == null ? this.dist != null : !this.dist.equals(other.dist));
    }
}

