/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.content.RepoGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="RepoGroupType.findByName", query="SELECT t FROM RepoGroupType t WHERE t.name = :name")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_REPO_GROUP_TYPE_ID_SEQ")
@Table(name="RHQ_REPO_GROUP_TYPE")
public class RepoGroupType
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_BY_NAME = "RepoGroupType.findByName";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ")
    @Id
    private int id;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="DESCRIPTION", nullable=true)
    private String description;
    @OneToMany(mappedBy="repoGroupType", fetch=FetchType.LAZY)
    private Set<RepoGroup> repoGroups;

    public RepoGroupType() {
    }

    public RepoGroupType(String name) {
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<RepoGroup> getRepoGroups() {
        return this.repoGroups;
    }

    public void addRepoGroup(RepoGroup repoGroup) {
        if (this.repoGroups == null) {
            this.repoGroups = new HashSet<RepoGroup>();
        }
        this.repoGroups.add(repoGroup);
        repoGroup.setRepoGroupType(this);
    }

    public void setRepoGroups(Set<RepoGroup> repoGroups) {
        this.repoGroups = repoGroups;
    }

    public String toString() {
        return "RepoGroupType: name=[" + this.name + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RepoGroupType)) {
            return false;
        }
        RepoGroupType other = (RepoGroupType)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

