/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.criteria;

import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.rhq.core.domain.criteria.Criteria;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.util.PageOrdering;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class MeasurementScheduleCriteria
extends Criteria {
    private static final long serialVersionUID = 1L;
    private Integer filterId;
    private List<Integer> filterDefinitionIds;
    private Integer filterResourceId;
    private Integer filterResourceGroupId;
    private Integer filterAutoGroupResourceTypeId;
    private Integer filterAutoGroupParentResourceId;
    private boolean fetchBaseline;
    private boolean fetchDefinition;
    private boolean fetchResource;
    private PageOrdering sortName;

    public MeasurementScheduleCriteria() {
        super(MeasurementSchedule.class);
        this.filterOverrides.put("definitionIds", "definition.id IN ( ? )");
        this.filterOverrides.put("resourceId", "resource.id IN ( ? )");
        this.filterOverrides.put("resourceGroupId", "resource.id IN ( SELECT res.id     FROM Resource res     JOIN res.implicitGroups ig    WHERE ig.id = ? )");
        this.filterOverrides.put("autoGroupResourceTypeId", "resource.id IN ( SELECT res.id     FROM Resource res     JOIN res.resourceType type    WHERE type.id = ? )");
        this.filterOverrides.put("autoGroupParentResourceId", "resource.id IN ( SELECT res.id     FROM Resource res     JOIN res.parentResource parent    WHERE parent.id = ? )");
        this.sortOverrides.put("name", "definition.name");
    }

    public void addFilterId(Integer filterId) {
        this.filterId = filterId;
    }

    public void addFilterDefinitionIds(Integer ... filterDefinitionIds) {
        this.filterDefinitionIds = Arrays.asList(filterDefinitionIds);
    }

    public void addFilterResourceId(Integer filterResourceId) {
        this.filterResourceId = filterResourceId;
    }

    public void addFilterResourceGroupId(Integer filterResourceGroupId) {
        this.filterResourceGroupId = filterResourceGroupId;
    }

    public void addFilterAutoGroupResourceTypeId(Integer filterAutoGroupResourceTypeId) {
        this.filterAutoGroupResourceTypeId = filterAutoGroupResourceTypeId;
    }

    public void addFilterAutoGroupParentResourceId(Integer filterAutoGroupParentResourceId) {
        this.filterAutoGroupParentResourceId = filterAutoGroupParentResourceId;
    }

    public void fetchBaseline(boolean fetchBaseline) {
        this.fetchBaseline = fetchBaseline;
    }

    public void fetchDefinition(boolean fetchDefinition) {
        this.fetchDefinition = fetchDefinition;
    }

    public void fetchResource(boolean fetchResource) {
        this.fetchResource = fetchResource;
    }

    public void addSortName(PageOrdering sortName) {
        this.addSortField("name");
        this.sortName = sortName;
    }
}

