/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.measurement;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.resource.Resource;

@Entity
@NamedQueries(value={@NamedQuery(name="Availability.findCurrentByResource", query="  SELECT av     FROM Availability av    WHERE av.resource.id = :resourceId      AND av.endTime IS NULL ORDER BY av.startTime ASC "), @NamedQuery(name="Availability.findByResource", query="  SELECT av     FROM Availability av    WHERE av.resource.id = :resourceId ORDER BY av.startTime ASC"), @NamedQuery(name="Availability.findByResourceNoSort", query="SELECT av   FROM Availability av  WHERE av.resource.id = :resourceId "), @NamedQuery(name="Availability.findNonmatchingWithResourceIdByAgentAndType", query="SELECT new org.rhq.core.domain.resource.composite.ResourceIdWithAvailabilityComposite(av.resource.id, av)   FROM Availability av  WHERE av.resource.agent.id = :agentId    AND ((av.availabilityType <> :availabilityType AND :availabilityType IS NOT NULL)         OR (av.availabilityType IS NOT NULL AND :availabilityType IS NULL)         OR (av.availabilityType IS NULL AND :availabilityType IS NOT NULL))   AND av.endTime IS NULL"), @NamedQuery(name="Availability.findForResourceWithinInterval", query="SELECT av FROM Availability av  WHERE av.resource.id = :resourceId    AND ((av.startTime <= :start AND (av.endTime >= :start OR av.endTime IS NULL) )        OR (av.startTime BETWEEN :start AND :end)) ORDER BY av.startTime ASC"), @NamedQuery(name="Availability.findForResourceGroupWithinInterval", query="SELECT av FROM Availability av  WHERE av.resource.id IN ( SELECT ires.id                              FROM ResourceGroup rg                              JOIN rg.implicitResources ires                             WHERE rg.id = :groupId )    AND ((av.startTime <= :start AND (av.endTime >= :start OR av.endTime IS NULL) )         OR (av.startTime BETWEEN :start AND :end)) ORDER BY av.startTime ASC"), @NamedQuery(name="Availability.findForAutoGroupWithinInterval", query="  SELECT av FROM Availability av     JOIN av.resource res JOIN res.parentResource parent JOIN res.resourceType type    WHERE parent.id = :parentId      AND type.id = :typeId      AND ((av.startTime <= :start AND (av.endTime >= :start OR av.endTime IS NULL))           OR (av.startTime BETWEEN :start AND :end)) ORDER BY av.startTime ASC"), @NamedQuery(name="Availability.findByResourceAndDate", query="SELECT av FROM Availability av  WHERE av.resource.id = :resourceId    AND av.startTime <= :aTime    AND ( av.endTime >= :aTime OR av.endTime IS NULL ) "), @NamedQuery(name="Availability.deleteByResources", query=" DELETE Availability a   WHERE a.resource.id IN ( :resourceIds )")})
@SequenceGenerator(name="Generator", sequenceName="RHQ_AVAILABILITY_ID_SEQ")
@Table(name="RHQ_AVAILABILITY")
public class Availability
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_CURRENT_BY_RESOURCE = "Availability.findCurrentByResource";
    public static final String FIND_BY_RESOURCE = "Availability.findByResource";
    public static final String FIND_BY_RESOURCE_NO_SORT = "Availability.findByResourceNoSort";
    public static final String FIND_NONMATCHING_WITH_RESOURCE_ID_BY_AGENT_AND_TYPE = "Availability.findNonmatchingWithResourceIdByAgentAndType";
    public static final String FIND_FOR_RESOURCE_WITHIN_INTERVAL = "Availability.findForResourceWithinInterval";
    public static final String FIND_FOR_RESOURCE_GROUP_WITHIN_INTERVAL = "Availability.findForResourceGroupWithinInterval";
    public static final String FIND_FOR_AUTO_GROUP_WITHIN_INTERVAL = "Availability.findForAutoGroupWithinInterval";
    public static final String FIND_BY_RESOURCE_AND_DATE = "Availability.findByResourceAndDate";
    public static final String QUERY_DELETE_BY_RESOURCES = "Availability.deleteByResources";
    public static final String NATIVE_QUERY_PURGE = "DELETE FROM RHQ_AVAILABILITY WHERE END_TIME < ?";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="Generator")
    @Id
    private int id;
    @Column(name="START_TIME", nullable=false)
    private long startTime;
    @Column(name="END_TIME", nullable=true)
    private Long endTime;
    @Column(name="AVAILABILITY_TYPE", nullable=true)
    @Enumerated(value=EnumType.ORDINAL)
    private AvailabilityType availabilityType;
    @JoinColumn(name="RESOURCE_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Resource resource;

    protected Availability() {
    }

    public Availability(Resource resource, Date startTime, AvailabilityType type) {
        if (resource == null) {
            throw new IllegalArgumentException("resource==null");
        }
        this.resource = resource;
        this.availabilityType = type;
        this.startTime = startTime != null ? startTime.getTime() : new Date().getTime();
        this.endTime = null;
    }

    public int getId() {
        return this.id;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Date getStartTime() {
        return new Date(this.startTime);
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime.getTime();
    }

    public Date getEndTime() {
        return this.endTime != null ? new Date(this.endTime) : null;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime != null ? Long.valueOf(endTime.getTime()) : null;
    }

    public AvailabilityType getAvailabilityType() {
        return this.availabilityType;
    }

    public void setAvailabilityType(AvailabilityType availabilityType) {
        this.availabilityType = availabilityType;
    }

    public String toString() {
        return "Availability[id=" + this.id + ",type=" + (Object)((Object)this.availabilityType) + ",start-time=" + this.getStartTime() + ",end-time=" + this.getEndTime() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.availabilityType == null ? 0 : this.availabilityType.hashCode());
        result = 31 * result + (this.endTime == null ? 0 : this.endTime.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        result = 31 * result + (int)(this.startTime ^ this.startTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Availability)) {
            return false;
        }
        Availability other = (Availability)obj;
        if (this.availabilityType == null ? other.availabilityType != null : !this.availabilityType.equals((Object)other.availabilityType)) {
            return false;
        }
        if (this.endTime == null ? other.endTime != null : !this.endTime.equals(other.endTime)) {
            return false;
        }
        if (this.resource == null ? other.resource != null : !this.resource.equals(other.resource)) {
            return false;
        }
        return this.startTime == other.startTime;
    }
}

