/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.measurement;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.alert.AlertCondition;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.DisplayType;
import org.rhq.core.domain.measurement.MeasurementCategory;
import org.rhq.core.domain.measurement.MeasurementSchedule;
import org.rhq.core.domain.measurement.MeasurementUnits;
import org.rhq.core.domain.measurement.NumericType;
import org.rhq.core.domain.resource.ResourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="MeasurementDefinition.findByResourceTypeDataTypeDisplayType", query="  SELECT md     FROM MeasurementDefinition md    WHERE md.resourceType.id = :resourceTypeId      AND ( md.dataType = :dataType OR :dataType is null )      AND ( md.displayType = :displayType OR :displayType is null ) ORDER BY md.displayName"), @NamedQuery(name="MeasurementDefinition.findScheduleCompositeForResourceType", query="SELECT new org.rhq.core.domain.measurement.composite.MeasurementScheduleComposite(md, md.defaultOn, md.defaultInterval)   FROM MeasurementDefinition md  WHERE md.resourceType.id = :resourceTypeId"), @NamedQuery(name="MeasurementDefinition.findByIds", query="SELECT md   FROM MeasurementDefinition md  WHERE md.id IN ( :ids )"), @NamedQuery(name="MeasurementDefinition.disableAll", query="UPDATE MeasurementDefinition md    SET md.defaultOn = false")})
@SequenceGenerator(name="id", sequenceName="RHQ_MEASUREMENT_DEF_ID_SEQ")
@Table(name="RHQ_MEASUREMENT_DEF")
public class MeasurementDefinition
implements Serializable {
    public static final String QUERY_NATIVE_UPDATE_DEFAULT_ON_BY_IDS = "UPDATE RHQ_MEASUREMENT_DEF   SET DEFAULT_ON = ?   WHERE ID IN ( @@DEFINITION_IDS@@ )";
    public static final String QUERY_NATIVE_UPDATE_DEFAULTS_BY_IDS = "UPDATE RHQ_MEASUREMENT_DEF   SET DEFAULT_ON = ?, DEFAULT_INTERVAL = ?   WHERE ID IN ( @@DEFINITION_IDS@@ )";
    public static final String QUERY_NATIVE_UPDATE_SCHEDULES_ENABLE_BY_IDS = "UPDATE RHQ_MEASUREMENT_SCHED   SET ENABLED = ?   WHERE DEFINITION IN ( @@DEFINITION_IDS@@ )";
    public static final String QUERY_NATIVE_UPDATE_SCHEDULES_BY_IDS = "UPDATE RHQ_MEASUREMENT_SCHED   SET ENABLED = ?, COLL_INTERVAL = ?   WHERE DEFINITION IN ( @@DEFINITION_IDS@@ )";
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_RESOURCE_TYPE_DATA_TYPE_DISPLAY_TYPE = "MeasurementDefinition.findByResourceTypeDataTypeDisplayType";
    public static final String FIND_SCHEDULE_COMPOSITE_FOR_RESOURCE_TYPE = "MeasurementDefinition.findScheduleCompositeForResourceType";
    public static final String FIND_BY_IDS = "MeasurementDefinition.findByIds";
    public static final String DISABLE_ALL = "MeasurementDefinition.disableAll";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="id")
    @Id
    private int id;
    @JoinColumn(name="RESOURCE_TYPE_ID", referencedColumnName="ID", nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private ResourceType resourceType;
    @Column(length=100, nullable=false)
    private String name;
    @Column(name="DISPLAY_NAME")
    private String displayName;
    @Enumerated(value=EnumType.ORDINAL)
    private MeasurementCategory category;
    @OneToMany(mappedBy="definition")
    List<MeasurementSchedule> schedules = new ArrayList<MeasurementSchedule>();
    @Enumerated(value=EnumType.ORDINAL)
    private MeasurementUnits units;
    @Column(name="NUMERIC_TYPE")
    @Enumerated(value=EnumType.ORDINAL)
    private NumericType numericType;
    @Column(name="DATA_TYPE")
    @Enumerated(value=EnumType.ORDINAL)
    private DataType dataType;
    @Column(name="DISPLAY_TYPE")
    @Enumerated(value=EnumType.ORDINAL)
    private DisplayType displayType;
    @Column(name="DEFAULT_ON")
    private boolean defaultOn;
    @Column(name="DEFAULT_INTERVAL")
    private long defaultInterval;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="RAW_NUMERIC_TYPE")
    @Enumerated(value=EnumType.ORDINAL)
    private NumericType rawNumericType;
    @OneToMany(mappedBy="measurementDefinition", cascade={CascadeType.REMOVE})
    private List<AlertCondition> alertConditions = new ArrayList<AlertCondition>();
    @Column(name="DISPLAY_ORDER")
    private int displayOrder = 1000;
    @Column(name="DESTINATION_TYPE")
    private String destinationType;
    @Version
    private int version;

    protected MeasurementDefinition() {
    }

    @Deprecated
    public MeasurementDefinition(String name, MeasurementCategory category, MeasurementUnits units, NumericType numericType, boolean defaultOn, long defaultInterval, DisplayType displayType) {
        this(name, category, units, DataType.MEASUREMENT, defaultOn, defaultInterval, displayType);
        this.numericType = numericType;
    }

    public MeasurementDefinition(String name, MeasurementCategory category, MeasurementUnits units, DataType dataType, NumericType numericType, boolean defaultOn, long defaultInterval, DisplayType displayType) {
        this(name, category, units, dataType, defaultOn, defaultInterval, displayType);
        this.numericType = numericType;
    }

    public MeasurementDefinition(String name, MeasurementCategory category, MeasurementUnits units, DataType dataType, boolean defaultOn, long defaultInterval, DisplayType displayType) {
        this.name = name;
        this.category = category;
        this.units = units;
        this.dataType = dataType;
        this.defaultOn = defaultOn;
        this.defaultInterval = defaultInterval;
        this.displayType = displayType;
        if (this.dataType == null) {
            this.dataType = DataType.MEASUREMENT;
        }
        if (DataType.MEASUREMENT.equals((Object)this.dataType)) {
            this.numericType = NumericType.DYNAMIC;
        }
    }

    public MeasurementDefinition(MeasurementDefinition def) {
        this.name = def.name;
        this.displayName = def.displayName;
        this.description = def.description;
        this.category = def.category;
        this.units = def.units;
        this.dataType = def.dataType;
        this.defaultOn = def.defaultOn;
        this.defaultInterval = def.defaultInterval;
        this.displayType = def.displayType;
        this.numericType = def.numericType;
        this.destinationType = def.destinationType;
    }

    public MeasurementDefinition(ResourceType resourceType, @NotNull String name) {
        this.resourceType = resourceType;
        this.name = name;
    }

    public List<MeasurementSchedule> addSchedule(MeasurementSchedule ms) {
        this.schedules.add(ms);
        return this.schedules;
    }

    public String toString() {
        return "[MeasurementDefinition,id=" + this.id + ",name=" + this.name + "]";
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType;
    }

    public MeasurementCategory getCategory() {
        return this.category;
    }

    public void setCategory(MeasurementCategory category) {
        this.category = category;
    }

    public NumericType getNumericType() {
        return this.numericType;
    }

    public void setNumericType(NumericType type) {
        this.numericType = type;
    }

    public void setMeasurementType(NumericType numericType) {
        this.numericType = numericType;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public DisplayType getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(DisplayType displayType) {
        this.displayType = displayType;
    }

    public long getDefaultInterval() {
        return this.defaultInterval;
    }

    public void setDefaultInterval(long defaultInterval) {
        this.defaultInterval = defaultInterval;
    }

    public boolean isDefaultOn() {
        return this.defaultOn;
    }

    public void setDefaultOn(boolean defaultOn) {
        this.defaultOn = defaultOn;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public List<MeasurementSchedule> getSchedules() {
        return this.schedules;
    }

    public void setSchedules(List<MeasurementSchedule> schedules) {
        this.schedules = schedules;
    }

    public MeasurementUnits getUnits() {
        return this.units;
    }

    public void setUnits(MeasurementUnits units) {
        this.units = units;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean isPerMinute() {
        return this.rawNumericType != null;
    }

    public NumericType getRawNumericType() {
        return this.rawNumericType;
    }

    public void setRawNumericType(NumericType rawNumericType) {
        this.rawNumericType = rawNumericType;
    }

    public void update(MeasurementDefinition newDefinition, boolean alsoUpdateInterval) {
        this.displayName = newDefinition.getDisplayName();
        this.category = newDefinition.getCategory();
        this.units = newDefinition.getUnits();
        this.numericType = newDefinition.getNumericType();
        this.dataType = newDefinition.getDataType();
        this.displayType = newDefinition.getDisplayType();
        this.defaultOn = newDefinition.isDefaultOn();
        this.rawNumericType = newDefinition.getRawNumericType();
        if (alsoUpdateInterval) {
            this.defaultInterval = newDefinition.getDefaultInterval();
        }
        this.description = newDefinition.getDescription();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof MeasurementDefinition)) {
            return false;
        }
        MeasurementDefinition that = (MeasurementDefinition)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.resourceType != null ? !this.resourceType.equals(that.resourceType) : that.resourceType != null) {
            return false;
        }
        return this.rawNumericType == that.rawNumericType;
    }

    public int hashCode() {
        int result = this.resourceType != null ? this.resourceType.hashCode() : 0;
        result = 31 * result + (this.rawNumericType != null ? this.rawNumericType.hashCode() : 0);
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public void setDisplayOrder(int i) {
        this.displayOrder = i;
    }

    @Nullable
    public String getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(@Nullable String destinationType) {
        this.destinationType = destinationType;
    }

    public List<AlertCondition> getAlertCondition() {
        return this.alertConditions;
    }

    public void setAlertCondition(List<AlertCondition> alertConditions) {
        this.alertConditions = alertConditions;
    }
}

