/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.measurement;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataPK;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.calltime.CallTimeData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasurementReport
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(MeasurementReport.class);
    private Set<MeasurementDataNumeric> measurementNumericData = Collections.synchronizedSet(new LinkedHashSet());
    private Set<MeasurementDataTrait> measurementTraitData = Collections.synchronizedSet(new LinkedHashSet());
    private Set<CallTimeData> callTimeData = Collections.synchronizedSet(new LinkedHashSet());
    private long collectionTime;

    public void addData(MeasurementDataNumeric value) {
        if (!this.measurementNumericData.add(value)) {
            LOG.info((Object)("Measurement collected twice, second value ignored: " + value));
        }
    }

    public void addData(MeasurementDataTrait value) {
        if (!this.measurementTraitData.add(value)) {
            LOG.info((Object)("Measurement collected twice, second value ignored: " + value));
        }
    }

    public void addData(CallTimeData data) {
        this.callTimeData.add(data);
    }

    public Set<MeasurementDataNumeric> getNumericData() {
        return this.measurementNumericData;
    }

    public Set<MeasurementDataTrait> getTraitData() {
        return this.measurementTraitData;
    }

    @NotNull
    public Set<CallTimeData> getCallTimeData() {
        return this.callTimeData;
    }

    public long getDataCount() {
        return this.measurementNumericData.size() + this.measurementTraitData.size() + this.callTimeData.size();
    }

    public long getCollectionTime() {
        return this.collectionTime;
    }

    public void setCollectionTime(long collectionTime) {
        this.collectionTime = collectionTime;
    }

    public void incrementCollectionTime(long collectionTime) {
        this.collectionTime += collectionTime;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.measurementNumericData.size());
        for (MeasurementDataNumeric measurementDataNumeric : this.measurementNumericData) {
            out.writeInt(measurementDataNumeric.getScheduleId());
            out.writeLong(measurementDataNumeric.getTimestamp());
            out.writeDouble(measurementDataNumeric.getValue() != null ? measurementDataNumeric.getValue() : Double.NaN);
        }
        out.writeInt(this.measurementTraitData.size());
        for (MeasurementDataTrait measurementDataTrait : this.measurementTraitData) {
            out.writeInt(measurementDataTrait.getScheduleId());
            out.writeLong(measurementDataTrait.getTimestamp());
            String value = measurementDataTrait.getValue();
            out.writeUTF(value != null ? value : "");
        }
        out.writeObject(this.callTimeData);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        long timestamp;
        int scheduleId;
        int i;
        int count = in.readInt();
        for (i = 0; i < count; ++i) {
            scheduleId = in.readInt();
            timestamp = in.readLong();
            double doubleValue = in.readDouble();
            this.measurementNumericData.add(new MeasurementDataNumeric(new MeasurementDataPK(timestamp, scheduleId), (Double)doubleValue));
        }
        count = in.readInt();
        for (i = 0; i < count; ++i) {
            scheduleId = in.readInt();
            timestamp = in.readLong();
            String stringValue = in.readUTF();
            if (stringValue == null) {
                stringValue = "";
            }
            this.measurementTraitData.add(new MeasurementDataTrait(new MeasurementDataPK(timestamp, scheduleId), stringValue));
        }
        this.callTimeData = (Set)in.readObject();
    }
}

