/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.plugin;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.plugin.AbstractPlugin;
import org.rhq.core.domain.plugin.PluginDeploymentType;
import org.rhq.core.domain.plugin.PluginStatusType;

@DiscriminatorValue(value="SERVER")
@NamedQueries(value={@NamedQuery(name="ServerPlugin.queryGetStatusByName", query=" SELECT p.status    FROM ServerPlugin AS p   WHERE p.name = :name)"), @NamedQuery(name="ServerPlugin.queryGetKeysByEnabled", query=" SELECT new org.rhq.core.domain.plugin.PluginKey(         p.deployment,         p.type,         p.name)    FROM ServerPlugin AS p   WHERE p.enabled = :enabled         AND p.status = 'INSTALLED' "), @NamedQuery(name="ServerPlugin.findByIds", query=" SELECT new org.rhq.core.domain.plugin.ServerPlugin(         p.id,         p.name,         p.path,         p.displayName,         p.enabled,         p.status,         p.description,         p.help,         p.md5,         p.version,         p.ampsVersion,         p.pluginConfiguration,         p.scheduledJobsConfiguration,         p.type,         p.ctime,         p.mtime)    FROM ServerPlugin AS p         LEFT JOIN p.pluginConfiguration         LEFT JOIN p.scheduledJobsConfiguration   WHERE p.id IN (:ids)         AND p.status = 'INSTALLED' "), @NamedQuery(name="ServerPlugin.findAllByIds", query=" SELECT new org.rhq.core.domain.plugin.ServerPlugin(         p.id,         p.name,         p.path,         p.displayName,         p.enabled,         p.status,         p.description,         p.help,         p.md5,         p.version,         p.ampsVersion,         p.pluginConfiguration,         p.scheduledJobsConfiguration,         p.type,         p.ctime,         p.mtime)    FROM ServerPlugin AS p         LEFT JOIN p.pluginConfiguration         LEFT JOIN p.scheduledJobsConfiguration   WHERE p.id IN (:ids) "), @NamedQuery(name="ServerPlugin.findByName", query=" SELECT new org.rhq.core.domain.plugin.ServerPlugin(         p.id,         p.name,         p.path,         p.displayName,         p.enabled,         p.status,         p.description,         p.help,         p.md5,         p.version,         p.ampsVersion,         p.pluginConfiguration,         p.scheduledJobsConfiguration,         p.type,         p.ctime,         p.mtime)    FROM ServerPlugin AS p         LEFT JOIN p.pluginConfiguration         LEFT JOIN p.scheduledJobsConfiguration   WHERE p.name=:name         AND p.status = 'INSTALLED' "), @NamedQuery(name="ServerPlugin.findAnyByName", query=" SELECT new org.rhq.core.domain.plugin.ServerPlugin(         p.id,         p.name,         p.path,         p.displayName,         p.enabled,         p.status,         p.description,         p.help,         p.md5,         p.version,         p.ampsVersion,         p.pluginConfiguration,         p.scheduledJobsConfiguration,         p.type,         p.ctime,         p.mtime)    FROM ServerPlugin AS p         LEFT JOIN p.pluginConfiguration         LEFT JOIN p.scheduledJobsConfiguration   WHERE p.name=:name "), @NamedQuery(name="ServerPlugin.findAll", query=" SELECT new org.rhq.core.domain.plugin.ServerPlugin(         p.id,         p.name,         p.path,         p.displayName,         p.enabled,         p.status,         p.description,         p.help,         p.md5,         p.version,         p.ampsVersion,         p.pluginConfiguration,         p.scheduledJobsConfiguration,         p.type,         p.ctime,         p.mtime)    FROM ServerPlugin AS p         LEFT JOIN p.pluginConfiguration         LEFT JOIN p.scheduledJobsConfiguration "), @NamedQuery(name="ServerPlugin.findAllInstalled", query=" SELECT new org.rhq.core.domain.plugin.ServerPlugin(         p.id,         p.name,         p.path,         p.displayName,         p.enabled,         p.status,         p.description,         p.help,         p.md5,         p.version,         p.ampsVersion,         p.pluginConfiguration,         p.scheduledJobsConfiguration,         p.type,         p.ctime,         p.mtime)    FROM ServerPlugin AS p         LEFT JOIN p.pluginConfiguration         LEFT JOIN p.scheduledJobsConfiguration    WHERE p.status = 'INSTALLED' "), @NamedQuery(name="ServerPlugin.findAllInstalledKeys", query=" SELECT new org.rhq.core.domain.plugin.PluginKey(         p.deployment,         p.type,         p.name)    FROM ServerPlugin AS p   WHERE p.status = 'INSTALLED' "), @NamedQuery(name="ServerPlugin.findKeysByIds", query=" SELECT new org.rhq.core.domain.plugin.PluginKey(         p.deployment,         p.type,         p.name)    FROM ServerPlugin AS p   WHERE p.id IN (:ids)         AND p.status = 'INSTALLED' "), @NamedQuery(name="ServerPlugin.updatePluginEnabledById", query="UPDATE ServerPlugin p    SET p.enabled = :enabled  WHERE p.id = :id)")})
@Entity
public class ServerPlugin
extends AbstractPlugin {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_GET_STATUS_BY_NAME = "ServerPlugin.queryGetStatusByName";
    public static final String QUERY_GET_KEYS_BY_ENABLED = "ServerPlugin.queryGetKeysByEnabled";
    public static final String QUERY_FIND_BY_IDS = "ServerPlugin.findByIds";
    public static final String QUERY_FIND_ALL_BY_IDS = "ServerPlugin.findAllByIds";
    public static final String QUERY_FIND_BY_NAME = "ServerPlugin.findByName";
    public static final String QUERY_FIND_ANY_BY_NAME = "ServerPlugin.findAnyByName";
    public static final String QUERY_FIND_ALL = "ServerPlugin.findAll";
    public static final String QUERY_FIND_ALL_INSTALLED = "ServerPlugin.findAllInstalled";
    public static final String QUERY_FIND_ALL_INSTALLED_KEYS = "ServerPlugin.findAllInstalledKeys";
    public static final String QUERY_FIND_KEYS_BY_IDS = "ServerPlugin.findKeysByIds";
    public static final String UPDATE_PLUGIN_ENABLED_BY_ID = "ServerPlugin.updatePluginEnabledById";
    @JoinColumn(name="JOBS_CONFIG_ID", referencedColumnName="ID")
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private Configuration scheduledJobsConfiguration;
    @JoinColumn(name="PLUGIN_CONFIG_ID", referencedColumnName="ID")
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    private Configuration pluginConfiguration;
    @Column(name="PTYPE")
    private String type;

    public ServerPlugin() {
        this.setDeployment(PluginDeploymentType.SERVER);
    }

    public ServerPlugin(String name, String path) {
        super(name, path);
        this.setDeployment(PluginDeploymentType.SERVER);
    }

    public ServerPlugin(String name, String path, String md5) {
        super(name, path, md5);
        this.setDeployment(PluginDeploymentType.SERVER);
    }

    public ServerPlugin(String name, String path, byte[] content) {
        super(name, path, content);
        this.setDeployment(PluginDeploymentType.SERVER);
    }

    public ServerPlugin(int id, String name, String path, String displayName, boolean enabled, PluginStatusType status, String description, String help, String md5, String version, String ampsVersion, Configuration pluginConfig, Configuration scheduledJobsConfig, String type, long ctime, long mtime) {
        super(id, name, path, displayName, enabled, status, description, help, md5, version, ampsVersion, PluginDeploymentType.SERVER, ctime, mtime);
        this.pluginConfiguration = pluginConfig;
        this.scheduledJobsConfiguration = scheduledJobsConfig;
        this.type = type;
    }

    public void setDeployment(PluginDeploymentType deployment) {
        if (deployment != PluginDeploymentType.SERVER) {
            throw new IllegalArgumentException("ServerPlugin can only ever have deployment type of SERVER: " + (Object)((Object)deployment));
        }
        super.setDeployment(deployment);
    }

    public Configuration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(Configuration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public Configuration getScheduledJobsConfiguration() {
        return this.scheduledJobsConfiguration;
    }

    public void setScheduledJobsConfiguration(Configuration scheduledJobsConfiguration) {
        this.scheduledJobsConfiguration = scheduledJobsConfiguration;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ServerPlugin)) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "ServerPlugin " + super.toString();
    }
}

