/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.resource.group.composite;

import java.io.Serializable;
import org.rhq.core.domain.resource.composite.ResourceFacets;
import org.rhq.core.domain.resource.group.GroupCategory;
import org.rhq.core.domain.resource.group.ResourceGroup;

public class ResourceGroupComposite
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Double implicitAvail;
    private Double explicitAvail;
    private ResourceGroup resourceGroup;
    private GroupCategory category;
    private long implicitUp;
    private long implicitDown;
    private long explicitUp;
    private long explicitDown;
    private ResourceFacets resourceFacets;

    private ResourceGroupComposite() {
    }

    public ResourceGroupComposite(long explicitCount, double explicitAvailability, long implicitCount, double implicitAvailability, ResourceGroup resourceGroup, ResourceFacets facets) {
        this.explicitUp = Math.round((double)explicitCount * explicitAvailability);
        this.explicitDown = explicitCount - this.explicitUp;
        this.explicitAvail = this.explicitUp + this.explicitDown > 0L ? Double.valueOf(explicitAvailability) : null;
        this.implicitUp = Math.round((double)implicitCount * implicitAvailability);
        this.implicitDown = implicitCount - this.implicitUp;
        this.implicitAvail = this.implicitUp + this.implicitDown > 0L ? Double.valueOf(implicitAvailability) : null;
        this.resourceGroup = resourceGroup;
        if (this.resourceGroup.getGroupCategory() == GroupCategory.COMPATIBLE) {
            this.category = GroupCategory.COMPATIBLE;
        } else if (this.resourceGroup.getGroupCategory() == GroupCategory.MIXED) {
            this.category = GroupCategory.MIXED;
        } else {
            throw new IllegalArgumentException("Unknown category " + (Object)((Object)this.resourceGroup.getGroupCategory()) + " for ResourceGroup " + this.resourceGroup.getName());
        }
        this.resourceFacets = facets;
    }

    public Double getImplicitAvail() {
        return this.implicitAvail;
    }

    public Double getExplicitAvail() {
        return this.explicitAvail;
    }

    public ResourceGroup getResourceGroup() {
        return this.resourceGroup;
    }

    public GroupCategory getCategory() {
        return this.category;
    }

    public long getImplicitUp() {
        return this.implicitUp;
    }

    public long getImplicitDown() {
        return this.implicitDown;
    }

    public long getExplicitUp() {
        return this.explicitUp;
    }

    public long getExplicitDown() {
        return this.explicitDown;
    }

    public String getExplicitFormatted() {
        return this.getAlignedAvailabilityResults(this.getExplicitUp(), this.getExplicitDown());
    }

    public String getImplicitFormatted() {
        return this.getAlignedAvailabilityResults(this.getImplicitUp(), this.getImplicitDown());
    }

    public ResourceFacets getResourceFacets() {
        return this.resourceFacets;
    }

    public String getGroupQueryString() {
        return "category=" + this.getCategory().getName() + "&amp;groupId=" + this.getResourceGroup().getId();
    }

    private String getAlignedAvailabilityResults(long up, long down) {
        StringBuilder results = new StringBuilder();
        results.append("<table width=\"120px\"><tr>");
        if (up == 0L && down == 0L) {
            results.append(this.getColumn(false, "<img src=\"/images/icons/availability_grey_16.png\" /> 0"));
            results.append(this.getColumn(true, new Object[0]));
            results.append(this.getColumn(false, new Object[0]));
        } else {
            if (up > 0L) {
                results.append(this.getColumn(false, " <img src=\"/images/icons/availability_green_16.png\" />", up));
            }
            if (up > 0L && down > 0L) {
                results.append(this.getColumn(true, new Object[0]));
            }
            if (down > 0L) {
                results.append(this.getColumn(false, " <img src=\"/images/icons/availability_red_16.png\" />", down));
            } else {
                results.append(this.getColumn(false, "&nbsp;&nbsp;<img src=\"/images/blank.png\" width=\"16px\" height=\"16px\" />"));
            }
        }
        results.append("</tr></table>");
        return results.toString();
    }

    private String getColumn(boolean isSpacerColumn, Object ... data) {
        StringBuilder results = new StringBuilder();
        if (isSpacerColumn) {
            results.append("<td nowrap=\"nowrap\" style=\"white-space:nowrap;\" width=\"10px\" align=\"left\" >");
        } else {
            results.append("<td nowrap=\"nowrap\" style=\"white-space:nowrap;\" width=\"55px\" align=\"left\" >");
        }
        if (data == null) {
            results.append("&nbsp;");
        } else {
            for (Object datum : data) {
                results.append(datum == null ? "&nbsp;" : datum);
            }
        }
        results.append("</td>");
        return results.toString();
    }

    public String toString() {
        return "ResourceGroupComposite[name=" + this.resourceGroup.getName() + ", implicit[up/down/avail=," + this.implicitUp + "/" + this.implicitDown + "/" + this.implicitAvail + "]" + ", explicit[up/down/avail=," + this.explicitUp + "/" + this.explicitDown + "/" + this.explicitAvail + "]" + ", permission=" + "]";
    }

    private class GroupDefinitionMember
    extends ResourceGroup {
        private GroupDefinitionMember() {
        }

        public void setGroupCategory(GroupCategory category) {
            super.setGroupCategory(category);
        }
    }
}

