/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.ejb.EntityManagerImpl;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.jmx.StatisticsService;
import org.hibernate.stat.Statistics;
import org.rhq.core.domain.util.OrderingField;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUtility {
    private static final Log LOG = LogFactory.getLog(PersistenceUtility.class);
    private static final Pattern COUNT_QUERY_PATTERN = Pattern.compile("^(\\s*SELECT\\s+)(.*?)(\\s+FROM.*)", 42);
    private static final Pattern COUNT_QUERY_REMOVE_FETCH = Pattern.compile("FETCH", 42);
    public static final String HIBERNATE_STATISTICS_MBEAN_OBJECTNAME = "Hibernate:type=statistics,application=RHQ";

    public static Query createQueryWithOrderBy(EntityManager entityManager, String queryName, PageControl pageControl) {
        Query query;
        if (pageControl.getPrimarySortColumn() != null) {
            query = PersistenceUtility.createQueryWithOrderBy(entityManager, queryName, pageControl.getOrderingFieldsAsArray());
        } else {
            StackTraceElement caller = new Throwable().fillInStackTrace().getStackTrace()[1];
            LOG.warn((Object)("Queries should really supply default sort columns. Caller did not: " + caller));
            query = entityManager.createNamedQuery(queryName);
        }
        PersistenceUtility.setDataPage(query, pageControl);
        return query;
    }

    public static Query createQueryWithOrderBy(EntityManager entityManager, String queryName, OrderingField ... orderByFields) {
        NamedQueryDefinition ndc = PersistenceUtility.getNamedQueryDefinition(entityManager, queryName);
        StringBuilder query = new StringBuilder(ndc.getQueryString());
        PersistenceUtility.buildOrderBy(query, orderByFields);
        return entityManager.createQuery(query.toString());
    }

    public static Query createNonNamedQueryWithOrderBy(EntityManager entityManager, String queryText, PageControl pageControl) {
        Query query;
        if (pageControl.getPrimarySortColumn() != null) {
            query = PersistenceUtility.createNonNamedQueryWithOrderBy(entityManager, queryText, pageControl.getOrderingFieldsAsArray());
        } else {
            StackTraceElement caller = new Throwable().fillInStackTrace().getStackTrace()[1];
            LOG.warn((Object)("Queries should really supply default sort columns. Caller did not: " + caller));
            query = entityManager.createQuery(queryText);
        }
        PersistenceUtility.setDataPage(query, pageControl);
        return query;
    }

    public static Query createNonNamedQueryWithOrderBy(EntityManager entityManager, String queryText, OrderingField ... orderByFields) {
        StringBuilder query = new StringBuilder(queryText);
        PersistenceUtility.buildOrderBy(query, orderByFields);
        return entityManager.createQuery(query.toString());
    }

    private static StringBuilder buildOrderBy(StringBuilder query, OrderingField ... orderByFields) {
        boolean first = true;
        for (OrderingField orderingField : orderByFields) {
            if (first) {
                query.append(" ORDER BY ");
                first = false;
            } else {
                query.append(", ");
            }
            query.append(orderingField.getField()).append(" ").append((Object)orderingField.getOrdering());
        }
        return query;
    }

    private static String getOrderByFragment(OrderingField ... orderByFields) {
        boolean first = true;
        StringBuilder builder = new StringBuilder();
        for (OrderingField orderingField : orderByFields) {
            if (first) {
                builder.append(" ORDER BY ");
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(orderingField.getField()).append(" ").append((Object)orderingField.getOrdering());
        }
        return builder.toString();
    }

    public static Query createCountQuery(EntityManager em, String queryName) {
        return PersistenceUtility.createCountQuery(em, queryName, "*");
    }

    public static Query createCountQuery(EntityManager entityManager, String queryName, String countItem) {
        NamedQueryDefinition namedQueryDefinition = PersistenceUtility.getNamedQueryDefinition(entityManager, queryName);
        String query = namedQueryDefinition.getQueryString();
        Matcher matcher = COUNT_QUERY_PATTERN.matcher(query);
        if (!matcher.find()) {
            throw new RuntimeException("Unable to transform query into count query [" + queryName + " - " + query + "]");
        }
        String newQuery = matcher.group(1) + "COUNT(" + countItem + ")" + matcher.group(3);
        if ((matcher = COUNT_QUERY_REMOVE_FETCH.matcher(newQuery)).find()) {
            StringBuffer buffer = new StringBuffer();
            do {
                matcher.appendReplacement(buffer, "");
            } while (matcher.find());
            matcher.appendTail(buffer);
            newQuery = buffer.toString();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Transformed query to count query [" + queryName + "] resulting in [" + newQuery + "]"));
        }
        return entityManager.createQuery(newQuery);
    }

    public static void setDataPage(Query query, PageControl pageControl) {
        if (pageControl.getPageSize() > 0) {
            query.setFirstResult(pageControl.getStartRow());
            query.setMaxResults(pageControl.getPageSize());
        }
    }

    public static String formatSearchParameter(String value) {
        if (value == null || value.trim().equals("")) {
            return null;
        }
        return "%" + value.replaceAll("\\_", "\\\\_").toUpperCase() + "%";
    }

    public static PageList createPaginationFilter(EntityManager entityManager, Collection collection, PageControl pageControl) {
        if (collection == null) {
            return new PageList(pageControl);
        }
        String filter = "";
        if (pageControl.getPrimarySortColumn() != null) {
            PageOrdering order = pageControl.getPrimarySortOrder() == null ? PageOrdering.ASC : pageControl.getPrimarySortOrder();
            filter = PersistenceUtility.buildOrderBy(new StringBuilder(), new OrderingField(pageControl.getPrimarySortColumn(), order)).toString();
        }
        org.hibernate.Query query = PersistenceUtility.getHibernateSession(entityManager).createFilter((Object)collection, filter);
        if (pageControl.getPageSize() > 0) {
            query.setFirstResult(pageControl.getPageNumber() * pageControl.getPageSize());
            query.setMaxResults(pageControl.getPageSize());
        }
        PersistenceUtility.getHibernateSession(entityManager).flush();
        return new PageList(query.list(), pageControl);
    }

    public static <T> List<T> findByCriteria(EntityManager entityManager, Class<T> type, Criterion ... criterion) {
        Criteria crit = PersistenceUtility.getHibernateSession(entityManager).createCriteria(type);
        for (Criterion c : criterion) {
            crit.add(c);
        }
        return crit.list();
    }

    public static Session getHibernateSession(EntityManager entityManager) {
        Session session;
        if (entityManager.getDelegate() instanceof EntityManagerImpl) {
            EntityManagerImpl entityManagerImpl = (EntityManagerImpl)entityManager.getDelegate();
            session = entityManagerImpl.getSession();
        } else {
            session = (Session)entityManager.getDelegate();
        }
        return session;
    }

    public static void enableHibernateStatistics(EntityManager entityManager, MBeanServer server) {
        try {
            SessionFactory sessionFactory = PersistenceUtility.getHibernateSession(entityManager).getSessionFactory();
            if (server == null) {
                ArrayList<MBeanServer> list = MBeanServerFactory.findMBeanServer(null);
                server = list.get(0);
            }
            ObjectName objectName = new ObjectName(HIBERNATE_STATISTICS_MBEAN_OBJECTNAME);
            StatisticsService mBean = new StatisticsService();
            mBean.setSessionFactory(sessionFactory);
            server.registerMBean(mBean, objectName);
            sessionFactory.getStatistics().setStatisticsEnabled(true);
        }
        catch (InstanceAlreadyExistsException iaee) {
            LOG.info((Object)"Duplicate mbean registration ignored: Hibernate:type=statistics,application=RHQ");
        }
        catch (Exception e) {
            LOG.warn((Object)"Couldn't register hibernate statistics mbean", (Throwable)e);
        }
    }

    public static Statistics getStatisticsService(EntityManager entityManager, MBeanServer server) {
        Session hibernateSession = PersistenceUtility.getHibernateSession(entityManager);
        SessionFactory hibernateSessionFactory = hibernateSession.getSessionFactory();
        Statistics hibernateStatistics = hibernateSessionFactory.getStatistics();
        return hibernateStatistics;
    }

    public static String getQueryDefinitionFromNamedQuery(EntityManager entityManager, String queryName) {
        NamedQueryDefinition ndc = PersistenceUtility.getNamedQueryDefinition(entityManager, queryName);
        return ndc.getQueryString();
    }

    private static NamedQueryDefinition getNamedQueryDefinition(EntityManager entityManager, String queryName) {
        SessionFactoryImplementor sessionFactory = PersistenceUtility.getHibernateSessionFactoryImplementor(entityManager);
        NamedQueryDefinition namedQueryDefinition = sessionFactory.getNamedQuery(queryName);
        if (namedQueryDefinition == null) {
            throw new RuntimeException("EJB3 query not found [" + queryName + "]");
        }
        return namedQueryDefinition;
    }

    private static SessionFactoryImplementor getHibernateSessionFactoryImplementor(EntityManager entityManager) {
        Session session = PersistenceUtility.getHibernateSession(entityManager);
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)session.getSessionFactory();
        return sessionFactory;
    }

    public static String addPostgresNativePagingSortingToQuery(String query, PageControl pageControl) {
        return PersistenceUtility.addLimitOffsetToQuery(query, pageControl);
    }

    public static String addOracleNativePagingSortingToQuery(String query, PageControl pageControl) {
        StringBuilder queryWithPagingSorting = new StringBuilder(query.length() + 50);
        int minRowNum = pageControl.getStartRow() + 1;
        int maxRowNum = minRowNum + pageControl.getPageSize() - 1;
        queryWithPagingSorting.append("SELECT outerResults.* FROM ( ");
        queryWithPagingSorting.append("SELECT innerResults.*, ROWNUM rnum FROM ( ");
        queryWithPagingSorting.append(query);
        PersistenceUtility.buildOrderBy(queryWithPagingSorting, pageControl.getOrderingFieldsAsArray());
        queryWithPagingSorting.append(" ) innerResults ");
        queryWithPagingSorting.append(" WHERE ROWNUM <= ").append(maxRowNum);
        queryWithPagingSorting.append(" ) outerResults ");
        queryWithPagingSorting.append(" WHERE rnum >= ").append(minRowNum);
        return queryWithPagingSorting.toString();
    }

    public static String addSQLServerNativePagingSortingToQuery(String query, PageControl pageControl) {
        return PersistenceUtility.addSQLServerNativePagingSortingToQuery(query, pageControl, false);
    }

    public static String addSQLServerNativePagingSortingToQuery(String query, PageControl pageControl, boolean alternatePagingStyle) {
        StringBuilder queryWithPagingSorting = new StringBuilder(query.length() + 50);
        int minRowNum = pageControl.getStartRow() + 1;
        int maxRowNum = minRowNum + pageControl.getPageSize() - 1;
        String orderByClause = PersistenceUtility.getOrderByFragment(pageControl.getOrderingFieldsAsArray());
        if (alternatePagingStyle) {
            int index = PersistenceUtility.findSelectListEndIndex(query);
            String selectList = query.substring(0, index);
            String restOfQuery = query.substring(index);
            queryWithPagingSorting.append("SELECT singleResults.* FROM ( ");
            queryWithPagingSorting.append(selectList);
            queryWithPagingSorting.append(", ROW_NUMBER() OVER( " + orderByClause + " ) AS rownum ");
            queryWithPagingSorting.append(restOfQuery);
            queryWithPagingSorting.append(") AS singleResults ");
        } else {
            queryWithPagingSorting.append("SELECT outerResults.* FROM ( ");
            queryWithPagingSorting.append("   SELECT innerResults.*, ");
            queryWithPagingSorting.append("          ROW_NUMBER() OVER( " + orderByClause + " ) AS rownum ");
            queryWithPagingSorting.append("   FROM ( " + query + " ) AS innerResults ");
            queryWithPagingSorting.append(" ) AS outerResults ");
        }
        queryWithPagingSorting.append("WHERE rownum <= ").append(maxRowNum);
        queryWithPagingSorting.append(" AND rownum >= ").append(minRowNum);
        return queryWithPagingSorting.toString();
    }

    private static int findSelectListEndIndex(String query) {
        int nesting = 0;
        query = query.toLowerCase();
        StringBuilder wordBuffer = new StringBuilder();
        for (int i = 0; i < query.length(); ++i) {
            char next = query.charAt(i);
            if (next == '(') {
                ++nesting;
                continue;
            }
            if (next == ')') {
                --nesting;
                continue;
            }
            if (nesting != 0) continue;
            if (Character.isLetter(next)) {
                wordBuffer.append(next);
                if (!wordBuffer.toString().equals("from")) continue;
                return i - 4;
            }
            wordBuffer.setLength(0);
        }
        throw new IllegalArgumentException("Could not find select list end index");
    }

    public static String addH2NativePagingSortingToQuery(String query, PageControl pageControl) {
        return PersistenceUtility.addLimitOffsetToQuery(query, pageControl);
    }

    private static String addLimitOffsetToQuery(String query, PageControl pageControl) {
        StringBuilder queryWithPagingSorting = new StringBuilder(query.length() + 50);
        queryWithPagingSorting.append(query);
        PersistenceUtility.buildOrderBy(queryWithPagingSorting, pageControl.getOrderingFieldsAsArray());
        queryWithPagingSorting.append(" LIMIT ").append(pageControl.getPageSize());
        queryWithPagingSorting.append(" OFFSET ").append(pageControl.getStartRow());
        return queryWithPagingSorting.toString();
    }
}

