/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.conversation;

import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.servlet.http.HttpSession;
import org.jboss.weld.context.api.BeanStore;
import org.jboss.weld.conversation.AbstractConversationManager;
import org.jboss.weld.conversation.ConversationConcurrentAccessTimeout;
import org.jboss.weld.conversation.ConversationIdName;
import org.jboss.weld.conversation.ConversationInactivityTimeout;
import org.jboss.weld.servlet.ConversationBeanStore;

@SessionScoped
public class ServletConversationManager
extends AbstractConversationManager {
    private static final long serialVersionUID = 1647848566880659085L;
    private static final long CONVERSATION_TIMEOUT_IN_MS = 600000L;
    private static final long CONVERSATION_CONCURRENT_ACCESS_TIMEOUT_IN_MS = 1000L;
    private static final String CONVERSATION_ID_NAME = "cid";
    @Inject
    private Instance<HttpSession> httpSession;

    public BeanStore getBeanStore(String cid) {
        return new ConversationBeanStore((HttpSession)this.httpSession.get(), cid);
    }

    @Produces
    @ConversationInactivityTimeout
    public static long getConversationTimeoutInMilliseconds() {
        return 600000L;
    }

    @Produces
    @ConversationConcurrentAccessTimeout
    public static long getConversationConcurrentAccessTimeout() {
        return 1000L;
    }

    @Produces
    @ConversationIdName
    public static String getConversationIdName() {
        return CONVERSATION_ID_NAME;
    }
}

