/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.ObserverException;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.New;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.inject.Inject;
import javax.inject.Qualifier;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bootstrap.events.AbstractContainerEvent;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.logging.messages.EventMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObserverMethodImpl<T, X>
implements ObserverMethod<T> {
    public static final String ID_PREFIX = ObserverMethodImpl.class.getPackage().getName();
    public static final String ID_SEPARATOR = "-";
    private final Set<Annotation> bindings;
    private final Type eventType;
    protected BeanManagerImpl manager;
    private final Reception notifyType;
    protected final RIBean<X> declaringBean;
    protected final MethodInjectionPoint<T, ? super X> observerMethod;
    protected TransactionPhase transactionPhase;
    private final String id;
    private final Set<WeldInjectionPoint<?, ?>> newInjectionPoints;

    protected ObserverMethodImpl(WeldMethod<T, ? super X> observer, RIBean<X> declaringBean, BeanManagerImpl manager) {
        this.manager = manager;
        this.declaringBean = declaringBean;
        this.observerMethod = MethodInjectionPoint.of(declaringBean, observer);
        this.eventType = this.observerMethod.getAnnotatedParameters(Observes.class).get(0).getBaseType();
        this.id = ID_PREFIX + ID_SEPARATOR + ObserverMethod.class.getSimpleName() + ID_SEPARATOR + declaringBean.getBeanClass().getName() + "." + observer.getSignature();
        this.bindings = new HashSet<Annotation>(this.observerMethod.getAnnotatedParameters(Observes.class).get(0).getMetaAnnotations(Qualifier.class));
        Observes observesAnnotation = (Observes)this.observerMethod.getAnnotatedParameters(Observes.class).get(0).getAnnotation(Observes.class);
        this.notifyType = observesAnnotation.notifyObserver();
        this.transactionPhase = TransactionPhase.IN_PROGRESS;
        this.newInjectionPoints = new HashSet();
        for (ParameterInjectionPoint<?, ?> injectionPoint : Beans.getParameterInjectionPoints(null, this.observerMethod)) {
            if (!injectionPoint.isAnnotationPresent(New.class)) continue;
            this.newInjectionPoints.add(injectionPoint);
        }
    }

    public Set<WeldInjectionPoint<?, ?>> getNewInjectionPoints() {
        return this.newInjectionPoints;
    }

    private void checkObserverMethod() {
        List eventObjects = this.observerMethod.getAnnotatedParameters(Observes.class);
        if (this.notifyType.equals((Object)Reception.IF_EXISTS) && this.declaringBean.getScope().equals(Dependent.class)) {
            throw new DefinitionException(EventMessage.INVALID_SCOPED_CONDITIONAL_OBSERVER, this);
        }
        if (eventObjects.size() > 1) {
            throw new DefinitionException(EventMessage.MULTIPLE_EVENT_PARAMETERS, this);
        }
        List disposeParams = this.observerMethod.getAnnotatedParameters(Disposes.class);
        if (disposeParams.size() > 0) {
            throw new DefinitionException(EventMessage.INVALID_DISPOSES_PARAMETER, this);
        }
        if (this.observerMethod.isAnnotationPresent(Produces.class)) {
            throw new DefinitionException(EventMessage.INVALID_PRODUCER, this);
        }
        if (this.observerMethod.isAnnotationPresent(Inject.class)) {
            throw new DefinitionException(EventMessage.INVALID_INITIALIZER, this);
        }
    }

    public Class<X> getBeanClass() {
        return this.declaringBean.getType();
    }

    public Annotation[] getBindingsAsArray() {
        return this.bindings.toArray(new Annotation[0]);
    }

    public Reception getReception() {
        return this.notifyType;
    }

    public Set<Annotation> getObservedQualifiers() {
        return this.bindings;
    }

    public Type getObservedType() {
        return this.eventType;
    }

    public TransactionPhase getTransactionPhase() {
        return this.transactionPhase;
    }

    public MethodInjectionPoint<T, ? super X> getMethod() {
        return this.observerMethod;
    }

    public void initialize() {
        this.checkObserverMethod();
    }

    public void notify(T event) {
        if (this.ignore(event)) {
            return;
        }
        this.sendEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendEvent(T event) {
        Object instance = null;
        CreationalContext creationalContext = null;
        try {
            if (this.notifyType.equals((Object)Reception.ALWAYS)) {
                creationalContext = this.manager.createCreationalContext((Contextual)this.declaringBean);
            }
            if ((instance = this.manager.getReference(this.declaringBean, creationalContext, false)) == null) {
                return;
            }
            this.observerMethod.invokeOnInstanceWithSpecialValue(instance, Observes.class, event, this.manager, creationalContext, ObserverException.class);
        }
        finally {
            if (creationalContext != null && Dependent.class.equals((Object)this.declaringBean.getScope())) {
                creationalContext.release();
            }
        }
    }

    protected boolean ignore(T event) {
        Class<?> eventType = event.getClass();
        return AbstractContainerEvent.class.isAssignableFrom(eventType) && !Extension.class.isAssignableFrom(this.getBeanClass());
    }

    public String toString() {
        return this.id;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObserverMethodImpl) {
            ObserverMethodImpl that = (ObserverMethodImpl)obj;
            return this.getId().equals(that.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

