/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.callback.statistics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanServer;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.CallbackListener;
import org.jboss.remoting.callback.HandleCallbackException;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.transport.Connector;

public class CallbackServer {
    private static String transport = "socket";
    private static String host = "localhost";
    private static int port = 5400;
    private static int callbackCounter = 1;
    private Connector connector = null;
    private static final String RESPONSE_VALUE = "This is the return to SampleInvocationHandler invocation";

    public void setupServer(String locatorURI) throws Exception {
        InvokerLocator locator = new InvokerLocator(locatorURI);
        System.out.println("Starting remoting server with locator uri of: " + locatorURI);
        this.connector = new Connector();
        this.connector.setInvokerLocator(locator.getLocatorURI());
        this.connector.create();
        SampleInvocationHandler invocationHandler = new SampleInvocationHandler();
        this.connector.addInvocationHandler("sample", invocationHandler);
        this.connector.start();
    }

    public void shutdownServer() {
        this.connector.stop();
        this.connector.destroy();
    }

    public static void main(String[] args) {
        if (args != null && args.length == 2) {
            transport = args[0];
            port = Integer.parseInt(args[1]);
        }
        String locatorURI = transport + "://" + host + ":" + port;
        CallbackServer server = new CallbackServer();
        try {
            server.setupServer(locatorURI);
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static class SampleInvocationHandler
    implements ServerInvocationHandler,
    Runnable,
    CallbackListener {
        private List listeners = new ArrayList();
        private boolean shouldGenerateCallbacks = false;

        public SampleInvocationHandler() {
            Thread callbackThread = new Thread(this);
            callbackThread.setDaemon(true);
            callbackThread.start();
        }

        public Object invoke(InvocationRequest invocation) throws Throwable {
            return CallbackServer.RESPONSE_VALUE;
        }

        public void addListener(InvokerCallbackHandler callbackHandler) {
            System.out.println("Adding callback listener.");
            this.listeners.add(callbackHandler);
            this.shouldGenerateCallbacks = true;
        }

        public void removeListener(InvokerCallbackHandler callbackHandler) {
            System.out.println("Removing callback listener.");
            this.listeners.remove(callbackHandler);
            if (this.listeners.size() == 0) {
                this.shouldGenerateCallbacks = false;
            }
        }

        public void run() {
            while (true) {
                if (this.shouldGenerateCallbacks) {
                    Callback callback = new Callback("Callback " + callbackCounter + ": This is the payload of callback invocation.");
                    System.out.println("sending callback: " + callbackCounter);
                    HashMap<String, Object> returnPayload = new HashMap<String, Object>();
                    returnPayload.put("callbackListener", this);
                    returnPayload.put("callbackId", new Integer(callbackCounter++));
                    returnPayload.put("remotingAcknowledgesPushCallbacks", "true");
                    callback.setReturnPayload(returnPayload);
                    Iterator itr = this.listeners.iterator();
                    while (itr.hasNext()) {
                        InvokerCallbackHandler callbackHandler = (InvokerCallbackHandler)itr.next();
                        try {
                            callbackHandler.handleCallback(callback);
                        }
                        catch (HandleCallbackException e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        public void setMBeanServer(MBeanServer server) {
        }

        public void setInvoker(ServerInvoker invoker) {
        }

        public void acknowledgeCallback(InvokerCallbackHandler callbackHandler, Object callbackId, Object response) {
            System.out.println("received acknowledgement for callback: " + callbackId);
        }
    }
}

