/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.ExpandWar;
import org.apache.catalina.util.IOTools;
import org.apache.catalina.util.StringManager;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.logging.Logger;

public class HostConfig
implements LifecycleListener {
    protected static Logger log = Logger.getLogger(HostConfig.class);
    protected File appBase = null;
    protected File configBase = null;
    protected String configClass = "org.apache.catalina.startup.ContextConfig";
    protected String contextClass = "org.apache.catalina.core.StandardContext";
    protected Host host = null;
    protected ObjectName oname = null;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    protected boolean deployXML = false;
    protected boolean unpackWARs = false;
    protected HashMap<String, DeployedApplication> deployed = new HashMap();
    protected ArrayList<String> serviced = new ArrayList();
    protected static Digester digester = HostConfig.createDigester();

    public String getConfigClass() {
        return this.configClass;
    }

    public void setConfigClass(String configClass) {
        this.configClass = configClass;
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public void setContextClass(String contextClass) {
        this.contextClass = contextClass;
    }

    public boolean isDeployXML() {
        return this.deployXML;
    }

    public void setDeployXML(boolean deployXML) {
        this.deployXML = deployXML;
    }

    public boolean isUnpackWARs() {
        return this.unpackWARs;
    }

    public void setUnpackWARs(boolean unpackWARs) {
        this.unpackWARs = unpackWARs;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getType().equals("periodic")) {
            this.check();
        }
        try {
            this.host = (Host)((Object)event.getLifecycle());
            if (this.host instanceof StandardHost) {
                this.setDeployXML(((StandardHost)this.host).isDeployXML());
                this.setUnpackWARs(((StandardHost)this.host).isUnpackWARs());
            }
        }
        catch (ClassCastException e) {
            log.error((Object)sm.getString("hostConfig.cce", event.getLifecycle()), (Throwable)e);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    public synchronized void addServiced(String name) {
        this.serviced.add(name);
    }

    public synchronized boolean isServiced(String name) {
        return this.serviced.contains(name);
    }

    public synchronized void removeServiced(String name) {
        this.serviced.remove(name);
    }

    public long getDeploymentTime(String name) {
        DeployedApplication app = this.deployed.get(name);
        if (app == null) {
            return 0L;
        }
        return app.timestamp;
    }

    public boolean isDeployed(String name) {
        DeployedApplication app = this.deployed.get(name);
        return app != null;
    }

    protected static Digester createDigester() {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("Context", "org.apache.catalina.core.StandardContext", "className");
        digester.addSetProperties("Context");
        return digester;
    }

    protected File appBase() {
        if (this.appBase != null) {
            return this.appBase;
        }
        File file = new File(this.host.getAppBase());
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.host.getAppBase());
        }
        try {
            this.appBase = file.getCanonicalFile();
        }
        catch (IOException e) {
            this.appBase = file;
        }
        return this.appBase;
    }

    protected File configBase() {
        if (this.configBase != null) {
            return this.configBase;
        }
        File file = new File(System.getProperty("catalina.base"), "conf");
        Container parent = this.host.getParent();
        if (parent != null && parent instanceof Engine) {
            file = new File(file, parent.getName());
        }
        file = new File(file, this.host.getName());
        try {
            this.configBase = file.getCanonicalFile();
        }
        catch (IOException e) {
            this.configBase = file;
        }
        return this.configBase;
    }

    public String getConfigBaseName() {
        return this.configBase().getAbsolutePath();
    }

    protected String getConfigFile(String path) {
        String basename = null;
        basename = path.equals("") ? "ROOT" : path.substring(1).replace('/', '#');
        return basename;
    }

    protected String getDocBase(String path) {
        String basename = null;
        basename = path.equals("") ? "ROOT" : path.substring(1).replace('/', '#');
        return basename;
    }

    protected void deployApps() {
        File appBase = this.appBase();
        File configBase = this.configBase();
        this.deployDescriptors(configBase, configBase.list());
        this.deployWARs(appBase, appBase.list());
        this.deployDirectories(appBase, appBase.list());
    }

    protected void deployApps(String name) {
        File dir;
        File war;
        File appBase = this.appBase();
        File configBase = this.configBase();
        String baseName = this.getConfigFile(name);
        String docBase = this.getDocBase(name);
        File xml = new File(configBase, baseName + ".xml");
        if (xml.exists()) {
            this.deployDescriptor(name, xml, baseName + ".xml");
        }
        if ((war = new File(appBase, docBase + ".war")).exists()) {
            this.deployWAR(name, war, docBase + ".war");
        }
        if ((dir = new File(appBase, docBase)).exists()) {
            this.deployDirectory(name, dir, docBase);
        }
    }

    protected void deployDescriptors(File configBase, String[] files) {
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].equalsIgnoreCase("META-INF") || files[i].equalsIgnoreCase("WEB-INF")) continue;
            File contextXml = new File(configBase, files[i]);
            if (!files[i].toLowerCase().endsWith(".xml")) continue;
            String nameTmp = files[i].substring(0, files[i].length() - 4);
            String contextPath = "/" + nameTmp.replace('#', '/');
            if (nameTmp.equals("ROOT")) {
                contextPath = "";
            }
            if (this.isServiced(contextPath)) continue;
            String file = files[i];
            this.deployDescriptor(contextPath, contextXml, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployDescriptor(String contextPath, File contextXml, String file) {
        if (this.deploymentExists(contextPath)) {
            return;
        }
        DeployedApplication deployedApp = new DeployedApplication(contextPath);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("hostConfig.deployDescriptor", file));
        }
        Context context = null;
        try {
            Digester digester = HostConfig.digester;
            synchronized (digester) {
                try {
                    context = (Context)HostConfig.digester.parse(contextXml);
                    if (context == null) {
                        log.error((Object)sm.getString("hostConfig.deployDescriptor.error", file));
                        return;
                    }
                }
                finally {
                    HostConfig.digester.reset();
                }
            }
            if (context instanceof Lifecycle) {
                Class<?> clazz = Class.forName(this.host.getConfigClass());
                LifecycleListener listener = (LifecycleListener)clazz.newInstance();
                ((Lifecycle)((Object)context)).addLifecycleListener(listener);
            }
            context.setConfigFile(contextXml.getAbsolutePath());
            context.setPath(contextPath);
            boolean isExternalWar = false;
            boolean isExternal = false;
            if (context.getDocBase() != null) {
                File docBase = new File(context.getDocBase());
                if (!docBase.isAbsolute()) {
                    docBase = new File(this.appBase(), context.getDocBase());
                }
                if (!docBase.getCanonicalPath().startsWith(this.appBase().getAbsolutePath() + File.separator)) {
                    isExternal = true;
                    deployedApp.redeployResources.put(contextXml.getAbsolutePath(), new Long(contextXml.lastModified()));
                    deployedApp.redeployResources.put(docBase.getAbsolutePath(), new Long(docBase.lastModified()));
                    if (docBase.getAbsolutePath().toLowerCase().endsWith(".war")) {
                        isExternalWar = true;
                    }
                } else {
                    log.warn((Object)sm.getString("hostConfig.deployDescriptor.localDocBaseSpecified", docBase));
                    context.setDocBase(null);
                }
            }
            this.host.addChild(context);
            String name = null;
            String path = context.getPath();
            name = path.equals("") ? "ROOT" : (path.startsWith("/") ? path.substring(1) : path);
            File expandedDocBase = new File(this.appBase(), name);
            if (context.getDocBase() != null && !(expandedDocBase = new File(context.getDocBase())).isAbsolute()) {
                expandedDocBase = new File(this.appBase(), context.getDocBase());
            }
            if (isExternalWar && this.unpackWARs) {
                deployedApp.redeployResources.put(expandedDocBase.getAbsolutePath(), new Long(expandedDocBase.lastModified()));
                deployedApp.redeployResources.put(contextXml.getAbsolutePath(), new Long(contextXml.lastModified()));
                this.addWatchedResources(deployedApp, expandedDocBase.getAbsolutePath(), context);
            } else {
                File warDocBase;
                if (!isExternal && (warDocBase = new File(expandedDocBase.getAbsolutePath() + ".war")).exists()) {
                    deployedApp.redeployResources.put(warDocBase.getAbsolutePath(), new Long(warDocBase.lastModified()));
                }
                if (expandedDocBase.exists()) {
                    deployedApp.redeployResources.put(expandedDocBase.getAbsolutePath(), new Long(expandedDocBase.lastModified()));
                    this.addWatchedResources(deployedApp, expandedDocBase.getAbsolutePath(), context);
                } else {
                    this.addWatchedResources(deployedApp, null, context);
                }
                if (!isExternal) {
                    deployedApp.redeployResources.put(contextXml.getAbsolutePath(), new Long(contextXml.lastModified()));
                }
            }
        }
        catch (Throwable t) {
            log.error((Object)sm.getString("hostConfig.deployDescriptor.error", file), t);
        }
        if (context != null && this.host.findChild(context.getName()) != null) {
            this.deployed.put(contextPath, deployedApp);
        }
    }

    protected void deployWARs(File appBase, String[] files) {
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].equalsIgnoreCase("META-INF") || files[i].equalsIgnoreCase("WEB-INF")) continue;
            File dir = new File(appBase, files[i]);
            if (!files[i].toLowerCase().endsWith(".war") || !dir.isFile()) continue;
            String contextPath = "/" + files[i].replace('#', '/');
            int period = contextPath.lastIndexOf(".");
            if (period >= 0) {
                contextPath = contextPath.substring(0, period);
            }
            if (contextPath.equals("/ROOT")) {
                contextPath = "";
            }
            if (this.isServiced(contextPath)) continue;
            String file = files[i];
            this.deployWAR(contextPath, dir, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployWAR(String contextPath, File war, String file) {
        File xml;
        block38: {
            if (this.deploymentExists(contextPath)) {
                return;
            }
            JarFile jar = null;
            JarEntry entry = null;
            InputStream istream = null;
            FilterOutputStream ostream = null;
            xml = new File(this.configBase, file.substring(0, file.lastIndexOf(".")) + ".xml");
            if (this.deployXML && !xml.exists()) {
                try {
                    jar = new JarFile(war);
                    entry = jar.getJarEntry("META-INF/context.xml");
                    if (entry != null) {
                        int n;
                        istream = jar.getInputStream(entry);
                        this.configBase.mkdirs();
                        ostream = new BufferedOutputStream(new FileOutputStream(xml), 1024);
                        byte[] buffer = new byte[1024];
                        while ((n = istream.read(buffer)) >= 0) {
                            ((BufferedOutputStream)ostream).write(buffer, 0, n);
                        }
                        ((BufferedOutputStream)ostream).flush();
                        ostream.close();
                        ostream = null;
                        istream.close();
                        istream = null;
                        entry = null;
                        jar.close();
                        jar = null;
                    }
                }
                catch (Exception e) {
                    if (ostream != null) {
                        try {
                            ostream.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        ostream = null;
                    }
                    if (istream == null) break block38;
                    try {
                        istream.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    istream = null;
                }
                finally {
                    entry = null;
                    if (jar != null) {
                        try {
                            jar.close();
                        }
                        catch (Throwable t) {}
                        jar = null;
                    }
                }
            }
        }
        DeployedApplication deployedApp = new DeployedApplication(contextPath);
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("hostConfig.deployJar", file));
        }
        try {
            Context context = null;
            if (this.deployXML && xml.exists()) {
                Digester digester = HostConfig.digester;
                synchronized (digester) {
                    try {
                        context = (Context)HostConfig.digester.parse(xml);
                        if (context == null) {
                            log.error((Object)sm.getString("hostConfig.deployDescriptor.error", file));
                            return;
                        }
                    }
                    finally {
                        HostConfig.digester.reset();
                    }
                }
                context.setConfigFile(xml.getAbsolutePath());
            } else {
                context = (Context)Class.forName(this.contextClass).newInstance();
            }
            deployedApp.redeployResources.put(war.getAbsolutePath(), new Long(war.lastModified()));
            if (this.deployXML && xml.exists()) {
                deployedApp.redeployResources.put(xml.getAbsolutePath(), new Long(xml.lastModified()));
            }
            if (context instanceof Lifecycle) {
                Class<?> clazz = Class.forName(this.host.getConfigClass());
                LifecycleListener listener = (LifecycleListener)clazz.newInstance();
                ((Lifecycle)((Object)context)).addLifecycleListener(listener);
            }
            context.setPath(contextPath);
            context.setDocBase(file);
            this.host.addChild(context);
            if (this.unpackWARs && context.getDocBase() != null) {
                String name = null;
                String path = context.getPath();
                name = path.equals("") ? "ROOT" : (path.startsWith("/") ? path.substring(1) : path);
                File docBase = new File(name = name.replace('/', '#'));
                if (!docBase.isAbsolute()) {
                    docBase = new File(this.appBase(), name);
                }
                deployedApp.redeployResources.put(docBase.getAbsolutePath(), new Long(docBase.lastModified()));
                this.addWatchedResources(deployedApp, docBase.getAbsolutePath(), context);
            } else {
                this.addWatchedResources(deployedApp, null, context);
            }
        }
        catch (Throwable t) {
            log.error((Object)sm.getString("hostConfig.deployJar.error", file), t);
        }
        this.deployed.put(contextPath, deployedApp);
    }

    protected void deployDirectories(File appBase, String[] files) {
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File dir;
            if (files[i].equalsIgnoreCase("META-INF") || files[i].equalsIgnoreCase("WEB-INF") || !(dir = new File(appBase, files[i])).isDirectory()) continue;
            String contextPath = "/" + files[i].replace('#', '/');
            if (files[i].equals("ROOT")) {
                contextPath = "";
            }
            if (this.isServiced(contextPath)) continue;
            this.deployDirectory(contextPath, dir, files[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployDirectory(String contextPath, File dir, String file) {
        DeployedApplication deployedApp = new DeployedApplication(contextPath);
        if (this.deploymentExists(contextPath)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("hostConfig.deployDir", file));
        }
        try {
            Context context = null;
            File xml = new File(dir, "META-INF/context.xml");
            File xmlCopy = null;
            if (this.deployXML && xml.exists()) {
                Digester digester = HostConfig.digester;
                synchronized (digester) {
                    try {
                        context = (Context)HostConfig.digester.parse(xml);
                        if (context == null) {
                            log.error((Object)sm.getString("hostConfig.deployDescriptor.error", xml));
                            return;
                        }
                    }
                    finally {
                        HostConfig.digester.reset();
                    }
                }
                this.configBase.mkdirs();
                xmlCopy = new File(this.configBase(), file + ".xml");
                FileInputStream is = null;
                FileOutputStream os = null;
                try {
                    is = new FileInputStream(xml);
                    os = new FileOutputStream(xmlCopy);
                    IOTools.flow(is, os);
                }
                finally {
                    try {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                    }
                    catch (IOException e) {}
                    try {
                        if (os != null) {
                            ((OutputStream)os).close();
                        }
                    }
                    catch (IOException e) {}
                }
                context.setConfigFile(xmlCopy.getAbsolutePath());
            } else {
                context = (Context)Class.forName(this.contextClass).newInstance();
            }
            if (context instanceof Lifecycle) {
                Class<?> clazz = Class.forName(this.host.getConfigClass());
                LifecycleListener listener = (LifecycleListener)clazz.newInstance();
                ((Lifecycle)((Object)context)).addLifecycleListener(listener);
            }
            context.setPath(contextPath);
            context.setDocBase(file);
            this.host.addChild(context);
            deployedApp.redeployResources.put(dir.getAbsolutePath(), new Long(dir.lastModified()));
            if (xmlCopy != null) {
                deployedApp.redeployResources.put(xmlCopy.getAbsolutePath(), new Long(xmlCopy.lastModified()));
            }
            this.addWatchedResources(deployedApp, dir.getAbsolutePath(), context);
        }
        catch (Throwable t) {
            log.error((Object)sm.getString("hostConfig.deployDir.error", file), t);
        }
        this.deployed.put(contextPath, deployedApp);
    }

    protected boolean deploymentExists(String contextPath) {
        return this.deployed.containsKey(contextPath) || this.host.findChild(contextPath) != null;
    }

    protected void addWatchedResources(DeployedApplication app, String docBase, Context context) {
        File docBaseFile = null;
        if (docBase != null && !(docBaseFile = new File(docBase)).isAbsolute()) {
            docBaseFile = new File(this.appBase(), docBase);
        }
        String[] watchedResources = context.findWatchedResources();
        for (int i = 0; i < watchedResources.length; ++i) {
            File resource = new File(watchedResources[i]);
            if (!resource.isAbsolute()) {
                if (docBase != null) {
                    resource = new File(docBaseFile, watchedResources[i]);
                } else {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Ignoring non-existent WatchedResource '" + resource.getAbsolutePath() + "'"));
                    continue;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Watching WatchedResource '" + resource.getAbsolutePath() + "'"));
            }
            app.reloadResources.put(resource.getAbsolutePath(), new Long(resource.lastModified()));
        }
    }

    protected synchronized void checkResources(DeployedApplication app) {
        long lastModified;
        File resource;
        int i;
        String[] resources = app.redeployResources.keySet().toArray(new String[0]);
        for (i = 0; i < resources.length; ++i) {
            resource = new File(resources[i]);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking context[" + app.name + "] redeploy resource " + resource));
            }
            if (resource.exists()) {
                lastModified = app.redeployResources.get(resources[i]);
                if (resource.isDirectory() || resource.lastModified() <= lastModified) continue;
                if (log.isInfoEnabled()) {
                    log.info((Object)sm.getString("hostConfig.undeploy", app.name));
                }
                ContainerBase context = (ContainerBase)this.host.findChild(app.name);
                try {
                    this.host.removeChild(context);
                }
                catch (Throwable t) {
                    log.warn((Object)sm.getString("hostConfig.context.remove", app.name), t);
                }
                try {
                    context.destroy();
                }
                catch (Throwable t) {
                    log.warn((Object)sm.getString("hostConfig.context.destroy", app.name), t);
                }
                for (int j = i + 1; j < resources.length; ++j) {
                    try {
                        File current = new File(resources[j]);
                        current = current.getCanonicalFile();
                        if (!current.getAbsolutePath().startsWith(this.appBase().getAbsolutePath() + File.separator) && !current.getAbsolutePath().startsWith(this.configBase().getAbsolutePath())) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Delete " + current));
                        }
                        ExpandWar.delete(current);
                        continue;
                    }
                    catch (IOException e) {
                        log.warn((Object)sm.getString("hostConfig.canonicalizing", app.name), (Throwable)e);
                    }
                }
                this.deployed.remove(app.name);
                return;
            }
            lastModified = app.redeployResources.get(resources[i]);
            if (lastModified == 0L) continue;
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("hostConfig.undeploy", app.name));
            }
            ContainerBase context = (ContainerBase)this.host.findChild(app.name);
            try {
                this.host.removeChild(context);
            }
            catch (Throwable t) {
                log.warn((Object)sm.getString("hostConfig.context.remove", app.name), t);
            }
            try {
                context.destroy();
            }
            catch (Throwable t) {
                log.warn((Object)sm.getString("hostConfig.context.destroy", app.name), t);
            }
            for (int j = i + 1; j < resources.length; ++j) {
                try {
                    File current = new File(resources[j]);
                    current = current.getCanonicalFile();
                    if (!current.getAbsolutePath().startsWith(this.appBase().getAbsolutePath() + File.separator) && !current.getAbsolutePath().startsWith(this.configBase().getAbsolutePath())) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Delete " + current));
                    }
                    ExpandWar.delete(current);
                    continue;
                }
                catch (IOException e) {
                    log.warn((Object)sm.getString("hostConfig.canonicalizing", app.name), (Throwable)e);
                }
            }
            String[] resources2 = app.reloadResources.keySet().toArray(new String[0]);
            for (int j = 0; j < resources2.length; ++j) {
                try {
                    File current = new File(resources2[j]);
                    current = current.getCanonicalFile();
                    if (!current.getAbsolutePath().startsWith(this.appBase().getAbsolutePath() + File.separator) && (!current.getAbsolutePath().startsWith(this.configBase().getAbsolutePath()) || !current.getAbsolutePath().endsWith(".xml"))) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Delete " + current));
                    }
                    ExpandWar.delete(current);
                    continue;
                }
                catch (IOException e) {
                    log.warn((Object)sm.getString("hostConfig.canonicalizing", app.name), (Throwable)e);
                }
            }
            this.deployed.remove(app.name);
            return;
        }
        resources = app.reloadResources.keySet().toArray(new String[0]);
        for (i = 0; i < resources.length; ++i) {
            resource = new File(resources[i]);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking context[" + app.name + "] reload resource " + resource));
            }
            lastModified = app.reloadResources.get(resources[i]);
            if ((resource.exists() || lastModified == 0L) && resource.lastModified() == lastModified) continue;
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("hostConfig.reload", app.name));
            }
            Container context = this.host.findChild(app.name);
            try {
                ((Lifecycle)((Object)context)).stop();
            }
            catch (Exception e) {
                log.warn((Object)sm.getString("hostConfig.context.restart", app.name), (Throwable)e);
            }
            try {
                ((Lifecycle)((Object)context)).start();
            }
            catch (Exception e) {
                log.warn((Object)sm.getString("hostConfig.context.restart", app.name), (Throwable)e);
            }
            app.reloadResources.put(resources[i], new Long(resource.lastModified()));
            app.timestamp = System.currentTimeMillis();
            return;
        }
    }

    public void start() {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("hostConfig.start"));
        }
        try {
            ObjectName hostON = new ObjectName(this.host.getObjectName());
            this.oname = new ObjectName(hostON.getDomain() + ":type=Deployer,host=" + this.host.getName());
            Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, this.getClass().getName());
        }
        catch (Exception e) {
            log.error((Object)sm.getString("hostConfig.jmx.register", this.oname), (Throwable)e);
        }
        if (this.host.getDeployOnStartup()) {
            this.deployApps();
        }
    }

    public void stop() {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("hostConfig.stop"));
        }
        this.undeployApps();
        if (this.oname != null) {
            try {
                Registry.getRegistry(null, null).unregisterComponent(this.oname);
            }
            catch (Exception e) {
                log.error((Object)sm.getString("hostConfig.jmx.unregister", this.oname), (Throwable)e);
            }
        }
        this.oname = null;
        this.appBase = null;
        this.configBase = null;
    }

    protected void undeployApps() {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("hostConfig.undeploying"));
        }
        DeployedApplication[] apps = this.deployed.values().toArray(new DeployedApplication[0]);
        for (int i = 0; i < apps.length; ++i) {
            try {
                this.host.removeChild(this.host.findChild(apps[i].name));
                continue;
            }
            catch (Throwable t) {
                log.warn((Object)sm.getString("hostConfig.context.remove", apps[i].name), t);
            }
        }
        this.deployed.clear();
    }

    protected void check() {
        if (this.host.getAutoDeploy()) {
            DeployedApplication[] apps = this.deployed.values().toArray(new DeployedApplication[0]);
            for (int i = 0; i < apps.length; ++i) {
                if (this.isServiced(apps[i].name)) continue;
                this.checkResources(apps[i]);
            }
            this.deployApps();
        }
    }

    public void check(String name) {
        DeployedApplication app = this.deployed.get(name);
        if (app != null) {
            this.checkResources(app);
        } else {
            this.deployApps(name);
        }
    }

    public void manageApp(Context context) {
        String contextPath = context.getPath();
        if (this.deployed.containsKey(contextPath)) {
            return;
        }
        DeployedApplication deployedApp = new DeployedApplication(contextPath);
        boolean isWar = false;
        if (context.getDocBase() != null) {
            File docBase = new File(context.getDocBase());
            if (!docBase.isAbsolute()) {
                docBase = new File(this.appBase(), context.getDocBase());
            }
            deployedApp.redeployResources.put(docBase.getAbsolutePath(), new Long(docBase.lastModified()));
            if (docBase.getAbsolutePath().toLowerCase().endsWith(".war")) {
                isWar = true;
            }
        }
        this.host.addChild(context);
        if (isWar && this.unpackWARs) {
            String name = null;
            String path = context.getPath();
            name = path.equals("") ? "ROOT" : (path.startsWith("/") ? path.substring(1) : path);
            File docBase = new File(name);
            if (!docBase.isAbsolute()) {
                docBase = new File(this.appBase(), name);
            }
            deployedApp.redeployResources.put(docBase.getAbsolutePath(), new Long(docBase.lastModified()));
            this.addWatchedResources(deployedApp, docBase.getAbsolutePath(), context);
        } else {
            this.addWatchedResources(deployedApp, null, context);
        }
        this.deployed.put(contextPath, deployedApp);
    }

    public void unmanageApp(String contextPath) {
        if (this.isServiced(contextPath)) {
            this.deployed.remove(contextPath);
            this.host.removeChild(this.host.findChild(contextPath));
        }
    }

    protected class DeployedApplication {
        public String name;
        public LinkedHashMap<String, Long> redeployResources = new LinkedHashMap();
        public HashMap<String, Long> reloadResources = new HashMap();
        public long timestamp = System.currentTimeMillis();

        public DeployedApplication(String name) {
            this.name = name;
        }
    }
}

