/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.deploy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.catalina.deploy.ResourceBase;

public class ContextHandler
extends ResourceBase
implements Serializable {
    private String handlerclass = null;
    private HashMap soapHeaders = new HashMap();
    private ArrayList<String> soapRoles = new ArrayList();
    private ArrayList<String> portNames = new ArrayList();

    public String getHandlerclass() {
        return this.handlerclass;
    }

    public void setHandlerclass(String handlerclass) {
        this.handlerclass = handlerclass;
    }

    public Iterator getLocalparts() {
        return this.soapHeaders.keySet().iterator();
    }

    public String getNamespaceuri(String localpart) {
        return (String)this.soapHeaders.get(localpart);
    }

    public void addSoapHeaders(String localpart, String namespaceuri) {
        this.soapHeaders.put(localpart, namespaceuri);
    }

    public void setProperty(String name, String value) {
        this.setProperty(name, (Object)value);
    }

    public String getSoapRole(int i) {
        return this.soapRoles.get(i);
    }

    public int getSoapRolesSize() {
        return this.soapRoles.size();
    }

    public void addSoapRole(String soapRole) {
        this.soapRoles.add(soapRole);
    }

    public String getPortName(int i) {
        return this.portNames.get(i);
    }

    public int getPortNamesSize() {
        return this.portNames.size();
    }

    public void addPortName(String portName) {
        this.portNames.add(portName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ContextHandler[");
        sb.append("name=");
        sb.append(this.getName());
        if (this.handlerclass != null) {
            sb.append(", class=");
            sb.append(this.handlerclass);
        }
        if (this.soapHeaders != null) {
            sb.append(", soap-headers=");
            sb.append(this.soapHeaders);
        }
        if (this.getSoapRolesSize() > 0) {
            sb.append(", soap-roles=");
            sb.append(this.soapRoles);
        }
        if (this.getPortNamesSize() > 0) {
            sb.append(", port-name=");
            sb.append(this.portNames);
        }
        if (this.listProperties() != null) {
            sb.append(", init-param=");
            sb.append(this.listProperties());
        }
        sb.append("]");
        return sb.toString();
    }
}

