/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager.host;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import javax.management.MBeanServer;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.HostConfig;
import org.apache.catalina.util.StringManager;
import org.apache.tomcat.util.modeler.Registry;

public class HostManagerServlet
extends HttpServlet
implements ContainerServlet {
    protected File configBase = null;
    protected Context context = null;
    protected int debug = 1;
    protected Host host = null;
    protected Engine engine = null;
    protected MBeanServer mBeanServer = null;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.manager.host");
    protected Wrapper wrapper = null;

    @Override
    public Wrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
        if (wrapper == null) {
            this.context = null;
            this.host = null;
            this.engine = null;
        } else {
            this.context = (Context)wrapper.getParent();
            this.host = (Host)this.context.getParent();
            this.engine = (Engine)this.host.getParent();
        }
        this.mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
    }

    public void destroy() {
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (request.getAttribute("org.apache.catalina.INVOKED") != null) {
            throw new UnavailableException(sm.getString("hostManagerServlet.cannotInvoke"));
        }
        String command = request.getPathInfo();
        if (command == null) {
            command = request.getServletPath();
        }
        String name = request.getParameter("name");
        response.setContentType("text/plain; charset=utf-8");
        PrintWriter writer = response.getWriter();
        if (command == null) {
            writer.println(sm.getString("hostManagerServlet.noCommand"));
        } else if (command.equals("/add")) {
            this.add(request, writer, name, false);
        } else if (command.equals("/remove")) {
            this.remove(writer, name);
        } else if (command.equals("/list")) {
            this.list(writer);
        } else if (command.equals("/start")) {
            this.start(writer, name);
        } else if (command.equals("/stop")) {
            this.stop(writer, name);
        } else {
            writer.println(sm.getString("hostManagerServlet.unknownCommand", command));
        }
        writer.flush();
        writer.close();
    }

    protected void add(HttpServletRequest request, PrintWriter writer, String name, boolean htmlMode) {
        String aliases = request.getParameter("aliases");
        String appBase = request.getParameter("appBase");
        boolean manager = this.booleanParameter(request, "manager", false, htmlMode);
        boolean autoDeploy = this.booleanParameter(request, "autoDeploy", true, htmlMode);
        boolean deployOnStartup = this.booleanParameter(request, "deployOnStartup", true, htmlMode);
        boolean deployXML = this.booleanParameter(request, "deployXML", true, htmlMode);
        boolean unpackWARs = this.booleanParameter(request, "unpackWARs", true, htmlMode);
        boolean xmlNamespaceAware = this.booleanParameter(request, "xmlNamespaceAware", false, htmlMode);
        boolean xmlValidation = this.booleanParameter(request, "xmlValidation", false, htmlMode);
        this.add(writer, name, aliases, appBase, manager, autoDeploy, deployOnStartup, deployXML, unpackWARs, xmlNamespaceAware, xmlValidation);
    }

    protected boolean booleanParameter(HttpServletRequest request, String parameter, boolean theDefault, boolean htmlMode) {
        String value = request.getParameter(parameter);
        boolean booleanValue = theDefault;
        if (value != null) {
            if (htmlMode) {
                if (value.equals("on")) {
                    booleanValue = true;
                }
            } else if (theDefault) {
                if (value.equals("false")) {
                    booleanValue = false;
                }
            } else if (value.equals("true")) {
                booleanValue = true;
            }
        } else if (htmlMode) {
            booleanValue = false;
        }
        return booleanValue;
    }

    public void init() throws ServletException {
        if (this.wrapper == null || this.context == null) {
            throw new UnavailableException(sm.getString("hostManagerServlet.noWrapper"));
        }
        String servletName = this.getServletConfig().getServletName();
        if (servletName == null) {
            servletName = "";
        }
        if (servletName.startsWith("org.apache.catalina.INVOKER.")) {
            throw new UnavailableException(sm.getString("hostManagerServlet.cannotInvoke"));
        }
        String value = null;
        try {
            value = this.getServletConfig().getInitParameter("debug");
            this.debug = Integer.parseInt(value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void add(PrintWriter writer, String name, String aliases, String appBase, boolean manager, boolean autoDeploy, boolean deployOnStartup, boolean deployXML, boolean unpackWARs, boolean xmlNamespaceAware, boolean xmlValidation) {
        File file;
        if (this.debug >= 1) {
            this.log("add: Adding host '" + name + "'");
        }
        if (name == null || name.length() == 0) {
            writer.println(sm.getString("hostManagerServlet.invalidHostName", name));
            return;
        }
        if (this.engine.findChild(name) != null) {
            writer.println(sm.getString("hostManagerServlet.alreadyHost", name));
            return;
        }
        File appBaseFile = null;
        if (appBase == null || appBase.length() == 0) {
            appBase = name;
        }
        if (!(file = new File(appBase)).isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), appBase);
        }
        try {
            appBaseFile = file.getCanonicalFile();
        }
        catch (IOException e) {
            appBaseFile = file;
        }
        if (!appBaseFile.exists()) {
            appBaseFile.mkdirs();
        }
        File configBaseFile = this.getConfigBase(name);
        if (manager) {
            InputStream is = null;
            OutputStream os = null;
            try {
                is = this.getServletContext().getResourceAsStream("/manager.xml");
                os = new FileOutputStream(new File(configBaseFile, "manager.xml"));
                byte[] buffer = new byte[512];
                int len = buffer.length;
                while ((len = is.read(buffer)) != -1) {
                    os.write(buffer, 0, len);
                }
            }
            catch (IOException e) {
                writer.println(sm.getString("hostManagerServlet.managerXml"));
                return;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        StandardHost host = new StandardHost();
        host.setAppBase(appBase);
        host.setName(name);
        host.addLifecycleListener(new HostConfig());
        if (aliases != null && !"".equals(aliases)) {
            StringTokenizer tok = new StringTokenizer(aliases, ", ");
            while (tok.hasMoreTokens()) {
                host.addAlias(tok.nextToken());
            }
        }
        host.setAutoDeploy(autoDeploy);
        host.setDeployOnStartup(deployOnStartup);
        host.setDeployXML(deployXML);
        host.setUnpackWARs(unpackWARs);
        try {
            this.engine.addChild(host);
        }
        catch (Exception e) {
            writer.println(sm.getString("hostManagerServlet.exception", e.toString()));
            return;
        }
        host = (StandardHost)this.engine.findChild(name);
        if (host != null) {
            writer.println(sm.getString("hostManagerServlet.add", name));
        } else {
            writer.println(sm.getString("hostManagerServlet.addFailed", name));
        }
    }

    protected synchronized void remove(PrintWriter writer, String name) {
        if (this.debug >= 1) {
            this.log("remove: Removing host '" + name + "'");
        }
        if (name == null || name.length() == 0) {
            writer.println(sm.getString("hostManagerServlet.invalidHostName", name));
            return;
        }
        if (this.engine.findChild(name) == null) {
            writer.println(sm.getString("hostManagerServlet.noHost", name));
            return;
        }
        if (this.engine.findChild(name) == this.host) {
            writer.println(sm.getString("hostManagerServlet.cannotRemoveOwnHost", name));
            return;
        }
        try {
            Container child = this.engine.findChild(name);
            this.engine.removeChild(child);
            if (child instanceof ContainerBase) {
                ((ContainerBase)child).destroy();
            }
        }
        catch (Exception e) {
            writer.println(sm.getString("hostManagerServlet.exception", e.toString()));
            return;
        }
        StandardHost host = (StandardHost)this.engine.findChild(name);
        if (host == null) {
            writer.println(sm.getString("hostManagerServlet.remove", name));
        } else {
            writer.println(sm.getString("hostManagerServlet.removeFailed", name));
        }
    }

    protected void list(PrintWriter writer) {
        if (this.debug >= 1) {
            this.log("list: Listing hosts for engine '" + this.engine.getName() + "'");
        }
        writer.println(sm.getString("hostManagerServlet.listed", this.engine.getName()));
        Container[] hosts = this.engine.findChildren();
        for (int i = 0; i < hosts.length; ++i) {
            Host host = (Host)hosts[i];
            String name = host.getName();
            String[] aliases = host.findAliases();
            StringBuilder buf = new StringBuilder();
            if (aliases.length > 0) {
                buf.append(aliases[0]);
                for (int j = 1; j < aliases.length; ++j) {
                    buf.append(',').append(aliases[j]);
                }
            }
            writer.println(sm.getString("hostManagerServlet.listitem", name, buf.toString()));
        }
    }

    protected void start(PrintWriter writer, String name) {
        if (this.debug >= 1) {
            this.log("start: Starting host with name '" + name + "'");
        }
        if (name == null || name.length() == 0) {
            writer.println(sm.getString("hostManagerServlet.invalidHostName", name));
            return;
        }
        if (this.engine.findChild(name) == null) {
            writer.println(sm.getString("hostManagerServlet.noHost", name));
            return;
        }
        if (this.engine.findChild(name) == this.host) {
            writer.println(sm.getString("hostManagerServlet.cannotStartOwnHost", name));
            return;
        }
        try {
            ((Lifecycle)((Object)this.engine.findChild(name))).start();
            writer.println(sm.getString("hostManagerServlet.started", name));
        }
        catch (Throwable t) {
            this.getServletContext().log(sm.getString("hostManagerServlet.startFailed", name), t);
            writer.println(sm.getString("hostManagerServlet.startFailed", name));
            writer.println(sm.getString("hostManagerServlet.exception", t.toString()));
            return;
        }
    }

    protected void stop(PrintWriter writer, String name) {
        if (this.debug >= 1) {
            this.log("stop: Stopping host with name '" + name + "'");
        }
        if (name == null || name.length() == 0) {
            writer.println(sm.getString("hostManagerServlet.invalidHostName", name));
            return;
        }
        if (this.engine.findChild(name) == null) {
            writer.println(sm.getString("hostManagerServlet.noHost", name));
            return;
        }
        if (this.engine.findChild(name) == this.host) {
            writer.println(sm.getString("hostManagerServlet.cannotStopOwnHost", name));
            return;
        }
        try {
            ((Lifecycle)((Object)this.engine.findChild(name))).stop();
            writer.println(sm.getString("hostManagerServlet.stopped", name));
        }
        catch (Throwable t) {
            this.getServletContext().log(sm.getString("hostManagerServlet.stopFailed", name), t);
            writer.println(sm.getString("hostManagerServlet.stopFailed", name));
            writer.println(sm.getString("hostManagerServlet.exception", t.toString()));
            return;
        }
    }

    protected File getConfigBase(String hostName) {
        File configBase = new File(System.getProperty("catalina.base"), "conf");
        if (!configBase.exists()) {
            return null;
        }
        if (this.engine != null) {
            configBase = new File(configBase, this.engine.getName());
        }
        if (this.host != null) {
            configBase = new File(configBase, hostName);
        }
        configBase.mkdirs();
        return configBase;
    }
}

