/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.integration.password;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLEncryptionUtil {
    public static final String CIPHER_DATA_LOCALNAME = "CipherData";
    public static final String ENCRYPTED_DATA_LOCALNAME = "EncryptedData";
    public static final String ENCRYPTED_KEY_LOCALNAME = "EncryptedKey";
    public static final String DS_KEY_INFO = "ds:KeyInfo";
    public static final String XMLNS = "http://www.w3.org/2000/xmlns/";
    public static String XMLSIG_NS = "http://www.w3.org/2000/09/xmldsig#";
    public static String XMLENC_NS = "http://www.w3.org/2001/04/xmlenc#";
    private static Map<String, EncryptionAlgorithm> algorithms = new HashMap<String, EncryptionAlgorithm>(4);

    public static EncryptedKey encryptKey(Document document, SecretKey keyToBeEncrypted, PublicKey keyUsedToEncryptSecretKey, int keySize) throws Exception {
        if (keyToBeEncrypted == null) {
            throw new IllegalArgumentException("secret key is null");
        }
        XMLCipher keyCipher = null;
        String pubKeyAlg = keyUsedToEncryptSecretKey.getAlgorithm();
        String keyWrapAlgo = XMLEncryptionUtil.getXMLEncryptionURLForKeyUnwrap(pubKeyAlg, keySize);
        keyCipher = XMLCipher.getInstance((String)keyWrapAlgo);
        keyCipher.init(3, (Key)keyUsedToEncryptSecretKey);
        return keyCipher.encryptKey(document, (Key)keyToBeEncrypted);
    }

    public static Document encrypt(Document document, SecretKey secretKey, PublicKey publicKey, int keySize) throws Exception {
        XMLCipher cipher = XMLCipher.getInstance((String)XMLEncryptionUtil.algorithms.get((Object)"aes-128").xmlSecName);
        cipher.init(1, (Key)secretKey);
        EncryptedKey ekey = XMLEncryptionUtil.encryptKey(document, secretKey, publicKey, keySize);
        String encryptionAlgorithm = XMLEncryptionUtil.getXMLEncryptionURL(secretKey.getAlgorithm(), keySize);
        cipher = XMLCipher.getInstance((String)encryptionAlgorithm);
        cipher.init(1, (Key)secretKey);
        Document encryptedDoc = cipher.doFinal(document, document.getDocumentElement());
        Element encryptedDocRootElement = encryptedDoc.getDocumentElement();
        Element encryptedKeyElement = cipher.martial(document, ekey);
        Element sigElement = encryptedDoc.createElementNS(XMLSIG_NS, DS_KEY_INFO);
        sigElement.setAttributeNS(XMLNS, "xmlns:ds", XMLSIG_NS);
        sigElement.appendChild(encryptedKeyElement);
        NodeList nodeList = encryptedDocRootElement.getElementsByTagNameNS(XMLENC_NS, CIPHER_DATA_LOCALNAME);
        if (nodeList == null || nodeList.getLength() == 0) {
            throw new IllegalStateException("xenc:CipherData Element Missing");
        }
        Element cipherDataElement = (Element)nodeList.item(0);
        encryptedDocRootElement.insertBefore(sigElement, cipherDataElement);
        return encryptedDoc;
    }

    public static Document decrypt(Document encryptedDoc, PrivateKey privateKey) throws Exception {
        Element docRoot = encryptedDoc.getDocumentElement();
        Node dataEL = null;
        Node keyEL = null;
        if (XMLENC_NS.equals(docRoot.getNamespaceURI()) && ENCRYPTED_DATA_LOCALNAME.equals(docRoot.getLocalName())) {
            dataEL = docRoot;
        } else {
            NodeList childs = docRoot.getElementsByTagNameNS(XMLENC_NS, ENCRYPTED_DATA_LOCALNAME);
            if (childs == null || childs.getLength() == 0) {
                throw new IllegalStateException("Encrypted Data not found");
            }
            dataEL = childs.item(0);
        }
        NodeList keyList = dataEL.getElementsByTagNameNS(XMLENC_NS, ENCRYPTED_KEY_LOCALNAME);
        if (keyList == null || keyList.getLength() == 0) {
            throw new IllegalStateException("Encrypted Key not found");
        }
        keyEL = keyList.item(0);
        if (dataEL == null) {
            throw new IllegalStateException("Encrypted Data not found");
        }
        if (keyEL == null) {
            throw new IllegalStateException("Encrypted Key not found");
        }
        XMLCipher cipher = XMLCipher.getInstance();
        cipher.init(2, null);
        EncryptedData encryptedData = cipher.loadEncryptedData(encryptedDoc, dataEL);
        EncryptedKey encryptedKey = cipher.loadEncryptedKey(encryptedDoc, (Element)keyEL);
        Document decryptedDoc = null;
        if (encryptedData != null && encryptedKey != null) {
            String encAlgoURL = encryptedData.getEncryptionMethod().getAlgorithm();
            XMLCipher keyCipher = XMLCipher.getInstance();
            keyCipher.init(4, (Key)privateKey);
            Key encryptionKey = keyCipher.decryptKey(encryptedKey, encAlgoURL);
            cipher = XMLCipher.getInstance();
            cipher.init(2, encryptionKey);
            decryptedDoc = cipher.doFinal(encryptedDoc, dataEL);
        }
        return decryptedDoc;
    }

    private static String getXMLEncryptionURLForKeyUnwrap(String publicKeyAlgo, int keySize) {
        if ("AES".equals(publicKeyAlgo)) {
            switch (keySize) {
                case 192: {
                    return "http://www.w3.org/2001/04/xmlenc#kw-aes192";
                }
                case 256: {
                    return "http://www.w3.org/2001/04/xmlenc#kw-aes256";
                }
            }
            return "http://www.w3.org/2001/04/xmlenc#kw-aes128";
        }
        if (publicKeyAlgo.contains("RSA")) {
            return "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
        }
        if (publicKeyAlgo.contains("DES")) {
            return "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
        }
        throw new IllegalArgumentException("unsupported publicKey Algo:" + publicKeyAlgo);
    }

    public static String getXMLEncryptionURL(String algo, int keySize) {
        if ("AES".equals(algo)) {
            switch (keySize) {
                case 192: {
                    return "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
                }
                case 256: {
                    return "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
                }
            }
            return "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
        }
        if (algo.contains("RSA")) {
            return "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
        }
        if (algo.contains("DES")) {
            return "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
        }
        throw new IllegalArgumentException("Secret Key with unsupported algo:" + algo);
    }

    static {
        algorithms.put("aes-128", new EncryptionAlgorithm("AES", "http://www.w3.org/2001/04/xmlenc#aes128-cbc", 128));
        algorithms.put("aes-192", new EncryptionAlgorithm("AES", "http://www.w3.org/2001/04/xmlenc#aes192-cbc", 192));
        algorithms.put("aes-256", new EncryptionAlgorithm("AES", "http://www.w3.org/2001/04/xmlenc#aes256-cbc", 256));
        algorithms.put("tripledes", new EncryptionAlgorithm("TripleDes", "http://www.w3.org/2001/04/xmlenc#tripledes-cbc", 168));
        Init.init();
    }

    private static class EncryptionAlgorithm {
        public String jceName;
        public String xmlSecName;
        public int size;

        EncryptionAlgorithm(String jceName, String xmlSecName, int size) {
            this.jceName = jceName;
            this.xmlSecName = xmlSecName;
            this.size = size;
        }
    }
}

