/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.proxy;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.interceptor.model.InterceptionModel;
import org.jboss.interceptor.model.InterceptionType;
import org.jboss.interceptor.model.InterceptionTypeRegistry;
import org.jboss.interceptor.model.InterceptorClassMetadata;
import org.jboss.interceptor.proxy.DirectClassInterceptionHandler;
import org.jboss.interceptor.proxy.InterceptionChain;
import org.jboss.interceptor.proxy.InterceptionHandler;
import org.jboss.interceptor.proxy.InterceptionHandlerFactory;
import org.jboss.interceptor.proxy.InterceptorInvocationContext;
import org.jboss.interceptor.proxy.LifecycleMixin;
import org.jboss.interceptor.registry.InterceptorClassMetadataRegistry;
import org.jboss.interceptor.util.InterceptionUtils;
import org.jboss.interceptor.util.ReflectionUtils;
import org.jboss.interceptor.util.proxy.TargetInstanceProxyMethodHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorMethodHandler
extends TargetInstanceProxyMethodHandler
implements Serializable {
    private Map<Object, InterceptionHandler> interceptorHandlerInstances = new HashMap<Object, InterceptionHandler>();
    private InterceptorClassMetadata targetClassInterceptorMetadata;
    private List<InterceptionModel<Class<?>, ?>> interceptionModels;

    public InterceptorMethodHandler(Object target, Class<?> targetClass, List<InterceptionModel<Class<?>, ?>> interceptionModels, List<InterceptionHandlerFactory<?>> interceptionHandlerFactories, boolean includeTargetClass) {
        super(target, targetClass != null ? targetClass : target.getClass());
        if (interceptionModels == null) {
            throw new IllegalArgumentException("Interception model must not be null");
        }
        if (interceptionHandlerFactories == null) {
            throw new IllegalArgumentException("Interception handler factory must not be null");
        }
        if (interceptionModels.size() != interceptionHandlerFactories.size()) {
            throw new IllegalArgumentException("For each interception model, an interception factory must be provided");
        }
        this.interceptionModels = interceptionModels;
        for (int i = 0; i < interceptionModels.size(); ++i) {
            for (Object interceptorReference : this.interceptionModels.get(i).getAllInterceptors()) {
                this.interceptorHandlerInstances.put(interceptorReference, interceptionHandlerFactories.get(i).createFor(interceptorReference));
            }
        }
        if (includeTargetClass) {
            this.targetClassInterceptorMetadata = InterceptorClassMetadataRegistry.getRegistry().getInterceptorClassMetadata(this.getTargetClass(), true);
        }
    }

    @Override
    public Object doInvoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
        ReflectionUtils.ensureAccessible(thisMethod);
        if (!thisMethod.getDeclaringClass().equals(LifecycleMixin.class)) {
            if (!InterceptionUtils.isInterceptionCandidate(thisMethod)) {
                return thisMethod.invoke(this.getTargetInstance(), args);
            }
            if (InterceptionTypeRegistry.supportsTimeoutMethods() && thisMethod.isAnnotationPresent(InterceptionTypeRegistry.TIMEOUT_ANNOTATION_CLASS)) {
                return this.executeInterception(thisMethod, args, InterceptionType.AROUND_TIMEOUT);
            }
            return this.executeInterception(thisMethod, args, InterceptionType.AROUND_INVOKE);
        }
        if (thisMethod.getName().equals("lifecycle_mixin_$$_postConstruct")) {
            return this.executeInterception(null, null, InterceptionType.POST_CONSTRUCT);
        }
        if (thisMethod.getName().equals("lifecycle_mixin_$$_preDestroy")) {
            return this.executeInterception(null, null, InterceptionType.PRE_DESTROY);
        }
        return null;
    }

    private Object executeInterception(Method thisMethod, Object[] args, InterceptionType interceptionType) throws Throwable {
        ArrayList<InterceptionHandler> interceptionHandlers = new ArrayList<InterceptionHandler>();
        for (InterceptionModel<Class<?>, ?> interceptionModel : this.interceptionModels) {
            List<?> interceptorList = interceptionModel.getInterceptors(interceptionType, thisMethod);
            for (Object interceptorReference : interceptorList) {
                interceptionHandlers.add(this.interceptorHandlerInstances.get(interceptorReference));
            }
        }
        if (this.targetClassInterceptorMetadata != null && this.targetClassInterceptorMetadata.getInterceptorMethods(interceptionType) != null && !this.targetClassInterceptorMetadata.getInterceptorMethods(interceptionType).isEmpty()) {
            interceptionHandlers.add(new DirectClassInterceptionHandler(this.getTargetInstance(), this.targetClassInterceptorMetadata));
        }
        InterceptionChain chain = new InterceptionChain(interceptionHandlers, interceptionType, this.getTargetInstance(), thisMethod, args);
        return chain.invokeNext(new InterceptorInvocationContext(chain, this.getTargetInstance(), thisMethod, args));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            this.executeInterception(null, null, InterceptionType.PRE_PASSIVATE);
            objectOutputStream.defaultWriteObject();
        }
        catch (Throwable throwable) {
            throw new IOException("Error while serializing class", throwable);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
            this.executeInterception(null, null, InterceptionType.POST_ACTIVATE);
        }
        catch (Throwable throwable) {
            throw new IOException("Error while deserializing class", throwable);
        }
    }
}

