/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.binding;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.services.binding.ServiceBinding;
import org.jboss.services.binding.ServiceBindingValueSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceBindingMetadata
implements Comparable<ServiceBindingMetadata> {
    private String serviceName;
    private String bindingName;
    private String hostName;
    private int port;
    private String serviceBindingValueSourceClassName;
    private ServiceBindingValueSource serviceBindingValueSource;
    private Object serviceBindingValueSourceConfig;
    private boolean fixedPort;
    private Boolean fixedHostName;
    private String description;

    public static String canonicalizeServiceName(String serviceName) {
        try {
            ObjectName oname = new ObjectName(serviceName);
            return oname.getCanonicalName();
        }
        catch (MalformedObjectNameException e) {
            return serviceName;
        }
    }

    public ServiceBindingMetadata() {
    }

    public ServiceBindingMetadata(String serviceName) {
        this(serviceName, null, null, 0, false, false);
    }

    public ServiceBindingMetadata(String serviceName, String bindingName) {
        this(serviceName, bindingName, null, 0, false, false);
    }

    public ServiceBindingMetadata(String serviceName, String bindingName, String hostName, int port) {
        this(serviceName, bindingName, hostName, port, false, hostName != null);
    }

    public ServiceBindingMetadata(String serviceName, String bindingName, String hostName, int port, boolean fixedPort, boolean fixedHostName) {
        this.setServiceName(serviceName);
        this.setBindingName(bindingName);
        this.setHostName(hostName);
        this.setPort(port);
        this.setFixedPort(fixedPort);
        this.setFixedHostName(fixedHostName);
    }

    public ServiceBindingMetadata(ServiceBinding binding) {
        this(binding.getServiceName(), binding.getBindingName(), binding.getHostName(), binding.getPort(), true, true);
        this.setServiceBindingValueSource(binding.getServiceBindingValueSource());
        if (this.serviceBindingValueSourceClassName == null) {
            this.setServiceBindingValueSourceClassName(binding.getServiceBindingValueSourceClassName());
        }
        this.setServiceBindingValueSourceConfig(binding.getServiceBindingValueSourceConfig());
    }

    public ServiceBindingMetadata(ServiceBindingMetadata binding) {
        this(binding.getServiceName(), binding.getBindingName(), binding.getHostName(), binding.getPort(), binding.isFixedHostName(), binding.isFixedPort());
        this.setServiceBindingValueSource(binding.getServiceBindingValueSource());
        if (this.serviceBindingValueSourceClassName == null) {
            this.setServiceBindingValueSourceClassName(binding.getServiceBindingValueSourceClassName());
        }
        this.setServiceBindingValueSourceConfig(binding.getServiceBindingValueSourceConfig());
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName is null");
        }
        this.serviceName = ServiceBindingMetadata.canonicalizeServiceName(serviceName);
    }

    public String getBindingName() {
        return this.bindingName;
    }

    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    public String getFullyQualifiedName() {
        if (this.serviceName == null) {
            throw new IllegalStateException("Must set serviceName");
        }
        if (this.bindingName == null) {
            return this.serviceName;
        }
        StringBuilder sb = new StringBuilder(this.serviceName);
        sb.append(':');
        sb.append(this.bindingName);
        return sb.toString();
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
        if (this.fixedHostName == null) {
            this.setFixedHostName(hostName == null);
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ServiceBindingValueSource getServiceBindingValueSource() {
        return this.serviceBindingValueSource;
    }

    public void setServiceBindingValueSource(ServiceBindingValueSource serviceBindingValueSource) {
        this.serviceBindingValueSource = serviceBindingValueSource;
        if (serviceBindingValueSource != null) {
            this.setServiceBindingValueSourceClassName(serviceBindingValueSource.getClass().getName());
        }
    }

    public String getServiceBindingValueSourceClassName() {
        return this.serviceBindingValueSourceClassName;
    }

    public void setServiceBindingValueSourceClassName(String serviceBindingValueSourceClassName) {
        this.serviceBindingValueSourceClassName = serviceBindingValueSourceClassName;
    }

    public Object getServiceBindingValueSourceConfig() {
        return this.serviceBindingValueSourceConfig;
    }

    public void setServiceBindingValueSourceConfig(Object serviceBindingValueSourceConfig) {
        this.serviceBindingValueSourceConfig = serviceBindingValueSourceConfig;
    }

    public boolean isFixedPort() {
        return this.fixedPort;
    }

    public void setFixedPort(boolean fixedPort) {
        this.fixedPort = fixedPort;
    }

    public boolean isFixedHostName() {
        return this.fixedHostName == null ? this.hostName != null : this.fixedHostName;
    }

    public void setFixedHostName(boolean fixedHostName) {
        this.fixedHostName = fixedHostName;
    }

    @Override
    public int compareTo(ServiceBindingMetadata other) {
        return this.getFullyQualifiedName().compareTo(other.getFullyQualifiedName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ServiceBindingMetadata) {
            ServiceBindingMetadata other = (ServiceBindingMetadata)obj;
            return this.serviceName != null && this.serviceName.equals(other.serviceName) && this.safeEquals(this.bindingName, other.bindingName);
        }
        return false;
    }

    public int hashCode() {
        int result = 19;
        result += 29 * this.serviceName.hashCode();
        return result += 29 * (this.bindingName == null ? 0 : this.bindingName.hashCode());
    }

    public String toString() {
        StringBuffer sBuf = new StringBuffer("ServiceBindingMetadata [serviceName=");
        sBuf.append(this.serviceName);
        sBuf.append(";bindingName=");
        sBuf.append(this.getBindingName());
        sBuf.append(";hostName=");
        String host = this.getHostName();
        if (this.hostName == null) {
            host = "<ANY>";
        }
        sBuf.append(host);
        sBuf.append(";port=");
        sBuf.append(this.getPort());
        sBuf.append("]");
        return sBuf.toString();
    }

    private boolean safeEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }
}

