/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.FailedIoFuture;
import org.jboss.xnio.FinishedIoFuture;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.Option;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Options;
import org.jboss.xnio.TcpServer;
import org.jboss.xnio.channels.BoundChannel;
import org.jboss.xnio.channels.TcpChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.management.TcpServerMBean;
import org.jboss.xnio.nio.NioHandle;
import org.jboss.xnio.nio.NioTcpChannel;
import org.jboss.xnio.nio.NioXnio;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NioTcpServer
implements TcpServer {
    private static final Logger log = Logger.getLogger((String)"org.jboss.xnio.nio.tcp.server");
    private static final Logger chanLog = Logger.getLogger((String)"org.jboss.xnio.nio.tcp.server.channel");
    private static final AtomicReferenceFieldUpdater<NioTcpServer, ChannelListener> openListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(NioTcpServer.class, ChannelListener.class, "openListener");
    private static final AtomicReferenceFieldUpdater<NioTcpServer, ChannelListener> bindListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(NioTcpServer.class, ChannelListener.class, "bindListener");
    private static final AtomicReferenceFieldUpdater<NioTcpServer, ChannelListener> closeListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(NioTcpServer.class, ChannelListener.class, "closeListener");
    private static final AtomicReferenceFieldUpdater<Binding, ChannelListener> boundCloseListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(Binding.class, ChannelListener.class, "closeListener");
    private volatile ChannelListener<? super BoundChannel<InetSocketAddress>> bindListener = null;
    private volatile ChannelListener<? super TcpChannel> openListener = null;
    private volatile ChannelListener<? super TcpServer> closeListener = null;
    private final ChannelListener.Setter<BoundChannel<InetSocketAddress>> bindSetter = IoUtils.getSetter((Object)this, bindListenerUpdater);
    private final ChannelListener.Setter<TcpChannel> openSetter = IoUtils.getSetter((Object)this, openListenerUpdater);
    private final ChannelListener.Setter<TcpServer> closeSetter = IoUtils.getSetter((Object)this, closeListenerUpdater);
    private final Executor executor;
    private final NioXnio xnio;
    private final Object lock = new Object();
    private final Set<Binding> boundChannels = new LinkedHashSet<Binding>();
    private final AtomicLong globalAcceptedConnections = new AtomicLong();
    private boolean closed;
    private Boolean reuseAddress;
    private Integer receiveBufferSize;
    private Integer backlog;
    private Boolean keepAlive;
    private Boolean oobInline;
    private Boolean tcpNoDelay;
    private boolean manageConnections;
    private static final Set<Option<?>> options = Option.setBuilder().add(Options.BACKLOG).add(Options.REUSE_ADDRESSES).add(Options.RECEIVE_BUFFER).add(Options.KEEP_ALIVE).add(Options.TCP_OOB_INLINE).add(Options.TCP_NODELAY).create();
    private final Closeable mbeanHandle;

    static NioTcpServer create(NioXnio nioXnio, Executor executor, ChannelListener<? super TcpChannel> channelListener, OptionMap optionMap) {
        return new NioTcpServer(nioXnio, executor, channelListener, optionMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NioTcpServer(NioXnio nioXnio, Executor executor, ChannelListener<? super TcpChannel> openListener, OptionMap optionMap) {
        Object object = this.lock;
        synchronized (object) {
            this.xnio = nioXnio;
            this.executor = executor;
            this.openListener = openListener == null ? IoUtils.closingChannelListener() : openListener;
            this.reuseAddress = (Boolean)optionMap.get(Options.REUSE_ADDRESSES);
            this.receiveBufferSize = (Integer)optionMap.get(Options.RECEIVE_BUFFER);
            this.backlog = (Integer)optionMap.get(Options.BACKLOG);
            this.keepAlive = (Boolean)optionMap.get(Options.KEEP_ALIVE);
            this.oobInline = (Boolean)optionMap.get(Options.TCP_OOB_INLINE);
            this.tcpNoDelay = (Boolean)optionMap.get(Options.TCP_NODELAY);
            this.manageConnections = !optionMap.contains(Options.MANAGE_CONNECTIONS) || (Boolean)optionMap.get(Options.MANAGE_CONNECTIONS) != false;
            Closeable closeable = IoUtils.nullCloseable();
            try {
                closeable = nioXnio.registerMBean(new MBean());
            }
            catch (NotCompliantMBeanException e) {
                log.trace((Throwable)e, "Failed to register MBean", new Object[0]);
            }
            this.mbeanHandle = closeable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<BoundChannel<InetSocketAddress>> getChannels() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<BoundChannel<InetSocketAddress>>(this.boundChannels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoFuture<BoundChannel<InetSocketAddress>> bind(InetSocketAddress address) {
        Object object = this.lock;
        synchronized (object) {
            try {
                Integer backlog;
                Integer receiveBufferSize;
                if (this.closed) {
                    throw new ClosedChannelException();
                }
                ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
                serverSocketChannel.configureBlocking(false);
                ServerSocket serverSocket = serverSocketChannel.socket();
                Boolean reuseAddress = this.reuseAddress;
                if (reuseAddress != null) {
                    serverSocket.setReuseAddress(reuseAddress);
                }
                if ((receiveBufferSize = this.receiveBufferSize) != null) {
                    serverSocket.setReceiveBufferSize(receiveBufferSize);
                }
                if ((backlog = this.backlog) != null) {
                    serverSocket.bind(address, backlog);
                } else {
                    serverSocket.bind(address);
                }
                Binding channel = new Binding(serverSocketChannel);
                this.boundChannels.add(channel);
                ChannelListener<? super BoundChannel<InetSocketAddress>> bindListener = this.bindListener;
                if (bindListener != null) {
                    this.executor.execute(IoUtils.getChannelListenerTask((Channel)((Object)channel), bindListener));
                }
                return new FinishedIoFuture((Object)channel);
            }
            catch (IOException e) {
                return new FailedIoFuture(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                log.trace("Closing %s", (Object)this);
                this.closed = true;
                IoUtils.invokeChannelListener((Executor)this.executor, (Channel)((Object)this), this.closeListener);
                ArrayList<Binding> list = new ArrayList<Binding>(this.boundChannels);
                for (Binding boundChannel : list) {
                    IoUtils.safeClose((Closeable)((Object)boundChannel));
                }
                IoUtils.safeClose((Closeable)this.mbeanHandle);
            }
        }
    }

    public boolean supportsOption(Option<?> option) {
        return options.contains(option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getOption(Option<T> option) throws UnsupportedOptionException, IOException {
        Object object = this.lock;
        synchronized (object) {
            if (option == Options.REUSE_ADDRESSES) {
                return (T)option.cast((Object)this.reuseAddress);
            }
            if (option == Options.RECEIVE_BUFFER) {
                return (T)option.cast((Object)this.receiveBufferSize);
            }
            if (option == Options.BACKLOG) {
                return (T)option.cast((Object)this.backlog);
            }
            if (option == Options.KEEP_ALIVE) {
                return (T)option.cast((Object)this.keepAlive);
            }
            if (option == Options.TCP_OOB_INLINE) {
                return (T)option.cast((Object)this.oobInline);
            }
            if (option == Options.TCP_NODELAY) {
                return (T)option.cast((Object)this.tcpNoDelay);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> NioTcpServer setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        Object object = this.lock;
        synchronized (object) {
            if (option == Options.REUSE_ADDRESSES) {
                this.reuseAddress = (Boolean)Options.REUSE_ADDRESSES.cast(value);
            } else if (option == Options.RECEIVE_BUFFER) {
                this.receiveBufferSize = (Integer)Options.RECEIVE_BUFFER.cast(value);
            } else if (option == Options.BACKLOG) {
                this.backlog = (Integer)Options.BACKLOG.cast(value);
            } else if (option == Options.KEEP_ALIVE) {
                this.keepAlive = (Boolean)Options.KEEP_ALIVE.cast(value);
            } else if (option == Options.TCP_OOB_INLINE) {
                this.oobInline = (Boolean)Options.TCP_OOB_INLINE.cast(value);
            } else if (option == Options.TCP_NODELAY) {
                this.tcpNoDelay = (Boolean)Options.TCP_NODELAY.cast(value);
            }
            return this;
        }
    }

    public String toString() {
        return String.format("TCP server (NIO) <%s>", Integer.toHexString(this.hashCode()));
    }

    public ChannelListener.Setter<? extends BoundChannel<InetSocketAddress>> getBindSetter() {
        return this.bindSetter;
    }

    public ChannelListener.Setter<TcpChannel> getOpenSetter() {
        return this.openSetter;
    }

    public ChannelListener.Setter<TcpServer> getCloseSetter() {
        return this.closeSetter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.lock;
        synchronized (object) {
            return !this.closed;
        }
    }

    static /* synthetic */ AtomicReferenceFieldUpdater access$700() {
        return boundCloseListenerUpdater;
    }

    public final class MBean
    extends StandardMBean
    implements TcpServerMBean {
        protected MBean() throws NotCompliantMBeanException {
            super(TcpServerMBean.class);
        }

        public String toString() {
            return "TCPServerMBean";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TcpServerMBean.Listener[] getBoundListeners() {
            Object object = NioTcpServer.this.lock;
            synchronized (object) {
                TcpServerMBean.Listener[] listeners = new TcpServerMBean.Listener[NioTcpServer.this.boundChannels.size()];
                int i = 0;
                for (Binding channel : NioTcpServer.this.boundChannels) {
                    final InetSocketAddress bindAddress = channel.address;
                    final long acceptedConnections = channel.acceptedConnections.get();
                    listeners[i++] = new TcpServerMBean.Listener(){

                        public InetSocketAddress getBindAddress() {
                            if (bindAddress == null) {
                                return new InetSocketAddress(0);
                            }
                            return bindAddress;
                        }

                        public long getAcceptedConnections() {
                            return acceptedConnections;
                        }
                    };
                }
                return listeners;
            }
        }

        public long getAcceptedConnections() {
            return NioTcpServer.this.globalAcceptedConnections.get();
        }

        public void bind(InetSocketAddress address) throws IOException {
            if (address == null) {
                throw new NullPointerException("address is null");
            }
            NioTcpServer.this.bind(address).get();
        }

        public void bind(String hostName, int port) throws IOException {
            this.bind(new InetSocketAddress(hostName, port));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unbind(InetSocketAddress address) throws IOException {
            if (address == null) {
                throw new NullPointerException("address is null");
            }
            Object object = NioTcpServer.this.lock;
            synchronized (object) {
                for (Binding channel : NioTcpServer.this.boundChannels) {
                    if (!channel.address.equals(address)) continue;
                    channel.close();
                    return;
                }
            }
            throw new IOException("No channel bound to address " + address);
        }

        public void unbind(String hostName, int port) throws IOException {
            this.unbind(new InetSocketAddress(hostName, port));
        }

        public void close() {
            IoUtils.safeClose((Closeable)((Object)NioTcpServer.this));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Binding
    implements BoundChannel<InetSocketAddress> {
        private final NioHandle handle;
        private final ServerSocket serverSocket;
        private final InetSocketAddress address;
        private final ServerSocketChannel channel;
        private final AtomicLong acceptedConnections = new AtomicLong();
        volatile ChannelListener<? super Binding> closeListener = null;
        private final ChannelListener.Setter<Binding> closeSetter = IoUtils.getSetter((Object)this, (AtomicReferenceFieldUpdater)NioTcpServer.access$700());
        private final AtomicBoolean open = new AtomicBoolean(true);

        public Binding(ServerSocketChannel channel) throws IOException {
            this.channel = channel;
            this.serverSocket = channel.socket();
            this.address = (InetSocketAddress)this.serverSocket.getLocalSocketAddress();
            this.handle = NioTcpServer.this.xnio.addConnectHandler(channel, new Handler(channel, NioTcpServer.this.executor, NioTcpServer.this.globalAcceptedConnections, this.acceptedConnections), false);
            this.handle.resume(16);
        }

        public InetSocketAddress getLocalAddress() {
            return this.address;
        }

        public boolean isOpen() {
            return this.open.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this.open.getAndSet(false)) {
                Object object = NioTcpServer.this.lock;
                synchronized (object) {
                    chanLog.trace("Closing %s", (Object)this);
                    try {
                        this.channel.close();
                    }
                    finally {
                        IoUtils.invokeChannelListener((Executor)NioTcpServer.this.executor, (Channel)((Object)this), this.closeListener);
                        NioTcpServer.this.xnio.removeManaged((Closeable)((Object)this));
                    }
                }
            }
        }

        public ChannelListener.Setter<Binding> getCloseSetter() {
            return this.closeSetter;
        }

        public <T> T getOption(Option<T> option) throws IOException {
            return null;
        }

        public boolean supportsOption(Option<?> option) {
            return false;
        }

        public <T> Binding setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
            return this;
        }

        public String toString() {
            return String.format("TCP server channel (NIO) <%s> (local: %s)", Integer.toHexString(this.hashCode()), this.getLocalAddress());
        }
    }

    private final class Handler
    implements Runnable {
        private final ServerSocketChannel socketChannel;
        private final Executor executor;
        private final AtomicLong globalAcceptedConnections;
        private final AtomicLong acceptedConnections;

        public Handler(ServerSocketChannel channel, Executor executor, AtomicLong acceptedConnections, AtomicLong connections) {
            this.socketChannel = channel;
            this.executor = executor;
            this.globalAcceptedConnections = acceptedConnections;
            this.acceptedConnections = connections;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block11: {
                AtomicLong acceptedConnections = this.acceptedConnections;
                AtomicLong globalAcceptedConnections = this.globalAcceptedConnections;
                try {
                    SocketChannel socketChannel = this.socketChannel.accept();
                    if (socketChannel == null) break block11;
                    boolean ok = false;
                    try {
                        Boolean tcpNoDelay;
                        Boolean oobInline;
                        socketChannel.configureBlocking(false);
                        Socket socket = socketChannel.socket();
                        Boolean keepAlive = NioTcpServer.this.keepAlive;
                        if (keepAlive != null) {
                            socket.setKeepAlive(keepAlive);
                        }
                        if ((oobInline = NioTcpServer.this.oobInline) != null) {
                            socket.setOOBInline(oobInline);
                        }
                        if ((tcpNoDelay = NioTcpServer.this.tcpNoDelay) != null) {
                            socket.setTcpNoDelay(tcpNoDelay);
                        }
                        NioTcpChannel channel = new NioTcpChannel(NioTcpServer.this.xnio, socketChannel, this.executor, NioTcpServer.this.manageConnections, (InetSocketAddress)socket.getLocalSocketAddress(), (InetSocketAddress)socket.getRemoteSocketAddress());
                        NioTcpServer.this.xnio.addManaged(channel);
                        ok = IoUtils.invokeChannelListener((Channel)((Object)channel), (ChannelListener)NioTcpServer.this.openListener);
                        if (ok) {
                            acceptedConnections.incrementAndGet();
                            globalAcceptedConnections.incrementAndGet();
                            log.trace("TCP server accepted connection");
                        }
                    }
                    finally {
                        if (!ok) {
                            log.trace("TCP server failed to accept connection");
                            IoUtils.safeClose((Closeable)socketChannel);
                        }
                    }
                }
                catch (ClosedChannelException e) {
                    log.trace("Channel closed: %s", (Object)e.getMessage());
                    return;
                }
                catch (IOException e) {
                    log.trace((Throwable)e, "I/O error on TCP server", new Object[0]);
                }
            }
        }
    }
}

