/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.persistence.deployer;

import java.io.IOException;
import java.util.List;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.MetaDataEntry;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.plugins.vfs.helpers.IncludeFileNameVirtualFileFilter;

public class PersistenceModificationChecker {
    private static final Logger log = Logger.getLogger(PersistenceModificationChecker.class);
    private static VirtualFileFilter filter = new IncludeFileNameVirtualFileFilter(".xml^");

    public static boolean hasBeenModified(VFSDeploymentUnit unit, long lastModified) throws Exception {
        VirtualFile root = unit.getRoot();
        if ((root.isArchive() || root.isLeaf()) && root.getLastModified() > lastModified) {
            return true;
        }
        StructureMetaData structureMetaData = (StructureMetaData)unit.getAttachment(StructureMetaData.class);
        if (structureMetaData == null) {
            return false;
        }
        ContextInfo info = structureMetaData.getContext(unit.getSimpleName());
        if (info == null && unit.isTopLevel()) {
            info = structureMetaData.getContext("");
        }
        if (info == null) {
            return false;
        }
        return PersistenceModificationChecker.hasBeenModifed(root, info, lastModified);
    }

    protected static boolean hasBeenModifed(VirtualFile root, ContextInfo contextInfo, long lastModified) throws IOException {
        List metadataPaths = contextInfo.getMetaDataPath();
        if (metadataPaths != null && !metadataPaths.isEmpty()) {
            for (MetaDataEntry metaDataPath : metadataPaths) {
                List children;
                VirtualFile mdpVF = root.getChild(metaDataPath.getPath());
                if (mdpVF == null || (children = mdpVF.getChildren(filter)) == null || children.isEmpty()) continue;
                for (VirtualFile child : children) {
                    if (child.getLastModified() <= lastModified) continue;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Metadata location modified: " + child));
                    }
                    return true;
                }
            }
        }
        return false;
    }
}

