/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.metadata.ProfileKeyMetaData;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;
import org.jboss.profileservice.spi.metadata.SubProfileMetaData;
import org.jboss.system.server.profile.repository.metadata.FilteredProfileMetaData;
import org.jboss.system.server.profile.repository.metadata.HotDeploymentProfileMetaData;
import org.jboss.system.server.profile.repository.metadata.ProfilesMetaData;
import org.jboss.system.server.profileservice.repository.AbstractBootstrapProfileFactory;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlProfileFactory
extends AbstractBootstrapProfileFactory {
    public static final String PROFILES_SUFFIX = ".profile";
    private File attachmentStoreRoot;
    private Collection<VirtualFile> profileDirectories;
    private Unmarshaller unmarshaller;
    private Collection<ProfileKey> processedProfileKeys = new ArrayList<ProfileKey>();
    private static final DefaultSchemaResolver resolver = new DefaultSchemaResolver();

    public XmlProfileFactory(URI[] profileDirectories) throws Exception {
        if (profileDirectories == null) {
            throw new IllegalArgumentException("Null directories");
        }
        this.profileDirectories = new ArrayList<VirtualFile>();
        for (URI uri : profileDirectories) {
            VirtualFile vf = VFS.getRoot((URI)uri);
            if (vf == null) {
                throw new IllegalArgumentException("Could not find uri: " + vf);
            }
            if (vf.isLeaf()) {
                throw new IllegalArgumentException("Not a directory: " + vf);
            }
            this.profileDirectories.add(vf);
        }
    }

    public Collection<VirtualFile> getProfileDirectories() {
        return this.profileDirectories;
    }

    public void setProfileDirectories(Collection<VirtualFile> profileDirectories) {
        this.profileDirectories = profileDirectories;
    }

    public File getAttachmentStoreRoot() {
        return this.attachmentStoreRoot;
    }

    public void setAttachmentStoreRoot(File attachmentStoreRoot) {
        this.attachmentStoreRoot = attachmentStoreRoot;
    }

    @Override
    protected void createProfileMetaData(ProfileKey rootKey, URL url) throws Exception {
        this.unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
        VirtualFile vf = this.getProfileFile(rootKey, url);
        ProfilesMetaData rootProfiles = this.parse(vf);
        this.processProfilesMetaData(rootProfiles);
    }

    protected void processProfileMetaData(ProfileMetaData metaData) throws Exception {
        ProfileKey key = XmlProfileFactory.createProfileKey((ProfileKeyMetaData)metaData);
        this.processProfileMetaData(key, metaData);
    }

    protected void processProfileMetaData(ProfileKey key, ProfileMetaData metaData) throws Exception {
        if (this.processedProfileKeys.contains(key)) {
            return;
        }
        this.addProfile(key, metaData);
        this.processSubProfiles(key, metaData);
    }

    protected void processSubProfiles(ProfileKey key, ProfileMetaData metaData) throws Exception {
        if (metaData.getSubprofiles() != null && !metaData.getSubprofiles().isEmpty()) {
            for (SubProfileMetaData subProfile : metaData.getSubprofiles()) {
                ProfileKey subProfileKey = XmlProfileFactory.createProfileKey((ProfileKeyMetaData)subProfile);
                this.processSubProfileMetaData(subProfileKey, subProfile);
            }
        }
    }

    protected void processSubProfileMetaData(ProfileKey key, SubProfileMetaData metaData) throws Exception {
        VirtualFile vf = this.getProfileFile(key, null);
        ProfilesMetaData profiles = this.parse(vf);
        this.processProfilesMetaData(profiles);
    }

    protected void processProfilesMetaData(ProfileKey key, ProfilesMetaData metaData) throws Exception {
        if (metaData.getProfiles() != null && !metaData.getProfiles().isEmpty()) {
            for (ProfileMetaData profile : metaData.getProfiles()) {
                this.processProfileMetaData(profile);
            }
        }
        this.addProfiles(key, metaData.getProfiles());
    }

    protected void processProfilesMetaData(ProfilesMetaData profilesMetaData) throws Exception {
        ProfileKey profilesKey = XmlProfileFactory.createProfileKey(profilesMetaData);
        this.processProfilesMetaData(profilesKey, profilesMetaData);
    }

    protected VirtualFile getProfileFile(ProfileKey key, URL url) throws Exception {
        if (url != null) {
            return VFS.getRoot((URL)url);
        }
        return this.resolveFile(key.getName());
    }

    protected VirtualFile resolveFile(String name) throws Exception {
        VirtualFile dir;
        if (!name.endsWith(PROFILES_SUFFIX)) {
            name = name + PROFILES_SUFFIX;
        }
        VirtualFile vf = null;
        Iterator<VirtualFile> i$ = this.profileDirectories.iterator();
        while (i$.hasNext() && (vf = (dir = i$.next()).getChild(name)) == null) {
        }
        if (vf == null) {
            throw new FileNotFoundException("Could not find profile configuration file for: " + name);
        }
        return vf;
    }

    protected ProfilesMetaData parse(VirtualFile vf) throws JBossXBException, IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("parsing file: " + vf.getPathName()));
        }
        return (ProfilesMetaData)this.unmarshaller.unmarshal(vf.openStream(), (SchemaBindingResolver)resolver);
    }

    @Override
    protected void addProfile(ProfileKey key, ProfileMetaData metaData) {
        this.processedProfileKeys.add(key);
        super.addProfile(key, metaData);
    }

    @Override
    protected void addProfiles(ProfileKey key, List<ProfileMetaData> metaData) {
        this.processedProfileKeys.add(key);
        super.addProfiles(key, metaData);
    }

    static {
        resolver.addClassBinding("urn:jboss:profileservice:profiles:1.0", ProfilesMetaData.class);
        resolver.addClassBinding("urn:jboss:profileservice:profile:filtered:1.0", FilteredProfileMetaData.class);
        resolver.addClassBinding("urn:jboss:profileservice:profile:hotdeployment:1.0", HotDeploymentProfileMetaData.class);
    }
}

