/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployers.builder;

import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.resource.deployers.builder.AbstractBuilder;
import org.jboss.resource.metadata.ConnectorMetaData;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
import org.jboss.resource.metadata.repository.DefaultJCAMetaDataRepository;
import org.jboss.system.metadata.ServiceAttributeMetaData;
import org.jboss.system.metadata.ServiceConstructorMetaData;
import org.jboss.system.metadata.ServiceDependencyMetaData;

public class ManagedConnectionFactoryBuilder
extends AbstractBuilder {
    private static final String MCF = "org.jboss.resource.connectionmanager.ManagedConnectionFactoryDeployment";
    private static final String RAR_JMX = "jboss.jca:service=RARDeployment,name='";
    private static final String MCF_JMX = "jboss.jca:service=ManagedConnectionFactory,name=";
    private DefaultJCAMetaDataRepository repository;

    public DefaultJCAMetaDataRepository getMetaDataRepository() {
        return this.repository;
    }

    public void setMetaDataRepository(DefaultJCAMetaDataRepository repository) {
        this.repository = repository;
    }

    @Override
    public ObjectName buildObjectName(ManagedConnectionFactoryDeploymentMetaData md) {
        return ObjectNameFactory.create((String)(MCF_JMX + md.getJndiName()));
    }

    @Override
    public List<ServiceAttributeMetaData> buildAttributes(ManagedConnectionFactoryDeploymentMetaData deployment) {
        ArrayList<ServiceAttributeMetaData> attributes = new ArrayList<ServiceAttributeMetaData>();
        ServiceAttributeMetaData attribute = this.buildDependencyAttribute("OldRarDeployment", RAR_JMX + deployment.getRarName() + "'");
        attributes.add(attribute);
        return attributes;
    }

    @Override
    public ServiceConstructorMetaData buildConstructor(ManagedConnectionFactoryDeploymentMetaData mcfmd) {
        ServiceConstructorMetaData constructor = new ServiceConstructorMetaData();
        ConnectorMetaData md = this.repository.getConnectorMetaData(mcfmd.getRarName());
        if (md == null) {
            throw new IllegalStateException("No ConnectorMetaData found for mdf rarName: " + mcfmd.getRarName());
        }
        constructor.setParameters(new Object[]{md, mcfmd});
        constructor.setSignature(new String[]{md.getClass().getName(), ManagedConnectionFactoryDeploymentMetaData.class.getName()});
        return constructor;
    }

    @Override
    public List<ServiceDependencyMetaData> buildDependencies(ManagedConnectionFactoryDeploymentMetaData md) {
        List dependsNames = md.getDependsNames();
        ArrayList<ServiceDependencyMetaData> dependencies = new ArrayList<ServiceDependencyMetaData>();
        for (String string : dependsNames) {
            ServiceDependencyMetaData depends = this.buildDependency(string);
            dependencies.add(depends);
        }
        return dependencies;
    }

    @Override
    public String getCode(ManagedConnectionFactoryDeploymentMetaData md) {
        return MCF;
    }
}

