/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management;

import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.management.ContextStateMapper;
import org.jboss.deployers.spi.management.DeploymentTemplate;
import org.jboss.deployers.spi.management.KnownComponentTypes;
import org.jboss.deployers.spi.management.KnownDeploymentTypes;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.NameMatcher;
import org.jboss.deployers.spi.management.RuntimeComponentDispatcher;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.DeploymentState;
import org.jboss.managed.api.DeploymentTemplateInfo;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.MutableManagedComponent;
import org.jboss.managed.api.MutableManagedObject;
import org.jboss.managed.api.RunState;
import org.jboss.managed.api.annotation.ActivationPolicy;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.api.annotation.ManagementObjectRef;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.plugins.ManagedComponentImpl;
import org.jboss.managed.plugins.ManagedDeploymentImpl;
import org.jboss.managed.plugins.factory.AbstractManagedObjectFactory;
import org.jboss.managed.plugins.jmx.ManagementFactoryUtils;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metatype.api.types.ArrayMetaType;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.ArrayValue;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.GenericValue;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.profileservice.management.AbstractRuntimeComponentDispatcher;
import org.jboss.profileservice.management.AbstractTemplateCreator;
import org.jboss.profileservice.management.MBeanManagedObjectFactory;
import org.jboss.profileservice.management.MBeanRuntimeComponentDispatcher;
import org.jboss.profileservice.management.ManagedOperationProxyFactory;
import org.jboss.profileservice.spi.ManagedMBeanDeploymentFactory;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.system.server.profileservice.attachments.AttachmentStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagementObject(name="ManagementView", componentType=@ManagementComponent(type="MCBean", subtype="*"), properties=ManagementProperties.EXPLICIT, description="The ProfileService ManagementView")
public class ManagementViewImpl
extends AbstractTemplateCreator
implements ManagementView {
    private static RuntimePermission MV_RUNTIME_PERMISSION = new RuntimePermission(ManagementView.class.getName());
    private static Logger log = Logger.getLogger(ManagementViewImpl.class);
    private static final String BUNDLE_NAME = "org.jboss.profileservice.management.messages";
    private ProfileService ps;
    private Map<ProfileKey, Long> lastModified = new HashMap<ProfileKey, Long>();
    private boolean forceReload;
    private MainDeployer mainDeployer;
    private AttachmentStore store;
    private HashMap<String, DeploymentTemplate> templates = new HashMap();
    private ResourceBundle i18n;
    private Locale currentLocale;
    private MessageFormat formatter = new MessageFormat("");
    private HashMap<ComponentType, Set<ManagedComponent>> compByCompType = new HashMap();
    private Map<String, ManagedObject> moRegistry = new HashMap<String, ManagedObject>();
    private Map<String, Set<ManagedProperty>> unresolvedRefs = new HashMap<String, Set<ManagedProperty>>();
    private Map<String, ManagedObject> runtimeMOs = new HashMap<String, ManagedObject>();
    private Map<String, ManagedDeployment> bootstrapManagedDeployments = Collections.emptyMap();
    private Map<String, ManagedDeployment> managedDeployments = new HashMap<String, ManagedDeployment>();
    private List<String> rootDeployments = new ArrayList<String>();
    private static final ContextStateMapper<RunState> runStateMapper;
    private static final ContextStateMapper<DeploymentState> deploymentStateMapper;
    private RuntimeComponentDispatcher dispatcher;
    private ManagedOperationProxyFactory proxyFactory;
    private ManagedOperationProxyFactory mbeanProxyFactory;
    private MetaValueFactory metaValueFactory = MetaValueFactory.getInstance();
    ManagedObjectFactory managedObjFactory = ManagedObjectFactory.getInstance();
    private HashMap<String, ManagedMBeanDeploymentFactory> mdfs = new HashMap();
    private MBeanServer mbeanServer;
    private MBeanManagedObjectFactory mbeanMOFactory = new MBeanManagedObjectFactory();

    public ManagementViewImpl() throws IOException {
        this.currentLocale = Locale.getDefault();
        this.formatter.setLocale(this.currentLocale);
        this.i18n = ResourceBundle.getBundle(BUNDLE_NAME, this.currentLocale);
    }

    public void start() throws Exception {
    }

    public void stop() {
        this.release();
    }

    public synchronized boolean load() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(MV_RUNTIME_PERMISSION);
        }
        if (!this.isReload()) {
            log.debug((Object)"Not reloading profiles.");
            return false;
        }
        this.forceReload = false;
        boolean wasInterrupted = Thread.interrupted();
        if (wasInterrupted) {
            log.debug((Object)"Cleared interrupted state of calling thread");
        }
        this.release();
        boolean trace = log.isTraceEnabled();
        this.loadProfiles(trace);
        for (ManagedMBeanDeploymentFactory mdf : this.mdfs.values()) {
            log.debug((Object)("Processing deployments for factory: " + mdf.getFactoryName()));
            Collection<ManagedMBeanDeploymentFactory.MBeanDeployment> deployments = mdf.getDeployments(this.mbeanServer);
            for (ManagedMBeanDeploymentFactory.MBeanDeployment md : deployments) {
                log.debug((Object)("Saw MBeanDeployment: " + md));
                HashMap<String, ManagedObject> unitMOs = new HashMap<String, ManagedObject>();
                Collection<ManagedMBeanDeploymentFactory.MBeanComponent> components = md.getComponents();
                if (components != null) {
                    for (ManagedMBeanDeploymentFactory.MBeanComponent comp : components) {
                        log.debug((Object)("Saw MBeanComponent: " + comp));
                        try {
                            ManagedObject mo = this.createManagedObject(comp.getName(), mdf.getDefaultViewUse(), mdf.getPropertyMetaMappings());
                            String name = comp.getName().getCanonicalName();
                            ManagementObject moAnn = this.createMOAnnotation(name, comp.getType(), comp.getSubtype());
                            mo.getAnnotations().put(ManagementObject.class.getName(), moAnn);
                            ManagementComponent mcAnn = moAnn.componentType();
                            mo.getAnnotations().put(ManagementComponent.class.getName(), mcAnn);
                            unitMOs.put(name, mo);
                        }
                        catch (Exception e) {
                            log.warn((Object)("Failed to create ManagedObject for: " + comp), (Throwable)e);
                        }
                    }
                }
                ManagedDeploymentImpl mdi = new ManagedDeploymentImpl(md.getName(), md.getName(), null, unitMOs);
                mdi.setTypes(Collections.singleton("external-mbean"));
                try {
                    this.processManagedDeployment((ManagedDeployment)mdi, null, DeploymentState.STARTED, 0, trace);
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to process ManagedDeployment for: " + md.getName()), (Throwable)e);
                }
            }
        }
        for (ManagedDeployment md : this.bootstrapManagedDeployments.values()) {
            try {
                this.processManagedDeployment(md, null, DeploymentState.STARTED, 0, trace);
            }
            catch (Exception e) {
                log.warn((Object)("Failed to process ManagedDeployment for: " + md.getName()), (Throwable)e);
            }
        }
        if (this.runtimeMOs.size() > 0) {
            log.warn((Object)("Failed to merged the following runtime ManagedObjects: " + this.runtimeMOs));
        }
        Map platformMBeanMOs = ManagementFactoryUtils.getPlatformMBeanMOs((ManagedObjectFactory)this.managedObjFactory);
        ManagedDeploymentImpl platformMBeans = new ManagedDeploymentImpl("JDK PlatformMBeans", "PlatformMBeans", null, platformMBeanMOs);
        List gcMbeans = ManagementFactoryUtils.getGarbageCollectorMXBeans((ManagedObjectFactory)this.managedObjFactory);
        HashMap<String, ManagedObject> gcMOs = new HashMap<String, ManagedObject>();
        for (ManagedObject mo : gcMbeans) {
            gcMOs.put(mo.getName(), mo);
        }
        List mmMbeans = ManagementFactoryUtils.getMemoryManagerMXBeans((ManagedObjectFactory)this.managedObjFactory);
        HashMap<String, ManagedObject> mmMOs = new HashMap<String, ManagedObject>();
        for (ManagedObject mo : mmMbeans) {
            mmMOs.put(mo.getName(), mo);
        }
        List mpoolMBeans = ManagementFactoryUtils.getMemoryPoolMXBeans((ManagedObjectFactory)this.managedObjFactory);
        HashMap<String, ManagedObject> mpoolMOs = new HashMap<String, ManagedObject>();
        for (ManagedObject mo : mpoolMBeans) {
            mpoolMOs.put(mo.getName(), mo);
        }
        ManagedDeploymentImpl gcMD = new ManagedDeploymentImpl("GarbageCollectorMXBeans", "GarbageCollectorMXBeans", null, gcMOs);
        platformMBeans.getChildren().add(gcMD);
        ManagedDeploymentImpl mmMD = new ManagedDeploymentImpl("MemoryManagerMXBeans", "MemoryManagerMXBeans", null, mmMOs);
        platformMBeans.getChildren().add(mmMD);
        ManagedDeploymentImpl mpoolMD = new ManagedDeploymentImpl("MemoryPoolMXBeans", "MemoryPoolMXBeans", null, mpoolMOs);
        platformMBeans.getChildren().add(mpoolMD);
        try {
            this.processManagedDeployment((ManagedDeployment)platformMBeans, null, DeploymentState.STARTED, 0, trace);
        }
        catch (Exception e) {
            log.warn((Object)"Failed to process ManagedDeployments for the platform beans", (Throwable)e);
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
            log.debug((Object)"Restored interrupted state of calling thread");
        }
        return true;
    }

    private ManagementObject createMOAnnotation(String name, String type, String subtype) {
        return new ManagementObjectAnnotationImpl(name, type, subtype);
    }

    public void reload() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(MV_RUNTIME_PERMISSION);
        }
        this.forceReload = true;
        this.load();
    }

    public void release() {
        this.compByCompType.clear();
        this.managedDeployments.clear();
        this.moRegistry.clear();
        this.runtimeMOs.clear();
        this.unresolvedRefs.clear();
        this.lastModified.clear();
        this.rootDeployments.clear();
        this.proxyFactory.clear();
    }

    protected void loadProfiles(boolean trace) {
        log.debug((Object)("reloading profiles: " + this.ps.getActiveProfileKeys()));
        for (ProfileKey key : this.ps.getActiveProfileKeys()) {
            try {
                Profile profile = this.ps.getActiveProfile(key);
                Collection deployments = profile.getDeployments();
                this.lastModified.put(key, profile.getLastModified());
                for (ProfileDeployment deployment : deployments) {
                    try {
                        try {
                            ManagedDeployment md = this.getManagedDeployment(deployment);
                            this.processRootManagedDeployment(md, key, trace);
                            if (md.getTypes() == null || md.getTypes().isEmpty()) continue;
                            deployment.addTransientAttachment(KnownDeploymentTypes.class.getName(), (Object)md.getTypes());
                        }
                        catch (DeploymentException e) {
                            String deploymentName = deployment.getName();
                            ManagedDeploymentImpl md = new ManagedDeploymentImpl(deploymentName, deployment.getRoot().getName());
                            Collection deploymentTypes = (Collection)deployment.getTransientAttachment(KnownDeploymentTypes.class.getName());
                            if (deploymentTypes != null) {
                                md.setTypes(new HashSet(deploymentTypes));
                            } else {
                                int i = deploymentName.lastIndexOf(".");
                                if (i != -1 && i + 1 < deploymentName.length()) {
                                    String guessedType = deploymentName.substring(i + 1, deploymentName.length());
                                    if (guessedType.endsWith("/")) {
                                        guessedType = guessedType.substring(0, guessedType.length() - 1);
                                    }
                                    md.setTypes(new HashSet(1));
                                    md.addType(guessedType);
                                }
                            }
                            this.processManagedDeployment((ManagedDeployment)md, key, DeploymentState.STOPPED, 0, trace);
                        }
                    }
                    catch (Exception e) {
                        log.warn((Object)("Failed to create ManagedDeployment for: " + deployment.getName()), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                log.debug((Object)("failed to load profile " + key), (Throwable)e);
            }
        }
    }

    protected boolean isReload() {
        if (this.forceReload) {
            this.forceReload = false;
            return true;
        }
        for (ProfileKey key : this.ps.getActiveProfileKeys()) {
            if (!this.lastModified.containsKey(key)) {
                return true;
            }
            try {
                Profile profile = this.ps.getActiveProfile(key);
                long lastModified = this.lastModified.get(key);
                if (profile.getLastModified() <= lastModified) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    protected void processRootManagedDeployment(ManagedDeployment md, ProfileKey profile, boolean trace) throws Exception {
        DeploymentState state = this.getDeploymentState(md);
        this.processManagedDeployment(md, profile, state, 0, trace);
    }

    protected void processManagedDeployment(ManagedDeployment md, ProfileKey profile, DeploymentState state, int level, boolean trace) throws Exception {
        List mdChildren;
        String name = md.getName();
        if (trace) {
            log.trace((Object)(name + " ManagedDeployment_" + level + ": " + md));
        }
        Map mos = md.getManagedObjects();
        if (trace) {
            log.trace((Object)(name + " ManagedObjects_ " + level + ": " + mos));
        }
        if (state != null && md instanceof ManagedDeploymentImpl) {
            ((ManagedDeploymentImpl)md).setDeploymentState(state);
        }
        for (ManagedObject mo : mos.values()) {
            this.processManagedObject(mo, md);
        }
        this.managedDeployments.put(name, md);
        if (profile != null) {
            md.setAttachment(ProfileKey.class.getName(), (Object)profile);
        }
        if (level == 0) {
            this.rootDeployments.add(name);
        }
        if ((mdChildren = md.getChildren()) != null && !mdChildren.isEmpty()) {
            for (ManagedDeployment mdChild : mdChildren) {
                this.processManagedDeployment(mdChild, profile, state, level + 1, trace);
            }
        }
    }

    protected void processManagedObject(ManagedObject mo, ManagedDeployment md) throws Exception {
        Set<ManagedComponent> typeComps;
        String key = mo.getName() + "/" + mo.getNameType();
        log.debug((Object)("ID for ManagedObject: " + key + ", attachmentName: " + mo.getAttachmentName()));
        Map moAnns = mo.getAnnotations();
        ManagementObject managementObject = (ManagementObject)moAnns.get(ManagementObject.class.getName());
        if (managementObject != null && managementObject.isRuntime()) {
            boolean merged = false;
            ManagementComponent mc = managementObject.componentType();
            boolean isMC = mc.type().length() != 0 || mc.subtype().length() != 0;
            ManagedObject parentMO = this.moRegistry.get(key);
            if (parentMO == null && !isMC) {
                log.debug((Object)("Deferring resolution of runtime ManagedObject: " + managementObject));
                this.runtimeMOs.put(key, mo);
            } else {
                this.mergeRuntimeMO(parentMO, mo);
                merged = true;
                this.runtimeMOs.remove(key);
            }
            ManagedComponent comp = md.getComponent(mo.getName());
            if (comp != null) {
                RunState state = this.updateRunState(mo, comp);
                log.debug((Object)("Updated component: " + comp + " run state to: " + state));
            }
            if (!isMC) {
                return;
            }
            if (!merged) {
                Set<ManagedOperation> runtimeOps = mo.getOperations();
                runtimeOps = this.createOperationProxies(mo, runtimeOps);
                MutableManagedObject moi = (MutableManagedObject)mo;
                moi.setOperations(runtimeOps);
            }
        } else {
            ManagedObject runtimeMO = this.runtimeMOs.get(key);
            if (runtimeMO != null) {
                this.mergeRuntimeMO(mo, runtimeMO);
                this.runtimeMOs.remove(key);
                ManagedComponent comp = md.getComponent(mo.getName());
                if (comp != null) {
                    RunState state = this.updateRunState(runtimeMO, comp);
                    log.debug((Object)("Updated component: " + comp + " run state to: " + state));
                }
            }
        }
        this.checkForReferences(key, mo);
        for (ManagedComponent comp : md.getComponents().values()) {
            log.debug((Object)("Updating ManagementComponent: " + comp));
            ComponentType type = comp.getType();
            typeComps = this.compByCompType.get(type);
            if (typeComps == null) {
                typeComps = new HashSet<ManagedComponent>();
                this.compByCompType.put(type, typeComps);
            }
            typeComps.add(comp);
        }
        ManagementComponent mc = (ManagementComponent)moAnns.get(ManagementComponent.class.getName());
        if (mc != null && md.getComponent(mo.getName()) == null) {
            ComponentType type = new ComponentType(mc.type(), mc.subtype());
            ManagedComponentImpl comp = new ManagedComponentImpl(type, md, mo);
            if (mo.getTransientAttachment(MBeanRuntimeComponentDispatcher.class.getName()) == null) {
                comp = this.proxyFactory.createComponentProxy((MutableManagedComponent)comp);
            }
            md.addComponent(mo.getName(), (ManagedComponent)comp);
            log.debug((Object)("Processing ManagementComponent(" + mo.getName() + "): " + comp));
            typeComps = this.compByCompType.get(type);
            if (typeComps == null) {
                typeComps = new HashSet<ManagedComponent>();
                this.compByCompType.put(type, typeComps);
            }
            typeComps.add((ManagedComponent)comp);
            RunState state = this.updateRunState(mo, (ManagedComponent)comp);
        }
        for (ManagedProperty prop : mo.getProperties().values()) {
            ArrayValue avalue;
            MetaType etype;
            ArrayMetaType amt;
            MetaType propType;
            log.debug((Object)("Checking property: " + prop));
            Map pannotations = prop.getAnnotations();
            if (pannotations != null && !pannotations.isEmpty()) {
                ManagementObjectRef ref;
                ManagementObjectID id = (ManagementObjectID)pannotations.get(ManagementObjectID.class.getName());
                if (id != null) {
                    Object refName = this.getRefName(prop.getValue());
                    if (refName == null) {
                        refName = id.name();
                    }
                    String propKey = refName + "/" + id.type();
                    log.debug((Object)("ManagedProperty level ID for ManagedObject: " + propKey + ", attachmentName: " + mo.getAttachmentName()));
                    this.moRegistry.put(propKey, mo);
                    this.checkForReferences(propKey, mo);
                }
                if ((ref = (ManagementObjectRef)pannotations.get(ManagementObjectRef.class.getName())) != null) {
                    String targetKey;
                    ManagedObject target;
                    log.debug((Object)("Property(" + prop.getName() + ") references: " + ref));
                    Object refName = this.getRefName(prop.getValue());
                    if (refName == null) {
                        refName = ref.name();
                    }
                    if ((target = this.moRegistry.get(targetKey = refName + "/" + ref.type())) != null) {
                        log.debug((Object)("Resolved property(" + prop.getName() + ") reference to: " + targetKey));
                        prop.setTargetManagedObject(target);
                    } else {
                        Set<ManagedProperty> referers = this.unresolvedRefs.get(targetKey);
                        if (referers == null) {
                            referers = new HashSet<ManagedProperty>();
                            this.unresolvedRefs.put(targetKey, referers);
                        }
                        referers.add(prop);
                    }
                }
            }
            if ((propType = prop.getMetaType()) == AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE) {
                this.processGenericValue((GenericValue)prop.getValue(), md);
                continue;
            }
            if (propType.isArray()) {
                amt = (ArrayMetaType)propType;
                etype = amt.getElementType();
                if (etype != AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE) continue;
                avalue = (ArrayValue)prop.getValue();
                int length = avalue != null ? avalue.getLength() : 0;
                for (int n = 0; n < length; ++n) {
                    this.processGenericValue((GenericValue)avalue.getValue(n), md);
                }
                continue;
            }
            if (!propType.isCollection() || (etype = (amt = (CollectionMetaType)propType).getElementType()) != AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE || (avalue = (CollectionValue)prop.getValue()) == null) continue;
            MetaValue[] elements = avalue.getElements();
            for (int n = 0; n < avalue.getSize(); ++n) {
                GenericValue gv = (GenericValue)elements[n];
                ManagedObject propMO = (ManagedObject)gv.getValue();
                if (propMO == null) continue;
                this.processManagedObject(propMO, md);
            }
        }
    }

    protected Object getRefName(Object value) {
        if (value instanceof MetaValue) {
            MetaValue metaValue = (MetaValue)value;
            if (!metaValue.getMetaType().isSimple()) {
                throw new IllegalArgumentException("Can only get ref from simple value: " + value);
            }
            SimpleValue svalue = (SimpleValue)metaValue;
            return svalue.getValue();
        }
        return value;
    }

    protected RunState updateRunState(ManagedObject runtimeMO, ManagedComponent comp) {
        RunState state = comp.getRunState();
        if (state == RunState.UNKNOWN && this.dispatcher != null) {
            Object name = comp.getComponentName();
            if (name == null && runtimeMO != null) {
                name = runtimeMO.getComponentName();
            }
            if (name != null) {
                state = this.getComponentMappedState(comp, runtimeMO, name, runStateMapper);
                if (comp instanceof MutableManagedComponent) {
                    MutableManagedComponent mcomp = (MutableManagedComponent)MutableManagedComponent.class.cast(comp);
                    mcomp.setRunState(state);
                }
            }
        }
        return state;
    }

    protected DeploymentState getDeploymentState(ManagedDeployment md) {
        String name;
        DeploymentState state = md.getDeploymentState();
        if (state == DeploymentState.UNKNOWN && this.dispatcher != null && (name = md.getName()) != null) {
            state = this.getMappedState(name, deploymentStateMapper);
        }
        return state;
    }

    protected <T extends Enum<?>> T getMappedState(Object name, ContextStateMapper<T> mapper) {
        Enum state = mapper.getErrorState();
        try {
            if (this.dispatcher != null) {
                state = this.dispatcher.mapControllerState(name, mapper);
            }
        }
        catch (Exception e) {
            log.debug((Object)"Failed to get controller state", (Throwable)e);
        }
        return (T)state;
    }

    protected <T extends Enum<?>> T getComponentMappedState(ManagedComponent comp, ManagedObject mo, Object name, ContextStateMapper<T> mapper) {
        Enum state = mapper.getErrorState();
        try {
            RuntimeComponentDispatcher dispatcher = mo != null && mo.getTransientAttachment(MBeanRuntimeComponentDispatcher.class.getName()) != null ? this.mbeanProxyFactory.getDispatcher() : this.dispatcher;
            if (dispatcher != null) {
                state = dispatcher.mapControllerState(name, mapper);
            }
        }
        catch (Exception e) {
            log.debug((Object)"Failed to get controller state", (Throwable)e);
        }
        return (T)state;
    }

    protected void processGenericValue(GenericValue genericValue, ManagedDeployment md) throws Exception {
        ManagedObject propMO;
        if (genericValue != null && (propMO = (ManagedObject)genericValue.getValue()) != null) {
            this.processManagedObject(propMO, md);
        }
    }

    public Map<String, ManagedDeployment> getBootstrapManagedDeployments() {
        return this.bootstrapManagedDeployments;
    }

    public void setBootstrapManagedDeployments(Map<String, ManagedDeployment> bootstrapManagedDeployments) {
        this.bootstrapManagedDeployments = bootstrapManagedDeployments;
    }

    public Map<String, Set<ManagedProperty>> getUnresolvedRefs() {
        return this.unresolvedRefs;
    }

    public ProfileService getProfileService() {
        return this.ps;
    }

    public void setProfileService(ProfileService ps) {
        this.ps = ps;
        if (log.isTraceEnabled()) {
            log.trace((Object)("setProfileService: " + ps));
        }
    }

    public ManagedOperationProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public void setProxyFactory(ManagedOperationProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public AttachmentStore getAttachmentStore() {
        return this.store;
    }

    public void setAttachmentStore(AttachmentStore store) {
        this.store = store;
    }

    public MainDeployer getMainDeployer() {
        return this.mainDeployer;
    }

    public void setMainDeployer(MainDeployer mainDeployer) {
        this.mainDeployer = mainDeployer;
        if (log.isTraceEnabled()) {
            log.trace((Object)("setMainDeployer: " + mainDeployer));
        }
    }

    public MetaValueFactory getMetaValueFactory() {
        return this.metaValueFactory;
    }

    public void setMetaValueFactory(MetaValueFactory metaValueFactory) {
        this.metaValueFactory = metaValueFactory;
    }

    public ManagedObjectFactory getManagedObjFactory() {
        return this.managedObjFactory;
    }

    public void setManagedObjFactory(ManagedObjectFactory managedObjFactory) {
        this.managedObjFactory = managedObjFactory;
    }

    public void setDispatcher(RuntimeComponentDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public MBeanManagedObjectFactory getMbeanMOFactory() {
        return this.mbeanMOFactory;
    }

    public void setMbeanMOFactory(MBeanManagedObjectFactory mbeanMOFactory) {
        this.mbeanMOFactory = mbeanMOFactory;
    }

    public Set<String> getDeploymentNames() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(MV_RUNTIME_PERMISSION);
        }
        return new TreeSet<String>(this.managedDeployments.keySet());
    }

    public Set<String> getDeploymentNamesForType(String type) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(MV_RUNTIME_PERMISSION);
        }
        TreeSet<String> matches = new TreeSet<String>();
        for (ManagedDeployment md : this.managedDeployments.values()) {
            String name = md.getName();
            Set types = md.getTypes();
            if (types == null || !types.contains(type)) continue;
            if (log.isTraceEnabled()) {
                log.trace((Object)(name + " matches type: " + type + ", types:" + types));
            }
            matches.add(name);
        }
        return matches;
    }

    public Set<String> getMatchingDeploymentName(String regex) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(MV_RUNTIME_PERMISSION);
        }
        if (regex == null) {
            throw new IllegalArgumentException("null regex");
        }
        Set<String> names = this.getDeploymentNames();
        HashSet<String> matches = new HashSet<String>();
        Pattern p = Pattern.compile(regex);
        for (String name : names) {
            Matcher m = p.matcher(name);
            if (!m.matches()) continue;
            matches.add(name);
        }
        return matches;
    }

    public Set<ManagedDeployment> getMatchingDeployments(String name, NameMatcher<ManagedDeployment> matcher) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(MV_RUNTIME_PERMISSION);
        }
        if (name == null) {
            throw new IllegalArgumentException("null deployment name");
        }
        if (matcher == null) {
            throw new IllegalArgumentException("null deployment matcher");
        }
        HashSet<ManagedDeployment> matches = new HashSet<ManagedDeployment>();
        for (ManagedDeployment deployment : this.managedDeployments.values()) {
            if (!matcher.matches((Object)deployment, name)) continue;
            matches.add(deployment);
        }
        return matches;
    }

    public Set<String> getTemplateNames() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(MV_RUNTIME_PERMISSION);
        }
        return new HashSet<String>(this.templates.keySet());
    }

    public void addManagedMBeanDeployments(ManagedMBeanDeploymentFactory factory) {
        log.debug((Object)("addManagedDeployment, " + factory));
        String name = factory.getFactoryName();
        this.mdfs.put(name, factory);
    }

    public void removeManagedMBeanDeployments(ManagedMBeanDeploymentFactory factory) {
        log.debug((Object)("removeManagedDeployment, " + factory));
        String name = factory.getFactoryName();
        this.mdfs.remove(name);
    }

    public void addTemplate(DeploymentTemplate template) {
        this.templates.put(template.getInfo().getName(), template);
        log.debug((Object)("addTemplate: " + template));
    }

    public void removeTemplate(DeploymentTemplate template) {
        this.templates.remove(template.getInfo().getName());
        log.debug((Object)("removeTemplate: " + template));
    }

    public ManagedDeployment getDeployment(String name) throws NoSuchDeploymentException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(MV_RUNTIME_PERMISSION);
        }
        if (name == null) {
            throw new IllegalArgumentException("Null deployment name");
        }
        ManagedDeployment md = this.managedDeployments.get(name);
        if (md == null) {
            md = this.bootstrapManagedDeployments.get(name);
        }
        if (md == null) {
            Iterator<String> i$ = this.rootDeployments.iterator();
            while (i$.hasNext()) {
                String deployment;
                String fixedDeploymentName = deployment = i$.next();
                if (deployment.endsWith("/")) {
                    fixedDeploymentName = deployment.substring(0, deployment.length() - 1);
                }
                if (!fixedDeploymentName.endsWith(name)) continue;
                md = this.managedDeployments.get(deployment);
                break;
            }
        }
        if (md == null) {
            throw new NoSuchDeploymentException("Managed deployment: " + name + " not found.");
        }
        return md;
    }

    public Set<ManagedDeployment> getDeploymentsForType(String type) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(MV_RUNTIME_PERMISSION);
        }
        Set<String> names = this.getDeploymentNamesForType(type);
        HashSet<ManagedDeployment> mds = new HashSet<ManagedDeployment>();
        for (String name : names) {
            ManagedDeployment md = this.getDeployment(name);
            mds.add(md);
        }
        return mds;
    }

    public Set<ComponentType> getComponentTypes() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(MV_RUNTIME_PERMISSION);
        }
        HashSet<ComponentType> types = new HashSet<ComponentType>(this.compByCompType.keySet());
        return types;
    }

    public Set<ManagedComponent> getComponentsForType(ComponentType type) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(MV_RUNTIME_PERMISSION);
        }
        Set<Object> comps = null;
        if (type.equals((Object)KnownComponentTypes.ANY_TYPE)) {
            HashSet<ManagedComponent> all = new HashSet<ManagedComponent>();
            for (Set<ManagedComponent> typeComps : this.compByCompType.values()) {
                for (ManagedComponent comp : typeComps) {
                    all.add(comp);
                }
            }
            comps = all;
        } else {
            comps = this.compByCompType.get(type);
        }
        if (comps == null) {
            comps = Collections.emptySet();
        }
        return comps;
    }

    public ManagedComponent getComponent(String name, ComponentType type) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(MV_RUNTIME_PERMISSION);
        }
        Set<ManagedComponent> components = this.compByCompType.get(type);
        ManagedComponent comp = null;
        if (components != null) {
            for (ManagedComponent mc : components) {
                if (!mc.getName().equals(name)) continue;
                comp = mc;
                break;
            }
        }
        if (comp != null) {
            Map props = comp.getProperties();
            Set ops = comp.getOperations();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Component(ops.size=" + ops != null ? ops.size() : ("0,props.size=)" + props != null ? props.size() : 0)));
            }
        }
        return comp;
    }

    public Set<ManagedComponent> getMatchingComponents(String name, ComponentType type, NameMatcher<ManagedComponent> matcher) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(MV_RUNTIME_PERMISSION);
        }
        Set<ManagedComponent> components = this.compByCompType.get(type);
        HashSet<ManagedComponent> matched = new HashSet<ManagedComponent>();
        if (components != null) {
            for (ManagedComponent mc : components) {
                if (!matcher.matches((Object)mc, name)) continue;
                matched.add(mc);
            }
        }
        if (matched.size() > 0 && log.isTraceEnabled()) {
            log.trace((Object)("getComponents matched: " + matched));
        }
        return matched;
    }

    public DeploymentTemplateInfo getTemplate(String name) throws NoSuchDeploymentException {
        DeploymentTemplate template;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(MV_RUNTIME_PERMISSION);
        }
        if ((template = this.templates.get(name)) == null) {
            this.formatter.applyPattern(this.i18n.getString("ManagementView.NoSuchTemplate"));
            Object[] args = new Object[]{name};
            String msg = this.formatter.format(args);
            throw new IllegalStateException(msg);
        }
        DeploymentTemplateInfo info = template.getInfo();
        info = info.copy();
        if (log.isTraceEnabled()) {
            log.trace((Object)("getTemplate, " + info));
        }
        return info;
    }

    public void applyTemplate(String deploymentBaseName, DeploymentTemplateInfo info) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(MV_RUNTIME_PERMISSION);
        }
        if (deploymentBaseName == null) {
            throw new IllegalArgumentException("Null deployment base name.");
        }
        if (info == null) {
            throw new IllegalArgumentException("Null template info.");
        }
        DeploymentTemplate template = this.templates.get(info.getName());
        if (template == null) {
            this.formatter.applyPattern(this.i18n.getString("ManagementView.NoSuchTemplate"));
            Object[] args = new Object[]{info.getName()};
            String msg = this.formatter.format(args);
            throw new IllegalStateException(msg);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("applyTemplate, deploymentBaseName=" + deploymentBaseName + ", info=" + info));
        }
        String deploymentName = super.applyTemplate(template, deploymentBaseName, info);
        ManagedDeployment md = this.getMainDeployer().getManagedDeployment(deploymentName);
        this.processRootManagedDeployment(md, this.getDefaulProfiletKey(), log.isTraceEnabled());
    }

    public void process() throws DeploymentException {
    }

    public void updateComponent(ManagedComponent comp) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(MV_RUNTIME_PERMISSION);
        }
        if (comp == null) {
            throw new IllegalArgumentException("Null managed component.");
        }
        ManagedDeployment md = comp.getDeployment();
        while (md.getParent() != null) {
            md = md.getParent();
        }
        String name = md.getName();
        ProfileDeployment compDeployment = this.getProfileDeployment(name);
        if (compDeployment == null) {
            this.formatter.applyPattern(this.i18n.getString("ManagementView.NoSuchDeploymentException"));
            Object[] args = new Object[]{name};
            String msg = this.formatter.format(args);
            throw new NoSuchDeploymentException(msg);
        }
        ManagedDeployment compMD = this.managedDeployments.get(md.getName());
        log.debug((Object)("updateComponent, deploymentName=" + name + ": " + compMD));
        ManagedComponent serverComp = null;
        if (comp.getDeployment().getParent() == null) {
            serverComp = compMD.getComponent(comp.getName());
        } else if (compMD.getChildren() != null && !compMD.getChildren().isEmpty()) {
            for (ManagedDeployment child : compMD.getChildren()) {
                if (serverComp != null) break;
                serverComp = child.getComponent(comp.getName());
            }
        }
        if (serverComp == null) {
            log.debug((Object)("Name: " + comp.getName() + " does not map to existing ManagedComponet in ManagedDeployment: " + md.getName() + ", components: " + compMD.getComponents()));
            this.formatter.applyPattern(this.i18n.getString("ManagementView.InvalidComponentName"));
            Object[] args = new Object[]{comp.getName(), md.getName()};
            String msg = this.formatter.format(args);
            throw new IllegalArgumentException(msg);
        }
        for (ManagedProperty prop : comp.getProperties().values()) {
            String mappedName;
            boolean skip;
            boolean bl = skip = prop.getValue() == null || prop.isReadOnly() || !prop.hasViewUse(ViewUse.CONFIGURATION) || prop.isRemoved();
            if (skip) {
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("Skipping component property: " + prop));
                continue;
            }
            ManagedProperty ctxProp = (ManagedProperty)serverComp.getProperties().get(prop.getName());
            if (ctxProp == null && (mappedName = prop.getMappedName()) != null) {
                ctxProp = (ManagedProperty)serverComp.getProperties().get(mappedName);
            }
            if (ctxProp == null) {
                this.formatter.applyPattern(this.i18n.getString("ManagementView.InvalidTemplateProperty"));
                Object[] args = new Object[]{prop.getName()};
                String msg = this.formatter.format(args);
                throw new IllegalArgumentException(msg);
            }
            MetaValue value = prop.getValue();
            if (!(value instanceof MetaValue)) {
                this.formatter.applyPattern(this.i18n.getString("ManagementView.InvalidPropertyValue"));
                Object[] args = new Object[]{prop.getName(), value.getClass()};
                String msg = this.formatter.format(args);
                throw new IllegalArgumentException(msg);
            }
            MetaValue metaValue = value;
            ctxProp.setField("metaType", (Serializable)metaValue.getMetaType());
            ctxProp.setValue(metaValue);
            Object componentName = this.getComponentName(ctxProp);
            ActivationPolicy policy = ctxProp.getActivationPolicy();
            if (componentName == null || !policy.equals((Object)ActivationPolicy.IMMEDIATE)) continue;
            AbstractRuntimeComponentDispatcher.setActiveProperty(ctxProp);
            this.dispatcher.set(componentName, ctxProp.getName(), metaValue);
        }
        this.store.updateDeployment(comp.getDeployment().getName(), serverComp);
        this.forceReload = true;
    }

    public void removeComponent(ManagedComponent comp) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(MV_RUNTIME_PERMISSION);
        }
        if (comp == null) {
            throw new IllegalArgumentException("null managed component.");
        }
        ManagedDeployment md = comp.getDeployment();
        while (md.getParent() != null) {
            md = md.getParent();
        }
        String name = md.getName();
        ProfileDeployment profileDeployment = this.getProfileDeployment(name);
        if (profileDeployment == null) {
            this.formatter.applyPattern(this.i18n.getString("ManagementView.NoSuchDeploymentException"));
            Object[] args = new Object[]{name};
            String msg = this.formatter.format(args);
            throw new NoSuchDeploymentException(msg);
        }
        ManagedDeployment compMD = this.managedDeployments.get(md.getName());
        log.debug((Object)("updateComponent, deploymentName=" + name + ": " + compMD));
        ManagedComponent serverComp = null;
        if (comp.getDeployment().getParent() == null) {
            serverComp = compMD.getComponent(comp.getName());
        } else if (compMD.getChildren() != null && !compMD.getChildren().isEmpty()) {
            for (ManagedDeployment child : compMD.getChildren()) {
                if (serverComp != null) break;
                serverComp = child.getComponent(comp.getName());
            }
        }
        if (serverComp == null) {
            log.debug((Object)("Name: " + comp.getName() + " does not map to existing ManagedComponet in ManagedDeployment: " + md.getName() + ", components: " + compMD.getComponents()));
            this.formatter.applyPattern(this.i18n.getString("ManagementView.InvalidComponentName"));
            Object[] args = new Object[]{comp.getName(), md.getName()};
            String msg = this.formatter.format(args);
            throw new IllegalArgumentException(msg);
        }
        log.debug((Object)("remove component: " + comp + ", deployment: " + profileDeployment));
        this.store.removeComponent(comp.getDeployment().getName(), serverComp);
    }

    protected Object getComponentName(ManagedProperty property) {
        ManagedObject targetObject = property.getTargetManagedObject();
        if (targetObject != null) {
            return targetObject.getComponentName();
        }
        targetObject = property.getManagedObject();
        return targetObject != null ? targetObject.getComponentName() : null;
    }

    protected void checkForReferences(String key, ManagedObject mo) {
        Set<ManagedProperty> referers = this.unresolvedRefs.get(key);
        log.debug((Object)("checkForReferences, " + key + " has referers: " + referers));
        if (referers != null) {
            for (ManagedProperty prop : referers) {
                prop.setTargetManagedObject(mo);
            }
            this.unresolvedRefs.remove(key);
        }
    }

    protected void mergeRuntimeMO(ManagedObject mo, ManagedObject runtimeMO) throws Exception {
        Map runtimeProps = runtimeMO.getProperties();
        Set<ManagedOperation> runtimeOps = runtimeMO.getOperations();
        Object componentName = runtimeMO.getComponentName();
        log.debug((Object)("Merging runtime: " + runtimeMO.getName() + ", compnent name: " + componentName));
        Map moProps = null;
        Set moOps = null;
        HashMap<String, ManagedProperty> props = null;
        HashSet<ManagedOperation> ops = null;
        if (mo == null) {
            mo = runtimeMO;
            moProps = mo.getProperties();
            moOps = mo.getOperations();
            props = new HashMap();
            ops = new HashSet<ManagedOperation>();
        } else {
            moProps = mo.getProperties();
            moOps = mo.getOperations();
            props = new HashMap<String, ManagedProperty>(moProps);
            ops = new HashSet(moOps);
        }
        boolean trace = log.isTraceEnabled();
        if (runtimeProps != null && runtimeProps.size() > 0) {
            if (trace) {
                log.trace((Object)("Properties before:" + props));
            }
            for (ManagedProperty prop : runtimeProps.values()) {
                if (prop.hasViewUse(ViewUse.STATISTIC)) {
                    String propName = prop.getMappedName();
                    try {
                        AbstractRuntimeComponentDispatcher.setActiveProperty(prop);
                        MetaValue propValue = this.dispatcher.get(componentName, propName);
                        if (propValue != null) {
                            prop.setValue(propValue);
                        }
                    }
                    catch (Throwable t) {
                        log.debug((Object)("Failed to get stat value, " + componentName + ":" + propName));
                    }
                    ManagedProperty proxiedProp = this.createPropertyProxy(prop);
                    props.put(prop.getName(), proxiedProp);
                } else {
                    props.put(prop.getName(), prop);
                }
                if (prop.getTargetManagedObject() != null) continue;
                prop.setTargetManagedObject(runtimeMO);
            }
            if (trace) {
                log.trace((Object)("Properties after:" + props));
            }
        }
        if (runtimeOps != null && runtimeOps.size() > 0) {
            if (trace) {
                log.trace((Object)("Ops before:" + ops));
            }
            runtimeOps = this.createOperationProxies(runtimeMO, runtimeOps);
            ops.addAll(runtimeOps);
            if (trace) {
                log.trace((Object)("Ops after:" + ops));
            }
        }
        MutableManagedObject moi = (MutableManagedObject)mo;
        moi.setProperties(props);
        moi.setOperations(ops);
    }

    private ManagedProperty createPropertyProxy(ManagedProperty prop) throws Exception {
        if (this.proxyFactory == null) {
            throw new IllegalArgumentException("Missing RuntimeComponentDispatcher.");
        }
        Object componentName = prop.getManagedObject().getComponentName();
        if (prop.getManagedObject().getTransientAttachment(MBeanRuntimeComponentDispatcher.class.getName()) != null) {
            return this.mbeanProxyFactory.createPropertyProxy(prop, componentName);
        }
        return this.proxyFactory.createPropertyProxy(prop, componentName);
    }

    protected Set<ManagedOperation> createOperationProxies(ManagedObject mo, Set<ManagedOperation> ops) throws Exception {
        if (this.proxyFactory == null) {
            throw new IllegalArgumentException("Missing RuntimeComponentDispatcher.");
        }
        Object componentName = mo.getComponentName();
        return this.createOperationProxies(ops, componentName);
    }

    protected Set<ManagedOperation> createOperationProxies(Set<ManagedOperation> ops, Object componentName) throws Exception {
        return this.proxyFactory.createOperationProxies(ops, componentName);
    }

    private ManagedObject createManagedObject(ObjectName mbean, String defaultViewUse, Map<String, String> propertyMetaMappings) throws Exception {
        ViewUse[] viewUseArray;
        MBeanInfo info = this.mbeanServer.getMBeanInfo(mbean);
        ClassLoader mbeanLoader = this.mbeanServer.getClassLoaderFor(mbean);
        MetaData metaData = null;
        if (defaultViewUse == null) {
            viewUseArray = null;
        } else {
            ViewUse[] viewUseArray2 = new ViewUse[1];
            viewUseArray = viewUseArray2;
            viewUseArray2[0] = ViewUse.valueOf((String)defaultViewUse);
        }
        ViewUse[] viewUse = viewUseArray;
        ManagedObject mo = this.mbeanMOFactory.getManagedObject(mbean, info, mbeanLoader, metaData, viewUse, propertyMetaMappings);
        return mo;
    }

    private ManagedDeployment getManagedDeployment(ProfileDeployment ctx) throws DeploymentException {
        return this.mainDeployer.getManagedDeployment(ctx.getName());
    }

    private ProfileKey getProfileKeyForDeployemnt(String name) throws NoSuchDeploymentException {
        ManagedDeployment md = this.getDeployment(name);
        return (ProfileKey)md.getAttachment(ProfileKey.class);
    }

    private Profile getProfileForDeployment(String name) throws Exception {
        ProfileKey key = this.getProfileKeyForDeployemnt(name);
        if (key == null) {
            throw new NoSuchDeploymentException("No associated profile found for deployment:" + name);
        }
        return this.ps.getActiveProfile(key);
    }

    private ProfileDeployment getProfileDeployment(String name) throws Exception {
        Profile profile = this.getProfileForDeployment(name);
        return profile.getDeployment(name);
    }

    public static void main(String[] args) throws Exception {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        ObjectName name = new ObjectName("jboss.management.local:J2EEApplication=null,J2EEServer=Local,j2eeType=WebModule,*");
        Set<ObjectName> matches = server.queryNames(name, null);
        for (ObjectName on : matches) {
            System.err.println(on);
        }
    }

    public ManagedOperationProxyFactory getMbeanProxyFactory() {
        return this.mbeanProxyFactory;
    }

    public void setMbeanProxyFactory(ManagedOperationProxyFactory mbeanProxyFactory) {
        this.mbeanProxyFactory = mbeanProxyFactory;
    }

    static {
        HashMap<String, RunState> runStateMappings = new HashMap<String, RunState>();
        runStateMappings.put("**ERROR**", RunState.FAILED);
        runStateMappings.put("Not Installed", RunState.STOPPED);
        runStateMappings.put("PreInstall", RunState.STOPPED);
        runStateMappings.put("Described", RunState.STOPPED);
        runStateMappings.put("Instantiated", RunState.STOPPED);
        runStateMappings.put("Configured", RunState.STOPPED);
        runStateMappings.put("Create", RunState.STOPPED);
        runStateMappings.put("Start", RunState.STOPPED);
        runStateMappings.put("Installed", RunState.RUNNING);
        runStateMapper = new ContextStateMapper(runStateMappings, (Enum)RunState.STARTING, (Enum)RunState.STOPPED, (Enum)RunState.FAILED, (Enum)RunState.UNKNOWN);
        HashMap<String, DeploymentState> deploymentMappings = new HashMap<String, DeploymentState>();
        deploymentMappings.put("**ERROR**", DeploymentState.FAILED);
        deploymentMappings.put("Not Installed", DeploymentState.STOPPED);
        deploymentMappings.put("Installed", DeploymentState.STARTED);
        deploymentStateMapper = new ContextStateMapper(deploymentMappings, (Enum)DeploymentState.STARTING, (Enum)DeploymentState.STOPPING, (Enum)DeploymentState.FAILED, (Enum)DeploymentState.UNKNOWN);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ManagementObjectAnnotationImpl
    implements ManagementObject,
    Serializable {
        private static final long serialVersionUID = 5355799336353299850L;
        private final String name;
        private final String type;
        private final String subtype;

        private ManagementObjectAnnotationImpl(String name, String type, String subtype) {
            this.name = name;
            this.type = type;
            this.subtype = subtype;
        }

        public String attachmentName() {
            return "";
        }

        public ManagementProperty[] classProperties() {
            return new ManagementProperty[0];
        }

        public ManagementComponent componentType() {
            return new ManagementComponentAnnotationImpl();
        }

        public String description() {
            return "";
        }

        public boolean isRuntime() {
            return true;
        }

        public String name() {
            return this.name;
        }

        public ManagementOperation[] operations() {
            return new ManagementOperation[0];
        }

        public ManagementProperties properties() {
            return ManagementProperties.ALL;
        }

        public Class<?> targetInterface() {
            return Object.class;
        }

        public String type() {
            return "";
        }

        public Class<? extends Annotation> annotationType() {
            return ManagementObject.class;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class ManagementComponentAnnotationImpl
        implements ManagementComponent,
        Serializable {
            private static final long serialVersionUID = 5355799336353299850L;

            private ManagementComponentAnnotationImpl() {
            }

            public String subtype() {
                return ManagementObjectAnnotationImpl.this.subtype;
            }

            public String type() {
                return ManagementObjectAnnotationImpl.this.type;
            }

            public Class<? extends Annotation> annotationType() {
                return ManagementComponent.class;
            }
        }
    }
}

