/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.ServletContext;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.JarRepository;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.util.IOTools;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.naming.resources.Resource;
import org.jboss.logging.Logger;

public class ContextJarRepository
implements JarRepository,
Contained,
Lifecycle {
    private static Logger log = Logger.getLogger(ContextJarRepository.class);
    protected Container container = null;
    protected String info = "org.apache.catalina.core.ContextJarRepository/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.core");
    protected boolean started = false;
    protected String classesPath = "/WEB-INF/classes";
    protected String libPath = "/WEB-INF/lib";
    protected Map<String, JarFile> jarFiles = new HashMap<String, JarFile>();
    protected JarFile[] jarFilesArray = new JarFile[0];
    protected Map<String, File> explodedJars = new HashMap<String, File>();
    protected File[] explodedJarsArray = new File[0];
    protected boolean tempJars = false;
    protected boolean tempExplodedJars = false;

    public ContextJarRepository() {
        this(null);
    }

    public ContextJarRepository(Container container) {
        this.setContainer(container);
    }

    @Override
    public String getInfo() {
        return this.info;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        this.container = container;
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() throws LifecycleException {
        if (this.started) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("contextJarRepository.alreadyStarted"));
            }
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_start", null);
        this.started = true;
        if (!(this.container instanceof Context)) {
            throw new IllegalStateException("");
        }
        DirContext resources = this.container.getResources();
        ServletContext servletContext = ((Context)this.container).getServletContext();
        if (servletContext == null) {
            return;
        }
        File workDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
        if (workDir == null) {
            log.info((Object)("No work dir for " + servletContext));
        }
        NamingEnumeration<Binding> libPathListing = null;
        try {
            libPathListing = resources.listBindings(this.libPath);
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (libPathListing != null) {
            String absoluteLibPath = servletContext.getRealPath(this.libPath);
            File destDir = null;
            if (absoluteLibPath != null) {
                destDir = new File(absoluteLibPath);
            } else {
                this.tempJars = true;
                destDir = new File(workDir, this.libPath);
                destDir.mkdirs();
            }
            while (libPathListing.hasMoreElements()) {
                Binding binding = (Binding)libPathListing.nextElement();
                String logicalName = this.libPath + "/" + binding.getName();
                if (!logicalName.endsWith(".jar")) continue;
                File destFile = new File(destDir, binding.getName());
                Object obj = binding.getObject();
                if (!(obj instanceof Resource)) continue;
                Resource jarResource = (Resource)obj;
                try {
                    if (this.tempJars) {
                        InputStream is = null;
                        FileOutputStream os = null;
                        try {
                            is = jarResource.streamContent();
                            os = new FileOutputStream(destFile);
                            IOTools.flow(is, os);
                        }
                        finally {
                            try {
                                if (is != null) {
                                    is.close();
                                }
                            }
                            catch (IOException e) {}
                            try {
                                if (os != null) {
                                    ((OutputStream)os).close();
                                }
                            }
                            catch (IOException e) {}
                        }
                    }
                    JarFile jarFile = new JarFile(destFile);
                    this.jarFiles.put(logicalName, jarFile);
                }
                catch (IOException ex) {}
            }
        }
        this.jarFilesArray = this.jarFiles.values().toArray(this.jarFilesArray);
        DirContext classes = null;
        try {
            Object object = resources.lookup(this.classesPath);
            if (object instanceof DirContext) {
                classes = (DirContext)object;
            }
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (classes != null) {
            File classRepository = null;
            String absoluteClassesPath = servletContext.getRealPath(this.classesPath);
            if (absoluteClassesPath != null) {
                classRepository = new File(absoluteClassesPath);
            } else {
                classRepository = new File(workDir, this.classesPath);
                classRepository.mkdirs();
                this.tempExplodedJars = true;
                try {
                    this.copyDirContext(classes, classRepository);
                }
                catch (NamingException ex) {
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            this.explodedJarsArray = new File[]{classRepository};
            this.explodedJars.put(this.classesPath + "/", classRepository);
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.lifecycle.fireLifecycleEvent("after_start", null);
    }

    @Override
    public synchronized void stop() throws LifecycleException {
        if (!this.started) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("contextJarRepository.notStarted"));
            }
            return;
        }
        this.lifecycle.fireLifecycleEvent("before_stop", null);
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        try {
            for (int i = 0; i < this.jarFilesArray.length; ++i) {
                this.jarFilesArray[i].close();
                if (!this.tempJars) continue;
                new File(this.jarFilesArray[i].getName()).delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.jarFiles.clear();
        this.jarFilesArray = new JarFile[0];
        this.tempJars = false;
        this.explodedJars.clear();
        this.explodedJarsArray = new File[0];
        this.tempExplodedJars = false;
        this.lifecycle.fireLifecycleEvent("after_stop", null);
    }

    @Override
    public void backgroundProcess() {
    }

    @Override
    public Map<String, JarFile> getJars() {
        return this.jarFiles;
    }

    @Override
    public JarFile findJar(String path) {
        for (int i = 0; i < this.jarFilesArray.length; ++i) {
            if (!this.jarFilesArray[i].getName().equals(path)) continue;
            return this.jarFilesArray[i];
        }
        return null;
    }

    @Override
    public JarFile[] findJars() {
        return this.jarFilesArray;
    }

    @Override
    public Map<String, File> getExplodedJars() {
        return this.explodedJars;
    }

    @Override
    public File[] findExplodedJars() {
        return this.explodedJarsArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyDirContext(DirContext srcDir, File destDir) throws IOException, NamingException {
        InputStream is = null;
        FileOutputStream os = null;
        NamingEnumeration<NameClassPair> enumeration = srcDir.list("");
        while (enumeration.hasMoreElements()) {
            NameClassPair ncPair = (NameClassPair)enumeration.nextElement();
            String name = ncPair.getName();
            Object object = srcDir.lookup(name);
            File currentFile = new File(destDir, name);
            if (object instanceof Resource) {
                try {
                    is = ((Resource)object).streamContent();
                    os = new FileOutputStream(currentFile);
                    IOTools.flow(is, os);
                    continue;
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException e) {}
                    try {
                        if (os == null) continue;
                        ((OutputStream)os).close();
                    }
                    catch (IOException e) {}
                    continue;
                }
            }
            if (object instanceof InputStream) {
                try {
                    is = (InputStream)object;
                    os = new FileOutputStream(currentFile);
                    IOTools.flow(is, os);
                    continue;
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException e) {}
                    try {
                        if (os == null) continue;
                        ((OutputStream)os).close();
                    }
                    catch (IOException e) {}
                    continue;
                }
            }
            if (!(object instanceof DirContext)) continue;
            currentFile.mkdir();
            this.copyDirContext((DirContext)object, currentFile);
        }
    }
}

