/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Valve;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHostValve;
import org.apache.catalina.core.StandardPipeline;
import org.apache.catalina.startup.HostConfig;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.logging.Logger;

public class StandardHost
extends ContainerBase
implements Host {
    private static Logger log = Logger.getLogger(StandardHost.class);
    private String[] aliases = new String[0];
    private String appBase = ".";
    private boolean autoDeploy = Boolean.valueOf(System.getProperty("org.apache.catalina.core.StandardHost.autoDeploy", "true"));
    private String configClass = System.getProperty("org.apache.catalina.core.StandardHost.configClass", "org.apache.catalina.startup.ContextConfig");
    private String contextClass = "org.apache.catalina.core.StandardContext";
    private boolean deployOnStartup = Boolean.valueOf(System.getProperty("org.apache.catalina.core.StandardHost.deployOnStartup", "true"));
    private boolean deployXML = Boolean.valueOf(System.getProperty("org.apache.catalina.core.StandardHost.deployXML", "true"));
    private String errorReportValveClass = "org.apache.catalina.valves.ErrorReportValve";
    private ObjectName errorReportValveObjectName = null;
    private static final String info = "org.apache.catalina.core.StandardHost/1.0";
    private boolean unpackWARs = true;
    private String workDir = null;
    private boolean initialized = false;

    public StandardHost() {
        this.pipeline.setBasic(new StandardHostValve());
        this.startChildren = Boolean.valueOf(System.getProperty("org.apache.catalina.core.StandardHost.startChildren", "true"));
    }

    @Override
    public String getAppBase() {
        return this.appBase;
    }

    @Override
    public void setAppBase(String appBase) {
        String oldAppBase = this.appBase;
        this.appBase = appBase;
        this.support.firePropertyChange("appBase", oldAppBase, this.appBase);
    }

    @Override
    public boolean getAutoDeploy() {
        return this.autoDeploy;
    }

    @Override
    public void setAutoDeploy(boolean autoDeploy) {
        boolean oldAutoDeploy = this.autoDeploy;
        this.autoDeploy = autoDeploy;
        this.support.firePropertyChange("autoDeploy", oldAutoDeploy, this.autoDeploy);
    }

    @Override
    public String getConfigClass() {
        return this.configClass;
    }

    @Override
    public void setConfigClass(String configClass) {
        String oldConfigClass = this.configClass;
        this.configClass = configClass;
        this.support.firePropertyChange("configClass", oldConfigClass, this.configClass);
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public void setContextClass(String contextClass) {
        String oldContextClass = this.contextClass;
        this.contextClass = contextClass;
        this.support.firePropertyChange("contextClass", oldContextClass, this.contextClass);
    }

    @Override
    public boolean getDeployOnStartup() {
        return this.deployOnStartup;
    }

    @Override
    public void setDeployOnStartup(boolean deployOnStartup) {
        boolean oldDeployOnStartup = this.deployOnStartup;
        this.deployOnStartup = deployOnStartup;
        this.support.firePropertyChange("deployOnStartup", oldDeployOnStartup, this.deployOnStartup);
    }

    public boolean isDeployXML() {
        return this.deployXML;
    }

    public void setDeployXML(boolean deployXML) {
        this.deployXML = deployXML;
    }

    public boolean getLiveDeploy() {
        return this.autoDeploy;
    }

    public void setLiveDeploy(boolean liveDeploy) {
        this.setAutoDeploy(liveDeploy);
    }

    public String getErrorReportValveClass() {
        return this.errorReportValveClass;
    }

    public void setErrorReportValveClass(String errorReportValveClass) {
        String oldErrorReportValveClassClass = this.errorReportValveClass;
        this.errorReportValveClass = errorReportValveClass;
        this.support.firePropertyChange("errorReportValveClass", oldErrorReportValveClassClass, this.errorReportValveClass);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(sm.getString("standardHost.nullName"));
        }
        name = name.toLowerCase();
        String oldName = this.name;
        this.name = name;
        this.support.firePropertyChange("name", oldName, this.name);
    }

    public boolean isUnpackWARs() {
        return this.unpackWARs;
    }

    public void setUnpackWARs(boolean unpackWARs) {
        this.unpackWARs = unpackWARs;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    @Override
    public void addAlias(String alias) {
        alias = alias.toLowerCase();
        for (int i = 0; i < this.aliases.length; ++i) {
            if (!this.aliases[i].equals(alias)) continue;
            return;
        }
        String[] newAliases = new String[this.aliases.length + 1];
        for (int i = 0; i < this.aliases.length; ++i) {
            newAliases[i] = this.aliases[i];
        }
        newAliases[this.aliases.length] = alias;
        this.aliases = newAliases;
        this.fireContainerEvent("addAlias", alias);
    }

    @Override
    public void addChild(Container child) {
        if (!(child instanceof Context)) {
            throw new IllegalArgumentException(sm.getString("standardHost.notContext"));
        }
        super.addChild(child);
    }

    @Override
    public String[] findAliases() {
        return this.aliases;
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public Context map(String uri) {
        int slash;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Mapping request URI '" + uri + "'"));
        }
        if (uri == null) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"  Trying the longest context path prefix");
        }
        Context context = null;
        String mapuri = uri;
        while ((context = (Context)this.findChild(mapuri)) == null && (slash = mapuri.lastIndexOf(47)) >= 0) {
            mapuri = mapuri.substring(0, slash);
        }
        if (context == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"  Trying the default context");
            }
            context = (Context)this.findChild("");
        }
        if (context == null) {
            log.error((Object)sm.getString("standardHost.mappingError", uri));
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(" Mapped to context '" + context.getPath() + "'"));
        }
        return context;
    }

    @Override
    public void removeAlias(String alias) {
        alias = alias.toLowerCase();
        int n = -1;
        for (int i = 0; i < this.aliases.length; ++i) {
            if (!this.aliases[i].equals(alias)) continue;
            n = i;
            break;
        }
        if (n < 0) {
            return;
        }
        int j = 0;
        String[] results = new String[this.aliases.length - 1];
        for (int i = 0; i < this.aliases.length; ++i) {
            if (i == n) continue;
            results[j++] = this.aliases[i];
        }
        this.aliases = results;
        this.fireContainerEvent("removeAlias", alias);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getParent() != null) {
            sb.append(this.getParent().toString());
            sb.append(".");
        }
        sb.append("StandardHost[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public synchronized void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.realm == null) {
            ObjectName realmName = null;
            try {
                realmName = new ObjectName(this.domain + ":type=Realm,host=" + this.getName());
                if (this.mserver.isRegistered(realmName)) {
                    this.mserver.invoke(realmName, "init", new Object[0], new String[0]);
                }
            }
            catch (Throwable t) {
                log.debug((Object)("No realm for this host " + realmName));
            }
        }
        if (this.errorReportValveClass != null && !this.errorReportValveClass.equals("")) {
            try {
                boolean found = false;
                if (this.errorReportValveObjectName != null) {
                    ObjectName[] names = ((StandardPipeline)this.pipeline).getValveObjectNames();
                    for (int i = 0; !found && i < names.length; ++i) {
                        if (!this.errorReportValveObjectName.equals(names[i])) continue;
                        found = true;
                    }
                }
                if (!found) {
                    Valve valve = (Valve)Class.forName(this.errorReportValveClass).newInstance();
                    this.addValve(valve);
                    this.errorReportValveObjectName = ((ValveBase)valve).getObjectName();
                }
            }
            catch (Throwable t) {
                log.error((Object)sm.getString("standardHost.invalidErrorReportValveClass", this.errorReportValveClass), t);
            }
        }
        super.start();
    }

    public String[] getValveNames() throws Exception {
        Valve[] valves = this.getValves();
        String[] mbeanNames = new String[valves.length];
        for (int i = 0; i < valves.length; ++i) {
            if (valves[i] == null || ((ValveBase)valves[i]).getObjectName() == null) continue;
            mbeanNames[i] = ((ValveBase)valves[i]).getObjectName().toString();
        }
        return mbeanNames;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    @Override
    public synchronized void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.getParent() == null) {
            try {
                ObjectName serviceName = new ObjectName(this.domain + ":type=Engine");
                HostConfig deployer = new HostConfig();
                this.addLifecycleListener(deployer);
                if (this.mserver.isRegistered(serviceName)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Registering " + serviceName + " with the Engine"));
                    }
                    this.mserver.invoke(serviceName, "addChild", new Object[]{this}, new String[]{"org.apache.catalina.Container"});
                }
            }
            catch (Exception ex) {
                log.error((Object)"Host registering failed!", (Throwable)ex);
            }
        }
        if (this.oname == null) {
            try {
                StandardEngine engine = (StandardEngine)this.parent;
                this.domain = engine.getName();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Register host " + this.getName() + " with domain " + this.domain));
                }
                this.controller = this.oname = new ObjectName(this.domain + ":type=Host,host=" + this.getName());
                Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, null);
            }
            catch (Throwable t) {
                log.error((Object)"Host registering failed!", t);
            }
        }
    }

    @Override
    public synchronized void destroy() throws Exception {
        Container[] children = this.findChildren();
        super.destroy();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof StandardContext)) continue;
            ((StandardContext)children[i]).destroy();
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName oname) throws Exception {
        ObjectName res = super.preRegister(server, oname);
        String name = oname.getKeyProperty("host");
        if (name != null) {
            this.setName(name);
        }
        return res;
    }

    @Override
    public ObjectName createObjectName(String domain, ObjectName parent) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Create ObjectName " + domain + " " + parent));
        }
        return new ObjectName(domain + ":type=Host,host=" + this.getName());
    }
}

