/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.plugins.types;

import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import javax.management.ObjectName;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.config.plugins.property.PropertyConfiguration;
import org.jboss.config.spi.Configuration;
import org.jboss.logging.Logger;
import org.jboss.metatype.api.annotations.CompositeKey;
import org.jboss.metatype.api.annotations.CompositeValue;
import org.jboss.metatype.api.annotations.Generic;
import org.jboss.metatype.api.types.ArrayMetaType;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.EnumMetaType;
import org.jboss.metatype.api.types.GenericMetaType;
import org.jboss.metatype.api.types.ImmutableCompositeMetaType;
import org.jboss.metatype.api.types.ImmutableTableMetaType;
import org.jboss.metatype.api.types.MapCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.MetaTypeFactory;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.types.TableMetaType;
import org.jboss.metatype.plugins.types.ClassMetaTypeBuilder;
import org.jboss.metatype.plugins.types.JBossLoggerTypeBuilder;
import org.jboss.metatype.plugins.types.MutableCompositeMetaType;
import org.jboss.metatype.plugins.types.ObjectNameTypeBuilder;
import org.jboss.metatype.spi.types.MetaTypeBuilder;
import org.jboss.metatype.spi.values.MetaMapper;
import org.jboss.reflect.spi.ArrayInfo;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.EnumConstantInfo;
import org.jboss.reflect.spi.EnumInfo;
import org.jboss.reflect.spi.InterfaceInfo;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMetaTypeFactory
extends MetaTypeFactory {
    public static final String MAP_KEY = "key";
    public static final String MAP_VALUE = "value";
    public static final String[] MAP_INDEX_NAMES = new String[]{"key"};
    public static final String[] MAP_ITEM_NAMES = new String[]{"key", "value"};
    private static Configuration configuration = AccessController.doPrivileged(new PrivilegedAction<Configuration>(){

        @Override
        public Configuration run() {
            return new PropertyConfiguration();
        }
    });
    private TypeInfo objectTypeInfo = configuration.getTypeInfo(Object.class);
    private Map<Class<?>, WeakReference<MetaTypeBuilder>> builders = new WeakHashMap();

    public DefaultMetaTypeFactory() {
        this.setBuilder(Class.class, ClassMetaTypeBuilder.INSTANCE);
        this.setBuilder(ObjectName.class, ObjectNameTypeBuilder.INSTANCE);
        this.setBuilder(Logger.class, JBossLoggerTypeBuilder.INSTANCE);
    }

    @Override
    public MetaType resolve(Type type) {
        TypeInfo typeInfo = configuration.getTypeInfo(type);
        return this.resolve(typeInfo);
    }

    @Override
    public MetaType resolve(TypeInfo typeInfo) {
        MetaType result = (MetaType)typeInfo.getAttachment(MetaType.class);
        if (result == null) {
            result = this.generate(typeInfo);
            typeInfo.setAttachment(MetaType.class.getName(), (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBuilder(Class<?> clazz, MetaTypeBuilder builder) {
        Map<Class<?>, WeakReference<MetaTypeBuilder>> map = this.builders;
        synchronized (map) {
            if (builder == null) {
                this.builders.remove(clazz);
            }
            this.builders.put(clazz, new WeakReference<MetaTypeBuilder>(builder));
        }
    }

    public MetaType generate(TypeInfo typeInfo) {
        MetaType result = this.isBuilder(typeInfo);
        if (result != null) {
            return result;
        }
        MetaMapper<?> mapper = MetaMapper.getMetaMapper(typeInfo);
        if (mapper != null) {
            return mapper.getMetaType();
        }
        result = this.isGeneric(typeInfo);
        if (result != null) {
            return result;
        }
        if (typeInfo.isEnum()) {
            return this.generateEnum((EnumInfo)typeInfo);
        }
        ClassInfo annotationType = this.isAnnotation(typeInfo);
        if (annotationType != null) {
            return this.generateAnnotation(annotationType);
        }
        if (typeInfo.isArray()) {
            return this.generateArray((ArrayInfo)typeInfo);
        }
        if (typeInfo.isCollection()) {
            return this.generateCollection((ClassInfo)typeInfo);
        }
        if (typeInfo.isMap()) {
            ClassInfo classInfo = (ClassInfo)typeInfo;
            TypeInfo[] types = classInfo.getActualTypeArguments();
            if (types != null) {
                TypeInfo keyType = types[0];
                TypeInfo valueType = types[1];
                if (keyType.getName().equals(String.class.getName())) {
                    MetaType valueMetaType = this.resolve(valueType);
                    return new MapCompositeMetaType(valueMetaType);
                }
            } else if (typeInfo.getName().equals(Properties.class.getName())) {
                return new MapCompositeMetaType(SimpleMetaType.STRING);
            }
            return this.generateMap(classInfo);
        }
        result = SimpleMetaType.isSimpleType(typeInfo.getName());
        if (result != null) {
            return result;
        }
        return this.generateBean((ClassInfo)typeInfo);
    }

    public EnumMetaType generateEnum(EnumInfo typeInfo) {
        EnumConstantInfo[] constants = typeInfo.getEnumConstants();
        ArrayList<String> validValues = new ArrayList<String>(constants.length);
        for (EnumConstantInfo constant : constants) {
            validValues.add(constant.getName());
        }
        return new EnumMetaType(typeInfo.getName(), validValues);
    }

    public ClassInfo isAnnotation(TypeInfo typeInfo) {
        ClassInfo classInfo;
        InterfaceInfo[] interfaces;
        if (typeInfo.isAnnotation()) {
            return (ClassInfo)typeInfo;
        }
        if (typeInfo instanceof ClassInfo && (interfaces = (classInfo = (ClassInfo)typeInfo).getInterfaces()) != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                if (!interfaces[i].isAnnotation()) continue;
                return interfaces[i];
            }
        }
        return null;
    }

    public CompositeMetaType generateAnnotation(ClassInfo typeInfo) {
        return this.generateBean(typeInfo);
    }

    public ArrayMetaType generateArray(ArrayInfo typeInfo) {
        int dimension = 1;
        TypeInfo componentType = typeInfo.getComponentType();
        while (componentType.isArray()) {
            ++dimension;
            componentType = ((ArrayInfo)componentType).getComponentType();
        }
        MetaType componentMetaType = this.resolve(componentType);
        boolean isPrimitive = componentType.isPrimitive();
        return new ArrayMetaType(dimension, componentMetaType, isPrimitive);
    }

    public CollectionMetaType generateCollection(ClassInfo typeInfo) {
        TypeInfo elementType = this.objectTypeInfo;
        TypeInfo[] types = typeInfo.getActualTypeArguments();
        if (types != null) {
            elementType = types[0];
        }
        MetaType elementMetaType = this.resolve(elementType);
        return new CollectionMetaType(typeInfo.getName(), elementMetaType);
    }

    public TableMetaType generateMap(ClassInfo typeInfo) {
        TypeInfo keyType = this.objectTypeInfo;
        TypeInfo valueType = this.objectTypeInfo;
        TypeInfo[] types = typeInfo.getActualTypeArguments();
        if (types != null) {
            keyType = types[0];
            valueType = types[1];
        }
        return this.createMapType(keyType, valueType);
    }

    public TableMetaType createMapType(TypeInfo keyType, TypeInfo valueType) {
        String name = Map.class.getName();
        MetaType[] itemTypes = new MetaType[]{this.resolve(keyType), this.resolve(valueType)};
        CompositeMetaType entryType = DefaultMetaTypeFactory.createMapEntryType(itemTypes);
        return new ImmutableTableMetaType(name, name, entryType, MAP_INDEX_NAMES);
    }

    public static CompositeMetaType createMapEntryType(MetaType[] itemTypes) {
        String entryName = Map.Entry.class.getName();
        return new ImmutableCompositeMetaType(entryName, entryName, MAP_ITEM_NAMES, MAP_ITEM_NAMES, itemTypes);
    }

    public CompositeMetaType generateBean(ClassInfo typeInfo) {
        BeanInfo beanInfo = configuration.getBeanInfo((TypeInfo)typeInfo);
        MutableCompositeMetaType result = new MutableCompositeMetaType(typeInfo.getName(), typeInfo.getName());
        typeInfo.setAttachment(MetaType.class.getName(), (Object)result);
        LinkedHashSet<String> keys = null;
        Set properties = beanInfo.getProperties();
        if (properties != null && properties.size() > 0) {
            for (PropertyInfo property : properties) {
                String compositeValueName;
                String name;
                CompositeValue compositeValue = (CompositeValue)property.getUnderlyingAnnotation(CompositeValue.class);
                if (compositeValue != null && compositeValue.ignore() || "class".equals(name = property.getName())) continue;
                if (compositeValue != null && !"##DEFAULT".equals(compositeValueName = compositeValue.name())) {
                    name = compositeValueName;
                }
                TypeInfo itemTypeInfo = property.getType();
                MetaType metaType = this.resolve(itemTypeInfo);
                result.addItem(name, name, metaType);
                if (!property.isAnnotationPresent(CompositeKey.class)) continue;
                if (keys == null) {
                    keys = new LinkedHashSet<String>();
                }
                keys.add(name);
            }
        }
        if (keys != null) {
            result.setKeys(keys);
        }
        result.freeze();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaType isBuilder(TypeInfo typeInfo) {
        MetaTypeBuilder builder = null;
        Map<Class<?>, WeakReference<MetaTypeBuilder>> map = this.builders;
        synchronized (map) {
            WeakReference<MetaTypeBuilder> weak = this.builders.get(typeInfo.getType());
            if (weak != null) {
                builder = (MetaTypeBuilder)weak.get();
            }
        }
        if (builder == null) {
            return null;
        }
        return builder.buildMetaType();
    }

    public GenericMetaType isGeneric(TypeInfo typeInfo) {
        if (!(typeInfo instanceof ClassInfo)) {
            return null;
        }
        ClassInfo classInfo = (ClassInfo)typeInfo;
        Generic generic = (Generic)classInfo.getUnderlyingAnnotation(Generic.class);
        if (generic != null) {
            return new GenericMetaType(typeInfo.getName(), typeInfo.getName());
        }
        return null;
    }
}

