/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.deployer.jndi;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.util.naming.NonSerializableFactory;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.integration.deployer.env.helpers.BootstrapBean;
import org.jboss.weld.integration.deployer.jndi.AbstractJndiBinderDeployer;
import org.jboss.weld.manager.api.WeldManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JndiBinderDeployer
extends AbstractJndiBinderDeployer<BootstrapBean> {
    public JndiBinderDeployer() {
        super(BootstrapBean.class);
    }

    @Override
    public void bind(BootstrapBean bootstrapBean, String deploymentUnitName) throws NamingException {
        Map<String, BeanManager> beanManagers = new DeploymentVisitor(bootstrapBean).visit().getBeanManagers();
        Context context = this.getBeanManagerContext().createSubcontext(deploymentUnitName);
        for (Map.Entry<String, BeanManager> entry : beanManagers.entrySet()) {
            NonSerializableFactory.rebind((Context)context, (String)entry.getKey(), (Object)entry.getValue());
        }
    }

    @Override
    public void unbind(BootstrapBean bootstrapBean, String deploymentUnitName) throws NamingException {
        Map<String, BeanManager> beanManagers = new DeploymentVisitor(bootstrapBean).visit().getBeanManagers();
        Context context = (Context)this.getBeanManagerContext().lookup(deploymentUnitName);
        for (Map.Entry<String, BeanManager> entry : beanManagers.entrySet()) {
            context.unbind(entry.getKey());
            NonSerializableFactory.unbind((String)entry.getKey());
        }
        this.getBeanManagerContext().destroySubcontext(deploymentUnitName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DeploymentVisitor {
        private final Map<String, BeanManager> beanManagers = new HashMap<String, BeanManager>();
        private final BootstrapBean bootstrapBean;

        public DeploymentVisitor(BootstrapBean bootstrapBean) {
            this.bootstrapBean = bootstrapBean;
        }

        public Map<String, BeanManager> getBeanManagers() {
            return Collections.unmodifiableMap(this.beanManagers);
        }

        public DeploymentVisitor visit() {
            for (BeanDeploymentArchive bda : this.bootstrapBean.getDeployment().getBeanDeploymentArchives()) {
                this.visit(bda, new HashSet<BeanDeploymentArchive>());
            }
            return this;
        }

        private void visit(BeanDeploymentArchive bda, Set<BeanDeploymentArchive> seenBdas) {
            WeldManager beanManager = this.bootstrapBean.getBootstrap().getManager(bda);
            String key = beanManager.getId();
            this.beanManagers.put(key, (BeanManager)beanManager);
            for (BeanDeploymentArchive child : bda.getBeanDeploymentArchives()) {
                if (seenBdas.contains(child)) continue;
                this.visit(child, seenBdas);
            }
        }
    }
}

