/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import org.jboss.logging.Logger;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.jaxws.client.DispatchBinding;
import org.jboss.ws.core.soap.SOAPBodyElementDoc;
import org.jboss.ws.core.soap.SOAPBodyImpl;
import org.jboss.ws.core.soap.SOAPContentElement;
import org.jboss.ws.core.soap.SOAPMessageImpl;
import org.jboss.ws.core.soap.XMLFragment;
import org.jboss.wsf.common.DOMWriter;
import org.w3c.dom.Node;

public class DispatchSOAPBinding
extends DispatchBinding {
    private final Logger log = Logger.getLogger(DispatchSOAPBinding.class);
    private JAXBContext jaxbContext;
    private Class type;
    private Service.Mode mode;

    public DispatchSOAPBinding(Service.Mode mode, Class type, JAXBContext jaxbContext) {
        this.mode = mode;
        this.type = type;
        this.jaxbContext = jaxbContext;
    }

    public MessageAbstraction getRequestMessage(Object obj) {
        SOAPMessageImpl reqMsg = null;
        try {
            MessageFactory factory = MessageFactory.newInstance();
            if (SOAPMessage.class.isAssignableFrom(this.type)) {
                reqMsg = (SOAPMessageImpl)obj;
            } else if (Source.class.isAssignableFrom(this.type)) {
                Source source = (Source)obj;
                if (this.mode == Service.Mode.PAYLOAD) {
                    reqMsg = (SOAPMessageImpl)factory.createMessage();
                    SOAPBodyImpl soapBody = (SOAPBodyImpl)reqMsg.getSOAPBody();
                    SOAPContentElement bodyElement = new SOAPBodyElementDoc(SOAPBodyElementDoc.GENERIC_PARAM_NAME);
                    bodyElement = (SOAPContentElement)soapBody.addChildElement(bodyElement);
                    XMLFragment xmlFragment = new XMLFragment(source);
                    bodyElement.setXMLFragment(xmlFragment);
                    if (this.validateDispatch) {
                        xmlFragment.toElement();
                    }
                }
                if (this.mode == Service.Mode.MESSAGE) {
                    TransformerFactory tf = TransformerFactory.newInstance();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                    tf.newTransformer().transform(source, new StreamResult(baos));
                    reqMsg = (SOAPMessageImpl)factory.createMessage(null, (InputStream)new ByteArrayInputStream(baos.toByteArray()));
                }
            } else if (this.jaxbContext != null) {
                Marshaller marshaller = this.jaxbContext.createMarshaller();
                marshaller.setProperty("jaxb.fragment", (Object)true);
                ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                marshaller.marshal(obj, (OutputStream)baos);
                reqMsg = (SOAPMessageImpl)factory.createMessage();
                SOAPBodyImpl soapBody = (SOAPBodyImpl)reqMsg.getSOAPBody();
                SOAPContentElement bodyElement = new SOAPBodyElementDoc(SOAPBodyElementDoc.GENERIC_PARAM_NAME);
                bodyElement = (SOAPContentElement)soapBody.addChildElement(bodyElement);
                StreamSource source = new StreamSource(new ByteArrayInputStream(baos.toByteArray()));
                bodyElement.setXMLFragment(new XMLFragment(source));
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WebServiceException("Cannot create request message", (Throwable)ex);
        }
        if (reqMsg == null) {
            throw new WebServiceException("Cannot create request message for: " + obj);
        }
        return reqMsg;
    }

    public Object getReturnObject(MessageAbstraction message) {
        SOAPMessage resMsg = (SOAPMessage)message;
        Object retObj = null;
        try {
            if (SOAPMessage.class.isAssignableFrom(this.type)) {
                retObj = resMsg;
            } else if (Source.class.isAssignableFrom(this.type)) {
                if (this.mode == Service.Mode.PAYLOAD) {
                    SOAPBodyImpl soapBody = (SOAPBodyImpl)resMsg.getSOAPBody();
                    SOAPFault soapFault = soapBody.getFault();
                    if (soapFault != null) {
                        throw new SOAPFaultException(soapFault);
                    }
                    SOAPBodyElement soapElement = soapBody.getBodyElement();
                    retObj = new DOMSource((Node)soapElement);
                }
                if (this.mode == Service.Mode.MESSAGE) {
                    SOAPEnvelope soapEnvelope = resMsg.getSOAPPart().getEnvelope();
                    String xmlMessage = DOMWriter.printNode((Node)soapEnvelope, (boolean)false);
                    retObj = new StreamSource(new StringReader(xmlMessage));
                }
            } else if (this.jaxbContext != null) {
                SOAPBodyImpl soapBody = (SOAPBodyImpl)resMsg.getSOAPBody();
                SOAPBodyElement soapElement = soapBody.getBodyElement();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("JAXB unmarshal: " + DOMWriter.printNode((Node)soapElement, (boolean)false)));
                }
                Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
                retObj = unmarshaller.unmarshal((Node)soapElement);
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WebServiceException("Cannot process response message", (Throwable)ex);
        }
        return retObj;
    }
}

