/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.spi.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.logging.Logger;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.ws.core.jaxws.spi.http.AbstractNettyMessage;
import org.jboss.ws.core.jaxws.spi.http.NettyCallbackHandlerImpl;
import org.jboss.ws.core.jaxws.spi.http.NettyHttp11Message;
import org.jboss.ws.core.server.netty.AbstractNettyRequestHandler;
import org.jboss.wsf.spi.invocation.InvocationContext;

final class NettyRequestHandlerImpl
extends AbstractNettyRequestHandler {
    private static final Logger LOG = Logger.getLogger(NettyRequestHandlerImpl.class);

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) {
        HttpRequest request = (HttpRequest)event.getMessage();
        if (HttpVersion.HTTP_1_1.equals((Object)request.getProtocolVersion())) {
            NettyHttp11Message message = new NettyHttp11Message(ctx.getChannel(), request);
            InvocationContext invCtx = new InvocationContext();
            invCtx.setProperty("org.jboss.ws.http.netty.Message", (Object)message);
            try {
                String requestPath = this.getRequestPath(request.getUri());
                String httpMethod = request.getMethod().getName();
                this.handle(requestPath, httpMethod, ((AbstractNettyMessage)message).getInputStream(), ((AbstractNettyMessage)message).getOutputStream(), invCtx);
            }
            catch (Exception e) {
                LOG.error((Object)e);
                this.sendError(event, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
        } else {
            LOG.fatal((Object)"HTTP 1.0 not supported");
            this.sendError(event, HttpResponseStatus.NOT_IMPLEMENTED);
        }
    }

    private void handle(String requestPath, String httpMethod, InputStream is, OutputStream os, InvocationContext invCtx) throws IOException {
        NettyCallbackHandlerImpl handler = (NettyCallbackHandlerImpl)this.getCallback(requestPath);
        if (handler == null) {
            String errorMessage = "No callback handler registered for path: " + requestPath;
            LOG.warn((Object)errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        handler.handle(httpMethod, is, os, invCtx);
    }

    private void sendError(MessageEvent event, HttpResponseStatus statusCode) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, statusCode);
        response.setHeader("Content-Type", "text/plain; charset=UTF-8");
        event.getChannel().write((Object)response).awaitUninterruptibly();
    }

    private String getRequestPath(String requestPath) {
        String retVal = requestPath;
        int paramIndex = retVal.indexOf(63);
        if (paramIndex != -1) {
            retVal = retVal.substring(0, paramIndex);
        }
        if (retVal.startsWith("http")) {
            try {
                retVal = new URL(retVal).getPath();
            }
            catch (MalformedURLException mue) {
                LOG.error((Object)mue.getMessage(), (Throwable)mue);
            }
        }
        while (retVal.endsWith("/")) {
            retVal = retVal.substring(0, retVal.length() - 1);
        }
        return retVal;
    }
}

