/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Source;
import javax.xml.ws.handler.MessageContext;
import org.jboss.logging.Logger;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.jaxws.handler.MessageContextJAXWS;
import org.jboss.ws.core.soap.DOMContent;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.ObjectContent;
import org.jboss.ws.core.soap.SAAJVisitor;
import org.jboss.ws.core.soap.SOAPContent;
import org.jboss.ws.core.soap.SOAPContentAccess;
import org.jboss.ws.core.soap.SOAPElementImpl;
import org.jboss.ws.core.soap.XMLContent;
import org.jboss.ws.core.soap.XMLFragment;
import org.jboss.ws.extensions.xop.XOPContext;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.wsf.common.DOMWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class SOAPContentElement
extends SOAPElementImpl
implements SOAPContentAccess {
    private static Logger log = Logger.getLogger(SOAPContentElement.class);
    public static final QName GENERIC_PARAM_NAME = new QName("genericParam");
    public static final QName GENERIC_RETURN_NAME = new QName("genericReturn");
    private ParameterMetaData paramMetaData;
    protected SOAPContent soapContent = new DOMContent(this);
    private boolean lockDOMExpansion = false;

    public SOAPContentElement(Name name) {
        super(name);
    }

    public SOAPContentElement(QName qname) {
        super(qname);
    }

    public SOAPContentElement(SOAPElementImpl element) {
        super(element);
    }

    public ParameterMetaData getParamMetaData() {
        if (this.paramMetaData == null) {
            throw new IllegalStateException("Parameter meta data not available");
        }
        return this.paramMetaData;
    }

    public void setParamMetaData(ParameterMetaData paramMetaData) {
        this.paramMetaData = paramMetaData;
    }

    public QName getXmlType() {
        return this.getParamMetaData().getXmlType();
    }

    public Class getJavaType() {
        return this.getParamMetaData().getJavaType();
    }

    protected SOAPContent.State transitionTo(SOAPContent.State nextState) {
        SOAPContent.State prevState = this.soapContent.getState();
        if (nextState != prevState) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"-----------------------------------");
                log.debug((Object)("Transitioning from " + (Object)((Object)prevState) + " to " + (Object)((Object)nextState)));
            }
            this.lockDOMExpansion = true;
            this.soapContent = this.soapContent.transitionTo(nextState);
            this.lockDOMExpansion = false;
            log.debug((Object)"-----------------------------------");
        }
        return prevState;
    }

    @Override
    public Source getPayload() {
        if (this.soapContent.getState() == SOAPContent.State.OBJECT_VALID) {
            this.transitionTo(SOAPContent.State.DOM_VALID);
        }
        return this.soapContent.getPayload();
    }

    @Override
    public XMLFragment getXMLFragment() {
        this.transitionTo(SOAPContent.State.XML_VALID);
        return this.soapContent.getXMLFragment();
    }

    @Override
    public void setXMLFragment(XMLFragment xmlFragment) {
        this.soapContent = new XMLContent(this);
        this.soapContent.setXMLFragment(xmlFragment);
    }

    @Override
    public Object getObjectValue() {
        this.transitionTo(SOAPContent.State.OBJECT_VALID);
        return this.soapContent.getObjectValue();
    }

    @Override
    public void setObjectValue(Object objValue) {
        this.soapContent = new ObjectContent(this);
        this.soapContent.setObjectValue(objValue);
    }

    @Override
    public SOAPElement addChildElement(SOAPElement child) throws SOAPException {
        log.trace((Object)("addChildElement: " + child));
        this.expandToDOM();
        return super.addChildElement(child);
    }

    @Override
    public SOAPElement addChildElement(String localName, String prefix) throws SOAPException {
        log.trace((Object)("addChildElement: [localName=" + localName + ",prefix=" + prefix + "]"));
        this.expandToDOM();
        return super.addChildElement(localName, prefix);
    }

    @Override
    public SOAPElement addChildElement(String localName, String prefix, String uri) throws SOAPException {
        log.trace((Object)("addChildElement: [localName=" + localName + ",prefix=" + prefix + ",uri=" + uri + "]"));
        this.expandToDOM();
        return super.addChildElement(localName, prefix, uri);
    }

    @Override
    public SOAPElement addChildElement(Name name) throws SOAPException {
        log.trace((Object)("addChildElement: [name=" + name + "]"));
        this.expandToDOM();
        return super.addChildElement(name);
    }

    @Override
    public SOAPElement addChildElement(String name) throws SOAPException {
        log.trace((Object)("addChildElement: [name=" + name + "]"));
        this.expandToDOM();
        return super.addChildElement(name);
    }

    @Override
    public SOAPElement addTextNode(String value) throws SOAPException {
        log.trace((Object)("addTextNode: [value=" + value + "]"));
        this.expandToDOM();
        return super.addTextNode(value);
    }

    @Override
    public Iterator getChildElements() {
        log.trace((Object)"getChildElements");
        this.expandToDOM();
        return super.getChildElements();
    }

    @Override
    public Iterator getChildElements(Name name) {
        log.trace((Object)("getChildElements: [name=" + name + "]"));
        this.expandToDOM();
        return super.getChildElements(name);
    }

    @Override
    public void removeContents() {
        log.trace((Object)"removeContents");
        this.expandToDOM();
        super.removeContents();
    }

    @Override
    public Iterator getAllAttributes() {
        return super.getAllAttributes();
    }

    @Override
    public String getAttribute(String name) {
        return super.getAttribute(name);
    }

    @Override
    public Attr getAttributeNode(String name) {
        return super.getAttributeNode(name);
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        return super.getAttributeNodeNS(namespaceURI, localName);
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) {
        return super.getAttributeNS(namespaceURI, localName);
    }

    @Override
    public String getAttributeValue(Name name) {
        return super.getAttributeValue(name);
    }

    @Override
    public SOAPElement addAttribute(Name name, String value) throws SOAPException {
        log.trace((Object)("addAttribute: [name=" + name + ",value=" + value + "]"));
        this.expandToDOM();
        return super.addAttribute(name, value);
    }

    @Override
    public SOAPElement addNamespaceDeclaration(String prefix, String nsURI) {
        log.trace((Object)("addNamespaceDeclaration: [prefix=" + prefix + ",nsURI=" + nsURI + "]"));
        this.expandToDOM();
        return super.addNamespaceDeclaration(prefix, nsURI);
    }

    @Override
    public Name getElementName() {
        return super.getElementName();
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        log.trace((Object)("getElementsByTagName: [name=" + name + "]"));
        this.expandToDOM();
        return super.getElementsByTagName(name);
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        log.trace((Object)("getElementsByTagName: [nsURI=" + namespaceURI + ",localName=" + localName + "]"));
        this.expandToDOM();
        return super.getElementsByTagNameNS(namespaceURI, localName);
    }

    @Override
    public String getEncodingStyle() {
        return super.getEncodingStyle();
    }

    @Override
    public Iterator getNamespacePrefixes() {
        return super.getNamespacePrefixes();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return super.getNamespaceURI(prefix);
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return super.getSchemaTypeInfo();
    }

    @Override
    public String getTagName() {
        return super.getTagName();
    }

    @Override
    public Iterator getVisibleNamespacePrefixes() {
        return super.getVisibleNamespacePrefixes();
    }

    @Override
    public boolean hasAttribute(String name) {
        return super.hasAttribute(name);
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return super.hasAttributeNS(namespaceURI, localName);
    }

    @Override
    public boolean removeAttribute(Name name) {
        log.trace((Object)("removeAttribute: " + name.getQualifiedName()));
        this.expandToDOM();
        return super.removeAttribute(name);
    }

    @Override
    public void removeAttribute(String name) throws DOMException {
        log.trace((Object)("removeAttribute: " + name));
        this.expandToDOM();
        super.removeAttribute(name);
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        log.trace((Object)("removeAttribute: " + oldAttr.getNodeName()));
        this.expandToDOM();
        return super.removeAttributeNode(oldAttr);
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        log.trace((Object)("removeAttributeNS: {" + namespaceURI + "}" + localName));
        this.expandToDOM();
        super.removeAttributeNS(namespaceURI, localName);
    }

    @Override
    public boolean removeNamespaceDeclaration(String prefix) {
        log.trace((Object)("removeNamespaceDeclaration: " + prefix));
        this.expandToDOM();
        return super.removeNamespaceDeclaration(prefix);
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        log.trace((Object)("setAttribute: [name=" + name + ",value=" + value + "]"));
        this.expandToDOM();
        super.setAttribute(name, value);
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        log.trace((Object)("setAttributeNode: " + newAttr));
        this.expandToDOM();
        return super.setAttributeNode(newAttr);
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        log.trace((Object)("setAttributeNodeNS: " + newAttr));
        this.expandToDOM();
        return super.setAttributeNodeNS(newAttr);
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        log.trace((Object)("setAttribute: [nsURI=" + namespaceURI + ",name=" + qualifiedName + ",value=" + value + "]"));
        this.expandToDOM();
        super.setAttributeNS(namespaceURI, qualifiedName, value);
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
        log.trace((Object)("setIdAttribute: [name=" + name + ",value=" + isId + "]"));
        this.expandToDOM();
        super.setIdAttribute(name, isId);
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        log.trace((Object)("setIdAttributeNode: [idAttr=" + idAttr + ",value=" + isId + "]"));
        this.expandToDOM();
        super.setIdAttributeNode(idAttr, isId);
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        log.trace((Object)("setIdAttributeNS: [nsURI=" + namespaceURI + ",name=" + localName + ",value=" + isId + "]"));
        this.expandToDOM();
        super.setIdAttributeNS(namespaceURI, localName, isId);
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        log.trace((Object)("appendChild: " + newChild));
        this.expandToDOM();
        return super.appendChild(newChild);
    }

    @Override
    public Node cloneNode(boolean deep) {
        log.trace((Object)("cloneNode: deep=" + deep));
        this.expandToDOM();
        return super.cloneNode(deep);
    }

    @Override
    public NodeList getChildNodes() {
        log.trace((Object)"getChildNodes");
        this.expandToDOM();
        return super.getChildNodes();
    }

    @Override
    public Node getFirstChild() {
        log.trace((Object)"getFirstChild");
        this.expandToDOM();
        return super.getFirstChild();
    }

    @Override
    public Node getLastChild() {
        log.trace((Object)"getLastChild");
        this.expandToDOM();
        return super.getLastChild();
    }

    @Override
    public String getValue() {
        log.trace((Object)"getValue");
        this.expandToDOM();
        return super.getValue();
    }

    @Override
    public boolean hasChildNodes() {
        log.trace((Object)"hasChildNodes");
        this.expandToDOM();
        return super.hasChildNodes();
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        log.trace((Object)("removeChild: " + oldChild));
        this.expandToDOM();
        return super.removeChild(oldChild);
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        log.trace((Object)("replaceChild: [new=" + newChild + ",old=" + oldChild + "]"));
        this.expandToDOM();
        return super.replaceChild(newChild, oldChild);
    }

    private void expandToDOM() {
        if (!this.lockDOMExpansion) {
            this.transitionTo(SOAPContent.State.DOM_VALID);
        }
    }

    @Override
    public void setValue(String value) {
        log.trace((Object)("setValue: " + value));
        this.expandToDOM();
        super.setValue(value);
    }

    @Override
    public NamedNodeMap getAttributes() {
        return super.getAttributes();
    }

    @Override
    public boolean hasAttributes() {
        return super.hasAttributes();
    }

    @Override
    public Node getPreviousSibling() {
        log.trace((Object)"getPreviousSibling");
        this.expandToDOM();
        return super.getPreviousSibling();
    }

    @Override
    public Node getNextSibling() {
        log.trace((Object)"getNextSibling");
        this.expandToDOM();
        return super.getNextSibling();
    }

    @Override
    public void writeElement(Writer writer) throws IOException {
        if (this.soapContent instanceof DOMContent) {
            DOMWriter dw = new DOMWriter(writer);
            CommonMessageContext ctx = MessageContextAssociation.peekMessageContext();
            if (ctx != null && Boolean.TRUE == ctx.get("org.jboss.ws.DOMContentCanonicalNormalization")) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Forcing canonical normalization of DOMContent...");
                }
                dw.setCanonical(true);
            }
            dw.print((Node)((Object)this));
        } else {
            this.transitionTo(SOAPContent.State.XML_VALID);
            this.soapContent.getXMLFragment().writeTo(writer);
        }
    }

    public void handleMTOMTransitions() {
        if (MessageContextAssociation.peekMessageContext() == null) {
            return;
        }
        if (!this.isXOPParameter()) {
            return;
        }
        boolean domContentState = this.soapContent instanceof DOMContent;
        if (!XOPContext.isMTOMEnabled()) {
            log.debug((Object)"MTOM disabled: Force inline XOP data");
            CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
            msgContext.put("org.jboss.ws.allow.expand.dom", (Object)Boolean.TRUE);
            if (msgContext instanceof MessageContextJAXWS) {
                ((MessageContextJAXWS)msgContext).setScope("org.jboss.ws.allow.expand.dom", MessageContext.Scope.APPLICATION);
            }
            this.expandToDOM();
        } else if (domContentState && XOPContext.isMTOMEnabled()) {
            log.debug((Object)"MTOM enabled: Restore XOP data");
            XOPContext.restoreXOPDataDOM(this);
        }
    }

    boolean isXOPParameter() {
        return this.paramMetaData != null && this.paramMetaData.isXOP();
    }

    @Override
    public void accept(SAAJVisitor visitor) {
        visitor.visitSOAPContentElement(this);
    }
}

