/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi.dependency;

import org.jboss.classloader.spi.ClassFoundEvent;
import org.jboss.classloader.spi.ClassFoundHandler;
import org.jboss.classloader.spi.ClassLoaderPolicy;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.classloading.spi.dependency.policy.ClassLoaderPolicyModule;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.ControllerStateModel;
import org.jboss.logging.Logger;

public class LifeCycle {
    private static final Logger log = Logger.getLogger(LifeCycle.class);
    private Module module;
    private LazyStartHandler lazyStart;
    private boolean lifeCycle = false;

    public LifeCycle(Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        this.module = module;
    }

    public Module getModule() {
        return this.module;
    }

    public boolean isResolved() {
        return this.module.getClassLoader() != null;
    }

    public boolean isLazyResolve() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doResolve() {
        if (!this.lifeCycle) {
            this.lifeCycle = true;
            try {
                this.resolve();
            }
            catch (Throwable t) {
                log.warn((Object)("Error in resolve: " + this), t);
            }
            finally {
                this.lifeCycle = false;
            }
        }
    }

    public void resolve() {
    }

    public void unresolve() {
    }

    public void resolved() {
    }

    public void unresolved() {
    }

    public boolean isStarted() {
        ControllerContext context = this.module.getControllerContext();
        if (context == null) {
            return false;
        }
        Controller controller = context.getController();
        ControllerStateModel model = controller.getStates();
        return !model.isBeforeState(context.getState(), ControllerState.INSTALLED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doStart() {
        if (!this.lifeCycle) {
            this.lifeCycle = true;
            try {
                this.start();
            }
            catch (Throwable t) {
                log.warn((Object)("Error in start: " + this), t);
            }
            finally {
                this.lifeCycle = false;
            }
        }
    }

    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doStop() {
        if (!this.lifeCycle) {
            this.lifeCycle = true;
            try {
                this.start();
            }
            catch (Throwable t) {
                log.warn((Object)("Error in stop: " + this), t);
            }
            finally {
                this.lifeCycle = false;
            }
        }
    }

    public void stop() {
    }

    public boolean isLazyStart() {
        return false;
    }

    protected void setUpLazyStart() {
        if (this.isStarted()) {
            return;
        }
        if (!(this.module instanceof ClassLoaderPolicyModule)) {
            throw new IllegalStateException("Cannot do lazy start for " + this.module);
        }
        ClassLoaderPolicy policy = ((ClassLoaderPolicyModule)this.module).getPolicy();
        this.lazyStart = new LazyStartHandler(policy);
    }

    protected void removeLazyStart() {
        if (this.lazyStart == null) {
            return;
        }
        this.lazyStart.cleanup();
        this.lazyStart = null;
    }

    void fireResolved() {
        if (this.isLazyStart()) {
            this.setUpLazyStart();
        }
        this.resolved();
    }

    void fireUnresolved() {
        this.removeLazyStart();
        this.unresolved();
    }

    public String toString() {
        return this.getClass().getName() + "{" + this.getModule() + "}";
    }

    private class LazyStartHandler
    implements ClassFoundHandler {
        ClassLoaderPolicy policy;

        public LazyStartHandler(ClassLoaderPolicy policy) {
            this.policy = policy;
            policy.addClassFoundHandler((ClassFoundHandler)this);
        }

        public void classFound(ClassFoundEvent event) {
            LifeCycle.this.removeLazyStart();
            if (!LifeCycle.this.isStarted()) {
                LifeCycle.this.start();
            }
        }

        public void cleanup() {
            this.policy.removeClassFoundHandler((ClassFoundHandler)this);
        }
    }
}

