/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.system;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemMap;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.NetConnection;
import org.hyperic.sigar.NetInterfaceStat;
import org.hyperic.sigar.OperatingSystem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.Swap;
import org.rhq.core.system.CpuInformation;
import org.rhq.core.system.FileSystemInfo;
import org.rhq.core.system.NetworkAdapterInfo;
import org.rhq.core.system.NetworkAdapterStats;
import org.rhq.core.system.NetworkStats;
import org.rhq.core.system.OperatingSystemType;
import org.rhq.core.system.ProcessExecution;
import org.rhq.core.system.ProcessExecutionResults;
import org.rhq.core.system.ProcessInfo;
import org.rhq.core.system.ServiceInfo;
import org.rhq.core.system.SigarAccess;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.system.SystemInfoException;
import org.rhq.core.system.SystemInfoFactory;
import org.rhq.core.system.pquery.ProcessInfoQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeSystemInfo
implements SystemInfo {
    private final Log log = LogFactory.getLog(NativeSystemInfo.class);
    private SigarProxy sigar = SigarAccess.getSigar();

    @Override
    public boolean isNative() {
        return true;
    }

    @Override
    public OperatingSystemType getOperatingSystemType() {
        OperatingSystem os = OperatingSystem.getInstance();
        if ("Linux".equals(os.getName())) {
            return OperatingSystemType.LINUX;
        }
        if ("Solaris".equals(os.getName())) {
            return OperatingSystemType.SOLARIS;
        }
        if ("Win32".equals(os.getName())) {
            return OperatingSystemType.WINDOWS;
        }
        if ("HPUX".equals(os.getName())) {
            return OperatingSystemType.HPUX;
        }
        if ("AIX".equals(os.getName())) {
            return OperatingSystemType.AIX;
        }
        if ("MacOSX".equals(os.getName())) {
            return OperatingSystemType.OSX;
        }
        if ("FreeBSD".equals(os.getName())) {
            return OperatingSystemType.BSD;
        }
        return OperatingSystemType.JAVA;
    }

    @Override
    public String getOperatingSystemName() {
        return OperatingSystem.getInstance().getName();
    }

    @Override
    public String getOperatingSystemVersion() {
        return OperatingSystem.getInstance().getVersion();
    }

    @Override
    public String getHostname() throws SystemInfoException {
        try {
            return this.sigar.getNetInfo().getHostName();
        }
        catch (Exception e) {
            try {
                return InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException uhe) {
                throw new SystemInfoException(e);
            }
        }
    }

    @Override
    public List<NetworkAdapterInfo> getAllNetworkAdapters() throws SystemInfoException {
        ArrayList<NetworkAdapterInfo> adapters = new ArrayList<NetworkAdapterInfo>();
        try {
            String[] interfaceNames = this.sigar.getNetInterfaceList();
            if (interfaceNames != null) {
                for (String interfaceName : interfaceNames) {
                    if (interfaceName.indexOf(58) != -1) continue;
                    adapters.add(new NetworkAdapterInfo(this.sigar.getNetInterfaceConfig(interfaceName)));
                }
            }
        }
        catch (Exception e) {
            throw new SystemInfoException(e);
        }
        return adapters;
    }

    @Override
    public NetworkAdapterStats getNetworkAdapterStats(String interfaceName) {
        try {
            NetInterfaceStat interfaceStat = this.sigar.getNetInterfaceStat(interfaceName);
            return new NetworkAdapterStats(interfaceStat);
        }
        catch (SigarException e) {
            throw new SystemInfoException(e);
        }
    }

    @Override
    public NetworkStats getNetworkStats(String addressName, int port) {
        try {
            int flags = 19;
            NetConnection[] conns = this.sigar.getNetConnectionList(flags);
            InetAddress matchAddress = InetAddress.getByName(addressName);
            ArrayList<NetConnection> matches = new ArrayList<NetConnection>();
            for (NetConnection conn : conns) {
                InetAddress connAddress = InetAddress.getByName(conn.getLocalAddress());
                if (conn.getLocalPort() != (long)port || !matchAddress.equals(connAddress)) continue;
                matches.add(conn);
            }
            NetworkStats stats = new NetworkStats(matches.toArray(new NetConnection[matches.size()]));
            return stats;
        }
        catch (SigarException e) {
            throw new SystemInfoException(e);
        }
        catch (UnknownHostException e) {
            throw new SystemInfoException(e);
        }
    }

    private List<InetAddress> getInetAddressInList(String address) throws UnknownHostException {
        ArrayList<InetAddress> inetAddresses = new ArrayList<InetAddress>();
        if (address != null) {
            inetAddresses.add(InetAddress.getByName(address));
        }
        return inetAddresses;
    }

    @Override
    public List<ServiceInfo> getAllServices() throws SystemInfoException {
        throw new UnsupportedOperationException("Cannot get services for this plaform");
    }

    @Override
    public List<ProcessInfo> getAllProcesses() {
        ArrayList<ProcessInfo> processes = new ArrayList<ProcessInfo>();
        long[] pids = null;
        int timeout = 120000;
        this.log.debug((Object)"Retrieving PIDs of all running processes...");
        long startTime = System.currentTimeMillis();
        try {
            pids = this.sigar.getProcList();
            long elapsedTime = System.currentTimeMillis() - startTime;
            this.log.debug((Object)("Retrieval of " + pids.length + " PIDs took " + elapsedTime + " ms."));
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to retrieve PIDs of all running processes.", (Throwable)e);
        }
        if (pids != null) {
            for (long pid : pids) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Loading process info for pid " + pid + "..."));
                }
                ProcessInfo info = new ProcessInfo(pid, this.sigar);
                processes.add(info);
            }
        }
        return processes;
    }

    @Override
    public List<ProcessInfo> getProcesses(String piq) {
        ProcessInfoQuery piql = new ProcessInfoQuery(this.getAllProcesses());
        return piql.query(piq);
    }

    @Override
    public ProcessInfo getThisProcess() {
        long self = this.sigar.getPid();
        ProcessInfo info = new ProcessInfo(self);
        return info;
    }

    @Override
    public ProcessExecutionResults executeProcess(ProcessExecution processExecution) {
        return SystemInfoFactory.createJavaSystemInfo().executeProcess(processExecution);
    }

    @Override
    public int getNumberOfCpus() {
        try {
            return this.sigar.getCpuPercList().length;
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Cannot get number of CPUs from native layer", e);
        }
    }

    @Override
    public Mem getMemoryInfo() {
        try {
            return this.sigar.getMem();
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Cannot get memory info from native layer", e);
        }
    }

    @Override
    public Swap getSwapInfo() {
        try {
            return this.sigar.getSwap();
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Cannot get swap info from native layer", e);
        }
    }

    @Override
    public String readLineFromConsole(boolean noEcho) throws IOException {
        String input = noEcho ? Sigar.getPassword((String)"") : new BufferedReader(new InputStreamReader(System.in)).readLine();
        return input;
    }

    @Override
    public void writeLineToConsole(String line) throws IOException {
        System.out.print(line);
    }

    @Override
    public CpuInformation getCpu(int cpuIndex) {
        return new CpuInformation(cpuIndex, this.sigar);
    }

    @Override
    public List<FileSystemInfo> getFileSystems() {
        ArrayList mountPoints = new ArrayList();
        try {
            FileSystemMap map = this.sigar.getFileSystemMap();
            mountPoints.addAll(map.keySet());
        }
        catch (Exception e) {
            this.log.warn((Object)"Cannot obtain native file system information", (Throwable)e);
        }
        ArrayList<FileSystemInfo> infos = new ArrayList<FileSystemInfo>();
        for (String mountPoint : mountPoints) {
            infos.add(new FileSystemInfo(mountPoint));
        }
        return infos;
    }

    @Override
    public FileSystemInfo getFileSystem(String path) {
        String mountPoint = null;
        try {
            FileSystem mountPointForPath = this.sigar.getFileSystemMap().getMountPoint(path);
            if (mountPointForPath != null) {
                mountPoint = mountPointForPath.getDirName();
            }
        }
        catch (Throwable e) {
            this.log.warn((Object)("Cannot obtain native file system information for [" + path + "]"), e);
        }
        FileSystemInfo fileSystem = new FileSystemInfo(mountPoint);
        return fileSystem;
    }

    @Override
    public String getSystemArchitecture() {
        OperatingSystem op = OperatingSystem.getInstance();
        return op.getArch();
    }
}

