/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.nointerface.impl.invocationhandler;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.ejb3.endpoint.Endpoint;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;

public class NoInterfaceViewInvocationHandler
implements InvocationHandler {
    private static final Method METHOD_EQUALS;
    private static final Method METHOD_HASH_CODE;
    private static final Method METHOD_TO_STRING;
    private static Logger logger;
    private KernelControllerContext endpointContext;
    private Serializable session;

    public NoInterfaceViewInvocationHandler(KernelControllerContext endpointContext, Serializable session) {
        assert (endpointContext != null) : "Endpoint context is null for no-interface view invocation handler";
        this.endpointContext = endpointContext;
        this.session = session;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return this.handleDirectly(proxy, method, args);
        }
        catch (CannotHandleDirectlyException chde) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Cannot handle method: " + method.getName() + " in " + this.getClass().getName()));
            }
            Endpoint endpoint = this.getInstalledEndpoint();
            assert (endpoint != null) : "No endpoint associated with context " + this.endpointContext + " - cannot invoke the method on bean";
            return endpoint.invoke(this.session, null, method, args);
        }
    }

    public KernelControllerContext getContainerContext() {
        return this.endpointContext;
    }

    public Endpoint getInstalledEndpoint() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Pushing the endpoint context to INSTALLED state from its current state = " + this.endpointContext.getState().getStateString()));
        }
        try {
            this.endpointContext.getController().change((ControllerContext)this.endpointContext, ControllerState.INSTALLED);
            Endpoint endpoint = (Endpoint)this.endpointContext.getTarget();
            return endpoint;
        }
        catch (Throwable t) {
            throw new RuntimeException("Error getting endpoint out of container KernelControllerContext " + this.endpointContext, t);
        }
    }

    private Endpoint getEndpoint() {
        Object endpoint = this.endpointContext.getTarget();
        assert (endpoint instanceof Endpoint) : "Unexpected type " + endpoint.getClass().getName() + " found in context " + this.endpointContext + " Expected " + Endpoint.class.getName();
        return (Endpoint)endpoint;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof NoInterfaceViewInvocationHandler)) {
            return false;
        }
        NoInterfaceViewInvocationHandler otherNoInterfaceViewInvocationHandler = (NoInterfaceViewInvocationHandler)other;
        if (!this.getInstalledEndpoint().equals(otherNoInterfaceViewInvocationHandler.getInstalledEndpoint())) {
            return false;
        }
        return this.session.equals(otherNoInterfaceViewInvocationHandler.session);
    }

    public int hashCode() {
        int hashCode = this.getInstalledEndpoint().hashCode();
        if (this.session != null) {
            hashCode += this.session.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("No-Interface view for endpoint [ " + this.getEndpoint() + " ]");
        if (this.session != null) {
            sb.append(" and session " + this.session);
        }
        return sb.toString();
    }

    private Object handleDirectly(Object proxy, Method method, Object[] args) throws CannotHandleDirectlyException {
        if (method.equals(METHOD_EQUALS)) {
            Object other = args[0];
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (!(other instanceof NoInterfaceViewInvocationHandler)) {
                return other.equals(this);
            }
            return this.equals(other);
        }
        if (method.equals(METHOD_HASH_CODE)) {
            return this.hashCode();
        }
        if (method.equals(METHOD_TO_STRING)) {
            return this.toString();
        }
        throw new CannotHandleDirectlyException();
    }

    static {
        try {
            METHOD_EQUALS = Object.class.getDeclaredMethod("equals", Object.class);
            METHOD_HASH_CODE = Object.class.getDeclaredMethod("hashCode", new Class[0]);
            METHOD_TO_STRING = Object.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        logger = Logger.getLogger(NoInterfaceViewInvocationHandler.class);
    }

    private class CannotHandleDirectlyException
    extends Exception {
        private CannotHandleDirectlyException() {
        }
    }
}

