/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.nointerface.impl.jndi;

import javax.naming.Context;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.api.annotations.Start;
import org.jboss.beans.metadata.api.annotations.Stop;
import org.jboss.beans.metadata.api.model.FromContext;
import org.jboss.ejb3.nointerface.impl.jndi.StatefulNoInterfaceJNDIBinder;
import org.jboss.ejb3.nointerface.impl.jndi.StatelessNoInterfaceJNDIBinder;
import org.jboss.ejb3.nointerface.spi.jndi.NoInterfaceViewJNDIBinder;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.metadata.ejb.jboss.jndi.resolver.impl.JNDIPolicyBasedJNDINameResolverFactory;
import org.jboss.metadata.ejb.jboss.jndi.resolver.spi.SessionBean31JNDINameResolver;
import org.jboss.metadata.ejb.jboss.jndipolicy.plugins.DefaultJNDIBindingPolicyFactory;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy;

public class NoInterfaceViewJNDIBinderFacade {
    private static Logger logger = Logger.getLogger(NoInterfaceViewJNDIBinderFacade.class);
    @Inject(dependentState="Described", fromContext=FromContext.CONTEXT)
    protected KernelControllerContext endpointContext;
    private Class<?> beanClass;
    private JBossSessionBean31MetaData sessionBeanMetadata;
    private Context jndiCtx;
    private SessionBean31JNDINameResolver jndiNameResolver;

    public NoInterfaceViewJNDIBinderFacade(Context ctx, Class<?> beanClass, JBossSessionBean31MetaData sessionBeanMetadata) {
        this.jndiCtx = ctx;
        this.beanClass = beanClass;
        this.sessionBeanMetadata = sessionBeanMetadata;
    }

    @Start
    public void onStart() throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Creating no-interface view for endpoint " + this.endpointContext));
        }
        this.getNoInterfaceViewJndiBinder().bindNoInterfaceView(this.jndiCtx, this.beanClass, this.sessionBeanMetadata);
    }

    @Stop
    public void onStop() throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Unbinding no-interface view from JNDI, for endpoint " + this.endpointContext));
        }
        this.getNoInterfaceViewJndiBinder().unbindNoInterfaceView(this.jndiCtx, this.beanClass, this.sessionBeanMetadata);
    }

    public void setEndpointContext(KernelControllerContext endpointContext) throws Exception {
        this.endpointContext = endpointContext;
    }

    protected SessionBean31JNDINameResolver getJNDINameResolver() {
        if (this.jndiNameResolver != null) {
            return this.jndiNameResolver;
        }
        DefaultJndiBindingPolicy jndiBindingPolicy = DefaultJNDIBindingPolicyFactory.getDefaultJNDIBindingPolicy();
        return JNDIPolicyBasedJNDINameResolverFactory.getJNDINameResolver((JBossSessionBean31MetaData)this.sessionBeanMetadata, (DefaultJndiBindingPolicy)jndiBindingPolicy);
    }

    private NoInterfaceViewJNDIBinder getNoInterfaceViewJndiBinder() {
        if (this.sessionBeanMetadata.isStateful()) {
            return new StatefulNoInterfaceJNDIBinder(this.endpointContext);
        }
        if (this.sessionBeanMetadata.isStateless()) {
            return new StatelessNoInterfaceJNDIBinder(this.endpointContext);
        }
        throw new RuntimeException("Cannot get a jndi binder for bean " + this.sessionBeanMetadata.getEjbName() + " since it's neither a stateful nor a stateless bean");
    }
}

