/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.nointerface.impl.view.factory;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import org.jboss.ejb3.nointerface.spi.view.factory.NoInterfaceViewFactory;
import org.jboss.logging.Logger;

public class JavassistNoInterfaceViewFactory
implements NoInterfaceViewFactory {
    private static long nextUniqueNumberForNoViewInterfaceClassName = 0L;
    private static Object nextUniqueNumberLock = new Object();
    private static Logger logger = Logger.getLogger(JavassistNoInterfaceViewFactory.class);

    public <T> T createView(InvocationHandler invocationHandler, Class<T> beanClass) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Creating nointerface view for beanClass: " + beanClass + " with container " + invocationHandler));
        }
        ClassPool pool = new ClassPool();
        pool.appendClassPath((ClassPath)new LoaderClassPath(beanClass.getClassLoader()));
        CtClass beanCtClass = pool.get(beanClass.getName());
        CtClass proxyCtClass = pool.makeClass(beanClass.getName() + "_NoInterfaceProxy$" + this.getNextUniqueNumber(), beanCtClass);
        CtField invocationHandlerField = CtField.make((String)"private java.lang.reflect.InvocationHandler invocationHandler;", (CtClass)proxyCtClass);
        proxyCtClass.addField(invocationHandlerField);
        Set<CtMethod> beanPublicMethods = this.getAllPublicNonStaticNonFinalMethods(beanCtClass);
        for (CtMethod beanPublicMethod : beanPublicMethods) {
            if (JavassistNoInterfaceViewFactory.shouldMethodBeSkipped(pool, beanPublicMethod)) {
                logger.debug((Object)("Skipping " + beanPublicMethod.getName() + " on bean " + beanCtClass.getName() + " from no-interface view"));
                continue;
            }
            CtMethod proxyPublicMethod = CtNewMethod.copy((CtMethod)beanPublicMethod, (CtClass)proxyCtClass, null);
            proxyPublicMethod = this.overridePublicMethod(invocationHandler, beanClass, beanPublicMethod, proxyPublicMethod);
            proxyCtClass.addMethod(proxyPublicMethod);
            if (!logger.isTraceEnabled()) continue;
            logger.trace((Object)("Added overriden implementation for method " + proxyPublicMethod.getName() + " in no-interface view " + proxyCtClass.getName() + " for bean " + beanClass.getName()));
        }
        proxyCtClass.addMethod(JavassistNoInterfaceViewFactory.createEqualsMethod(pool, proxyCtClass));
        Class proxyClass = proxyCtClass.toClass(beanClass.getClassLoader(), beanClass.getProtectionDomain());
        Object proxyInstance = proxyClass.newInstance();
        Field containerInProxy = proxyClass.getDeclaredField("invocationHandler");
        containerInProxy.setAccessible(true);
        containerInProxy.set(proxyInstance, invocationHandler);
        return beanClass.cast(proxyInstance);
    }

    private <T> CtMethod overridePublicMethod(InvocationHandler container, Class<T> beanClass, CtMethod publicMethodOnBean, CtMethod publicMethodOnProxy) throws Exception {
        publicMethodOnProxy.setBody("{java.lang.reflect.Method currentMethod = " + beanClass.getName() + ".class.getMethod(\"" + publicMethodOnBean.getName() + "\",$sig);" + "return ($r) invocationHandler.invoke(this,currentMethod,$args);" + "}");
        return publicMethodOnProxy;
    }

    private Set<CtMethod> getAllPublicNonStaticNonFinalMethods(CtClass ctClass) throws Exception {
        CtMethod[] allMethods = ctClass.getMethods();
        HashSet<CtMethod> publicMethods = new HashSet<CtMethod>();
        for (CtMethod ctMethod : allMethods) {
            int modifier = ctMethod.getModifiers();
            if ((1 & modifier) != 1 || (8 & modifier) == 8 || (0x10 & modifier) == 16 || (0x100 & modifier) == 256) continue;
            publicMethods.add(ctMethod);
        }
        return publicMethods;
    }

    private boolean shouldMethodBeSkipped(CtClass beanCtClass, CtMethod ctMethod) throws Exception {
        return false;
    }

    private static boolean shouldMethodBeSkipped(ClassPool pool, CtMethod ctMethod) throws Exception {
        CtClass[] paramsToEqualsMethodInObjectClass = new CtClass[]{pool.get(Object.class.getName())};
        if (!ctMethod.getName().equals("equals")) {
            return false;
        }
        if (ctMethod.getParameterTypes().length != paramsToEqualsMethodInObjectClass.length) {
            return false;
        }
        CtClass[] paramsToEqualsMethodInOtherClass = ctMethod.getParameterTypes();
        return paramsToEqualsMethodInObjectClass[0].equals(paramsToEqualsMethodInOtherClass[0]);
    }

    private static CtMethod createEqualsMethod(ClassPool pool, CtClass proxyCtClass) throws Exception {
        String body = "{java.lang.reflect.Method currentMethod = " + Object.class.getName() + ".class.getMethod(\"equals\",$sig);" + "return ($r) invocationHandler.invoke(this,currentMethod,$args);" + "}";
        Method equals = Object.class.getMethod("equals", Object.class);
        CtClass returnType = pool.get(equals.getReturnType().getName());
        CtClass[] paramTypes = new CtClass[equals.getParameterTypes().length];
        int i = 0;
        for (Class<?> paramType : equals.getParameterTypes()) {
            paramTypes[i++] = pool.get(paramType.getName());
        }
        CtClass[] exceptionTypes = new CtClass[equals.getExceptionTypes().length];
        int j = 0;
        for (Class<?> exceptionType : equals.getExceptionTypes()) {
            exceptionTypes[j++] = pool.get(exceptionType.getName());
        }
        return CtNewMethod.make((CtClass)returnType, (String)equals.getName(), (CtClass[])paramTypes, (CtClass[])exceptionTypes, (String)body, (CtClass)proxyCtClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextUniqueNumber() {
        Object object = nextUniqueNumberLock;
        synchronized (object) {
            return ++nextUniqueNumberForNoViewInterfaceClassName;
        }
    }
}

