/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.deployers;

import java.util.List;
import javax.management.ObjectName;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractComponentDeployer;
import org.jboss.deployers.spi.deployer.helpers.DeploymentVisitor;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.system.metadata.ServiceDeployment;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.system.metadata.ServiceMetaDataParser;
import org.jboss.util.xml.DOMWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDeploymentDeployer
extends AbstractComponentDeployer<ServiceDeployment, ServiceMetaData> {
    public ServiceDeploymentDeployer() {
        this.setDeploymentVisitor(new ServiceDeploymentVisitor());
        this.setComponentVisitor(new ServiceMetaDataVisitor());
    }

    protected static void addServiceComponent(DeploymentUnit unit, ServiceMetaData service) {
        ObjectName objectName = service.getObjectName();
        String name = objectName.getCanonicalName();
        DeploymentUnit component = unit.addComponent(name);
        component.addAttachment(ServiceMetaData.class.getName(), (Object)service);
    }

    protected static void removeServiceComponent(DeploymentUnit unit, ServiceMetaData service) {
        ObjectName objectName = service.getObjectName();
        String name = objectName.getCanonicalName();
        unit.removeComponent(name);
    }

    private String maskPasswords(String original, int index) {
        StringBuilder sb = new StringBuilder(original);
        String modified = null;
        int startPasswdStringIndex = sb.indexOf(">", index);
        if (startPasswdStringIndex != -1) {
            int endPasswdStringIndex;
            if (sb.charAt(startPasswdStringIndex - 1) != '-' && (endPasswdStringIndex = sb.indexOf("<", startPasswdStringIndex)) != -1) {
                sb.replace(startPasswdStringIndex + 1, endPasswdStringIndex, "****");
            }
            if ((index = (modified = sb.toString()).toLowerCase().indexOf("password", startPasswdStringIndex)) != -1) {
                return this.maskPasswords(modified, index);
            }
            return modified;
        }
        return original;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ServiceMetaDataVisitor
    implements DeploymentVisitor<ServiceMetaData> {
        public Class<ServiceMetaData> getVisitorType() {
            return ServiceMetaData.class;
        }

        public void deploy(DeploymentUnit unit, ServiceMetaData deployment) throws DeploymentException {
            ServiceDeploymentDeployer.addServiceComponent(unit, deployment);
        }

        public void undeploy(DeploymentUnit unit, ServiceMetaData deployment) {
            ServiceDeploymentDeployer.removeServiceComponent(unit, deployment);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ServiceDeploymentVisitor
    implements DeploymentVisitor<ServiceDeployment> {
        public Class<ServiceDeployment> getVisitorType() {
            return ServiceDeployment.class;
        }

        public void deploy(DeploymentUnit unit, ServiceDeployment deployment) throws DeploymentException {
            try {
                List services = deployment.getServices();
                if (services == null) {
                    Element config = deployment.getConfig();
                    if (config == null) {
                        ServiceDeploymentDeployer.this.log.debug((Object)("Service deployment has no services: " + deployment.getName()));
                        return;
                    }
                    if (ServiceDeploymentDeployer.this.log.isDebugEnabled()) {
                        String docStr = DOMWriter.printNode((Node)config, (boolean)true);
                        int index = docStr.toLowerCase().indexOf("password");
                        if (index != -1) {
                            docStr = ServiceDeploymentDeployer.this.maskPasswords(docStr, index);
                        }
                        ServiceDeploymentDeployer.this.log.debug((Object)docStr);
                    }
                    ServiceMetaDataParser parser = new ServiceMetaDataParser(config);
                    services = parser.parse();
                    deployment.setServices(services);
                }
                if (services == null || services.isEmpty()) {
                    return;
                }
                for (ServiceMetaData service : services) {
                    ServiceDeploymentDeployer.addServiceComponent(unit, service);
                }
            }
            catch (Throwable t) {
                throw DeploymentException.rethrowAsDeploymentException((String)("Error deploying: " + deployment.getName()), (Throwable)t);
            }
        }

        public void undeploy(DeploymentUnit unit, ServiceDeployment deployment) {
            List services = deployment.getServices();
            if (services == null) {
                return;
            }
            for (ServiceMetaData service : services) {
                ObjectName objectName = service.getObjectName();
                String name = objectName.getCanonicalName();
                unit.removeComponent(name);
            }
        }
    }
}

