/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.integration.webtier.jsf;

import javax.el.ELContextListener;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.jboss.weld.integration.webtier.jsf.DummyELResolver;
import org.jboss.weld.integration.webtier.jsf.ForwardingApplication;
import org.jboss.weld.integration.webtier.jsf.ForwardingELResolver;
import org.jboss.weld.integration.webtier.util.Reflections;

public class WeldApplication
extends ForwardingApplication {
    private final Application application;
    private ExpressionFactory expressionFactory;
    private AdjustableELResolver elResolver;
    private boolean intialized;

    public WeldApplication(Application application) {
        this.application = application;
        application.addELContextListener((ELContextListener)Reflections.newInstance("org.jboss.weld.el.WeldELContextListener"));
        this.elResolver = new AdjustableELResolver();
        this.elResolver.setDelegate(new DummyELResolver());
        application.addELResolver((ELResolver)this.elResolver);
    }

    private void init() {
        if (!this.intialized && WeldApplication.beanManager() != null) {
            this.elResolver.setDelegate(WeldApplication.beanManager().getELResolver());
            this.expressionFactory = WeldApplication.beanManager().wrapExpressionFactory(this.application.getExpressionFactory());
        }
    }

    protected Application delegate() {
        this.init();
        return this.application;
    }

    public ExpressionFactory getExpressionFactory() {
        this.init();
        return this.expressionFactory;
    }

    private static BeanManager beanManager() {
        if (FacesContext.getCurrentInstance() != null && FacesContext.getCurrentInstance().getExternalContext().getContext() instanceof ServletContext) {
            ServletContext servletContext = (ServletContext)FacesContext.getCurrentInstance().getExternalContext().getContext();
            return (BeanManager)servletContext.getAttribute(BeanManager.class.getName());
        }
        return null;
    }

    private static class AdjustableELResolver
    extends ForwardingELResolver {
        private ELResolver delegate;

        private AdjustableELResolver() {
        }

        public void setDelegate(ELResolver delegate) {
            this.delegate = delegate;
        }

        protected ELResolver delegate() {
            return this.delegate;
        }
    }
}

