/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import javassist.CtConstructor;
import javassist.NotFoundException;
import org.jboss.aop.Advisor;
import org.jboss.aop.pointcut.MatcherHelper;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.Util;
import org.jboss.aop.pointcut.ast.ASTAll;
import org.jboss.aop.pointcut.ast.ASTAttribute;
import org.jboss.aop.pointcut.ast.ASTConstructor;
import org.jboss.aop.pointcut.ast.ASTException;
import org.jboss.aop.pointcut.ast.ASTStart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorMatcher
extends MatcherHelper {
    protected Advisor advisor;
    protected CtConstructor ctCon;
    protected Constructor<?> refCon;
    protected int conModifiers;
    protected String classname;

    public ConstructorMatcher(Advisor advisor, CtConstructor con, ASTStart start) throws NotFoundException {
        super(start, advisor.getManager());
        this.advisor = advisor;
        this.start = start;
        this.conModifiers = con.getModifiers();
        this.classname = con.getDeclaringClass().getName();
        this.ctCon = con;
    }

    public ConstructorMatcher(Advisor advisor, Constructor<?> con, ASTStart start) {
        super(start, advisor.getManager());
        this.advisor = advisor;
        this.start = start;
        this.conModifiers = con.getModifiers();
        this.classname = con.getDeclaringClass().getName();
        this.refCon = con;
    }

    @Override
    protected Boolean resolvePointcut(Pointcut p) {
        throw new RuntimeException("SHOULD NOT BE CALLED");
    }

    @Override
    public Object visit(ASTConstructor node, Object data) {
        return this.matches(node);
    }

    public Boolean matches(ASTConstructor node) {
        block18: {
            ArrayList nodeExceptions;
            if (node.getAttributes().size() > 0) {
                for (int i = 0; i < node.getAttributes().size(); ++i) {
                    ASTAttribute attr = (ASTAttribute)node.getAttributes().get(i);
                    if (Util.matchModifiers(attr, this.conModifiers)) continue;
                    return Boolean.FALSE;
                }
            }
            if (this.ctCon != null ? !Util.matchesClassExpr(node.getClazz(), this.ctCon.getDeclaringClass(), this.advisor) : !Util.matchesClassExpr(node.getClazz(), this.refCon.getDeclaringClass(), this.advisor)) {
                return Boolean.FALSE;
            }
            if (node.getConstructorAnnotation() != null) {
                String sub = node.getConstructorAnnotation().getOriginal().substring(1);
                if (this.ctCon != null) {
                    if (!(this.advisor.getConstructorMetaData().hasGroup(this.ctCon, sub) || this.advisor.getDefaultMetaData().hasTag(sub) || this.advisor.hasAnnotation(this.ctCon, sub))) {
                        return Boolean.FALSE;
                    }
                } else if (!this.advisor.getConstructorMetaData().hasTag(this.refCon, sub) && !this.advisor.getDefaultMetaData().hasTag(sub)) {
                    try {
                        if (!this.advisor.hasAnnotation(this.refCon, sub)) {
                            return Boolean.FALSE;
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if ((nodeExceptions = node.getExceptions()).size() > 0) {
                if (this.ctCon != null) {
                    try {
                        if (!Util.matchExceptions((ArrayList<ASTException>)nodeExceptions, this.ctCon.getExceptionTypes())) {
                            return Boolean.FALSE;
                        }
                        break block18;
                    }
                    catch (NotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!Util.matchExceptions((ArrayList<ASTException>)nodeExceptions, this.refCon.getExceptionTypes())) {
                    return Boolean.FALSE;
                }
            }
        }
        if (this.ctCon != null ? !Util.matchesParameters(this.advisor, node, this.ctCon) : !Util.matchesParameters(this.advisor, node, this.refCon)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Object visit(ASTAll node, Object data) {
        block20: {
            if (node.getClazz().isAnnotation()) {
                String sub = node.getClazz().getOriginal().substring(1);
                if (this.ctCon != null) {
                    if (!(this.advisor.getConstructorMetaData().hasGroup(this.ctCon, sub) || this.advisor.getDefaultMetaData().hasTag(sub) || this.advisor.hasAnnotation(this.ctCon, sub))) {
                        return Boolean.FALSE;
                    }
                } else if (!this.advisor.getConstructorMetaData().hasTag(this.refCon, sub) && !this.advisor.getDefaultMetaData().hasTag(sub)) {
                    try {
                        if (!this.advisor.hasAnnotation(this.refCon, sub)) {
                            return Boolean.FALSE;
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            } else if (node.getClazz().isInstanceOf()) {
                if (this.ctCon != null ? !Util.subtypeOf(this.ctCon.getDeclaringClass(), node.getClazz(), this.advisor) : !Util.subtypeOf(this.refCon.getDeclaringClass(), node.getClazz(), this.advisor)) {
                    return Boolean.FALSE;
                }
            } else if (node.getClazz().isTypedef()) {
                if (this.ctCon != null) {
                    try {
                        if (!Util.matchesTypedef(this.ctCon.getDeclaringClass(), node.getClazz(), this.advisor)) {
                            return Boolean.FALSE;
                        }
                        break block20;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!Util.matchesTypedef(this.refCon.getDeclaringClass(), node.getClazz(), this.advisor)) {
                    return Boolean.FALSE;
                }
            } else if (!node.getClazz().matches(this.classname)) {
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }
}

